/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.gui.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import com.simibubi.create.content.trains.station.NoShadowFontWrapper;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.element.ScreenElement;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import de.mrjulsen.crn.Constants;
import de.mrjulsen.crn.CreateRailwaysNavigator;
import de.mrjulsen.crn.client.gui.ModGuiIcons;
import de.mrjulsen.crn.client.gui.screen.GlobalSettingsScreen;
import de.mrjulsen.crn.client.gui.screen.SearchSettingsScreen;
import de.mrjulsen.crn.client.gui.widgets.DLCreateIconButton;
import de.mrjulsen.crn.client.gui.widgets.ModDestinationSuggestions;
import de.mrjulsen.crn.client.gui.widgets.RouteEntryOverviewWidget;
import de.mrjulsen.crn.config.ModClientConfig;
import de.mrjulsen.crn.config.ModCommonConfig;
import de.mrjulsen.crn.data.ClientTrainStationSnapshot;
import de.mrjulsen.crn.data.GlobalSettingsManager;
import de.mrjulsen.crn.data.SimpleRoute;
import de.mrjulsen.crn.data.TrainStationAlias;
import de.mrjulsen.crn.event.listeners.IJourneyListenerClient;
import de.mrjulsen.crn.event.listeners.JourneyListenerManager;
import de.mrjulsen.crn.network.InstanceManager;
import de.mrjulsen.crn.network.packets.cts.NavigationRequestPacket;
import de.mrjulsen.crn.network.packets.cts.NearestStationRequestPacket;
import de.mrjulsen.mcdragonlib.client.gui.DLScreen;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLEditBox;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLTooltip;
import de.mrjulsen.mcdragonlib.client.util.Graphics;
import de.mrjulsen.mcdragonlib.client.util.GuiAreaDefinition;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.client.util.WidgetsCollection;
import de.mrjulsen.mcdragonlib.core.EAlignment;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.TimeUtils;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import org.lwjgl.opengl.GL11;

public class NavigatorScreen
extends DLScreen
implements IJourneyListenerClient {
    private static final ResourceLocation GUI = new ResourceLocation("createrailwaysnavigator", "textures/gui/navigator.png");
    private static final int GUI_WIDTH = 255;
    private static final int GUI_HEIGHT = 247;
    private static final int DEFAULT_ICON_BUTTON_WIDTH = 18;
    private static final int DEFAULT_ICON_BUTTON_HEIGHT = 18;
    private static final int ENTRIES_START_Y_OFFSET = 10;
    private static final int ENTRY_SPACING = 4;
    private final int AREA_X = 16;
    private final int AREA_Y = 67;
    private final int AREA_W = 220;
    private final int AREA_H = 143;
    private int guiLeft;
    private int guiTop;
    private boolean initialized = false;
    private int angle = 0;
    private DLCreateIconButton locationButton;
    private DLCreateIconButton searchButton;
    private DLCreateIconButton goToTopButton;
    private DLCreateIconButton globalSettingsButton;
    private DLCreateIconButton searchSettingsButton;
    private DLEditBox fromBox;
    private DLEditBox toBox;
    private LerpedFloat scroll = LerpedFloat.linear().startWithValue(0.0);
    private ModDestinationSuggestions destinationSuggestions;
    private GuiAreaDefinition switchButtonsArea;
    private final WidgetsCollection routesCollection = new WidgetsCollection();
    private SimpleRoute[] routes;
    private String stationFrom = "";
    private String stationTo = "";
    private long lastRefreshedTime;
    private final NavigatorScreen instance;
    private final Level level;
    private final Font shadowlessFont;
    private final UUID clientId = UUID.randomUUID();
    private boolean isLoadingRoutes = false;
    private boolean generatingRouteEntries = false;
    private final MutableComponent searchingText = TextUtils.translate((String)"gui.createrailwaysnavigator.navigator.searching");
    private final MutableComponent noConnectionsText = TextUtils.translate((String)"gui.createrailwaysnavigator.navigator.no_connections");
    private final MutableComponent notSearchedText = TextUtils.translate((String)"gui.createrailwaysnavigator.navigator.not_searched");
    private final MutableComponent errorTitle = TextUtils.translate((String)"gui.createrailwaysnavigator.navigator.error_title");
    private final MutableComponent startEndEqualText = TextUtils.translate((String)"gui.createrailwaysnavigator.navigator.start_end_equal");
    private final MutableComponent startEndNullText = TextUtils.translate((String)"gui.createrailwaysnavigator.navigator.start_end_null");
    private final MutableComponent tooltipSearch = TextUtils.translate((String)"gui.createrailwaysnavigator.navigator.search.tooltip");
    private final MutableComponent tooltipLocation = TextUtils.translate((String)"gui.createrailwaysnavigator.navigator.location.tooltip");
    private final MutableComponent tooltipSwitch = TextUtils.translate((String)"gui.createrailwaysnavigator.navigator.switch.tooltip");
    private final MutableComponent tooltipGlobalSettings = TextUtils.translate((String)"gui.createrailwaysnavigator.navigator.global_settings.tooltip");
    private final MutableComponent tooltipSearchSettings = TextUtils.translate((String)"gui.createrailwaysnavigator.navigator.search_settings.tooltip");

    public NavigatorScreen(Level level) {
        super((Component)TextUtils.translate((String)"gui.createrailwaysnavigator.navigator.title"));
        this.instance = this;
        this.level = level;
        this.shadowlessFont = new NoShadowFontWrapper(Minecraft.m_91087_().f_91062_);
    }

    @Override
    public UUID getJourneyListenerClientId() {
        return this.clientId;
    }

    private void generateRouteEntries() {
        this.generatingRouteEntries = true;
        this.routesCollection.components.clear();
        if (this.routes != null && this.routes.length > 0) {
            for (int i = 0; i < this.routes.length; ++i) {
                SimpleRoute route = this.routes[i];
                RouteEntryOverviewWidget w = new RouteEntryOverviewWidget(this.instance, this.level, this.lastRefreshedTime, this.guiLeft + 26, this.guiTop + 67 + 10 + i * 58, route, btn -> {});
                this.routesCollection.components.add(w);
            }
        }
        this.generatingRouteEntries = false;
    }

    private void clearSuggestions() {
        if (this.destinationSuggestions != null) {
            this.destinationSuggestions.getEditBox().m_94167_("");
        }
        this.destinationSuggestions = null;
    }

    private void setLastRefreshedTime() {
        this.lastRefreshedTime = this.level.m_46468_();
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_7379_() {
        JourneyListenerManager.getInstance().removeClientListenerForAll(this);
        super.m_7379_();
    }

    private void switchButtonClick() {
        this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
        String fromInput = this.fromBox.m_94155_();
        String toInput = this.toBox.m_94155_();
        this.fromBox.m_94144_(toInput);
        this.toBox.m_94144_(fromInput);
    }

    protected void m_7856_() {
        super.m_7856_();
        this.initialized = false;
        this.guiLeft = this.f_96543_ / 2 - 127;
        this.guiTop = this.f_96544_ / 2 - 123;
        this.switchButtonsArea = new GuiAreaDefinition(this.guiLeft + 190, this.guiTop + 34, 11, 12);
        this.addTooltip(DLTooltip.of((FormattedText)this.tooltipSwitch).assignedTo(this.switchButtonsArea));
        this.locationButton = (DLCreateIconButton)this.m_142416_((GuiEventListener)new DLCreateIconButton(this.guiLeft + 208, this.guiTop + 20, 18, 18, (ScreenElement)ModGuiIcons.POSITION.getAsCreateIcon()){

            public void m_5716_(double mouseX, double mouseY) {
                super.m_5716_(mouseX, mouseY);
                long id = InstanceManager.registerClientNearestStationResponseAction(result -> {
                    if (result.aliasName.isPresent()) {
                        NavigatorScreen.this.fromBox.m_94144_(result.aliasName.get().getAliasName().get());
                    }
                });
                CreateRailwaysNavigator.net().CHANNEL.sendToServer((Object)new NearestStationRequestPacket(id, ((NavigatorScreen)NavigatorScreen.this).f_96541_.f_91074_.m_20182_()));
            }
        });
        this.addTooltip(DLTooltip.of((FormattedText)this.tooltipLocation).assignedTo((AbstractWidget)this.locationButton));
        this.searchButton = (DLCreateIconButton)this.m_142416_((GuiEventListener)new DLCreateIconButton(this.guiLeft + 208, this.guiTop + 42, 18, 18, (ScreenElement)AllIcons.I_MTD_SCAN){

            public void m_5716_(double mouseX, double mouseY) {
                super.m_5716_(mouseX, mouseY);
                if (NavigatorScreen.this.stationFrom == null || NavigatorScreen.this.stationTo == null || NavigatorScreen.this.stationFrom.isBlank() || NavigatorScreen.this.stationTo.isBlank()) {
                    Minecraft.m_91087_().m_91300_().m_94922_((Toast)new SystemToast(SystemToast.SystemToastIds.PERIODIC_NOTIFICATION, (Component)NavigatorScreen.this.errorTitle, (Component)NavigatorScreen.this.startEndNullText));
                    return;
                }
                if (NavigatorScreen.this.stationFrom.equals(NavigatorScreen.this.stationTo)) {
                    Minecraft.m_91087_().m_91300_().m_94922_((Toast)new SystemToast(SystemToast.SystemToastIds.PERIODIC_NOTIFICATION, (Component)NavigatorScreen.this.errorTitle, (Component)NavigatorScreen.this.startEndEqualText));
                    return;
                }
                NavigatorScreen.this.isLoadingRoutes = true;
                long id = InstanceManager.registerClientNavigationResponseAction((routes, data) -> {
                    JourneyListenerManager.getInstance().removeClientListenerForAll(NavigatorScreen.this.instance);
                    NavigatorScreen.this.instance.routes = (SimpleRoute[])routes.toArray(SimpleRoute[]::new);
                    NavigatorScreen.this.setLastRefreshedTime();
                    NavigatorScreen.this.generateRouteEntries();
                    NavigatorScreen.this.isLoadingRoutes = false;
                    for (SimpleRoute route : NavigatorScreen.this.instance.routes) {
                        UUID listenerId = route.listen(NavigatorScreen.this.instance);
                        JourneyListenerManager.getInstance().get(listenerId, NavigatorScreen.this.instance).start();
                    }
                });
                NavigatorScreen.this.scroll.chase(0.0, (double)0.7f, LerpedFloat.Chaser.EXP);
                CreateRailwaysNavigator.net().CHANNEL.sendToServer((Object)new NavigationRequestPacket(id, NavigatorScreen.this.stationFrom, NavigatorScreen.this.stationTo));
            }
        });
        this.addTooltip(DLTooltip.of((FormattedText)this.tooltipSearch).assignedTo((AbstractWidget)this.searchButton));
        this.fromBox = this.addEditBox(this.guiLeft + 50, this.guiTop + 25, 157, 12, this.stationFrom, (Component)TextUtils.empty(), false, v -> {
            if (!this.initialized) {
                return;
            }
            this.stationFrom = v;
            this.updateEditorSubwidgets(this.fromBox);
        }, this.NO_EDIT_BOX_FOCUS_CHANGE_ACTION, null);
        this.fromBox.m_94199_(25);
        this.fromBox.m_94202_(0xFFFFFF);
        this.toBox = this.addEditBox(this.guiLeft + 50, this.guiTop + 47, 157, 12, this.stationTo, (Component)TextUtils.empty(), false, v -> {
            if (!this.initialized) {
                return;
            }
            this.stationTo = v;
            this.updateEditorSubwidgets(this.toBox);
        }, this.NO_EDIT_BOX_FOCUS_CHANGE_ACTION, null);
        this.toBox.m_94199_(25);
        this.toBox.m_94202_(0xFFFFFF);
        this.goToTopButton = (DLCreateIconButton)this.m_142416_((GuiEventListener)new DLCreateIconButton(this.guiLeft + 255 - 10, this.guiTop + 67, 18, 18, (ScreenElement)AllIcons.I_PRIORITY_VERY_HIGH){

            public void m_5716_(double mouseX, double mouseY) {
                super.m_5716_(mouseX, mouseY);
                NavigatorScreen.this.scroll.chase(0.0, (double)0.7f, LerpedFloat.Chaser.EXP);
            }
        });
        this.addTooltip(DLTooltip.of((FormattedText)Constants.TOOLTIP_GO_TO_TOP).assignedTo((AbstractWidget)this.goToTopButton));
        if (this.f_96541_.f_91074_.m_20310_(((Integer)ModCommonConfig.GLOBAL_SETTINGS_PERMISSION_LEVEL.get()).intValue())) {
            this.globalSettingsButton = (DLCreateIconButton)this.m_142416_((GuiEventListener)new DLCreateIconButton(this.guiLeft + 43, this.guiTop + 222, 18, 18, (ScreenElement)ModGuiIcons.SETTINGS.getAsCreateIcon()){

                public void m_5716_(double mouseX, double mouseY) {
                    super.m_5716_(mouseX, mouseY);
                    NavigatorScreen.this.f_96541_.m_91152_((Screen)new GlobalSettingsScreen(NavigatorScreen.this.level, (Screen)NavigatorScreen.this.instance));
                }
            });
            this.addTooltip(DLTooltip.of((FormattedText)this.tooltipGlobalSettings).assignedTo((AbstractWidget)this.globalSettingsButton));
        }
        this.searchSettingsButton = (DLCreateIconButton)this.m_142416_((GuiEventListener)new DLCreateIconButton(this.guiLeft + 21, this.guiTop + 222, 18, 18, (ScreenElement)ModGuiIcons.FILTER.getAsCreateIcon()){

            public void m_5716_(double mouseX, double mouseY) {
                super.m_5716_(mouseX, mouseY);
                NavigatorScreen.this.f_96541_.m_91152_((Screen)new SearchSettingsScreen(NavigatorScreen.this.level, (Screen)NavigatorScreen.this.instance));
            }
        });
        this.addTooltip(DLTooltip.of((FormattedText)this.tooltipSearchSettings).assignedTo((AbstractWidget)this.searchSettingsButton));
        this.m_142416_((GuiEventListener)new DLCreateIconButton(this.guiLeft + 255 - 42, this.guiTop + 222, 18, 18, (ScreenElement)AllIcons.I_MTD_CLOSE){

            public void m_5716_(double mouseX, double mouseY) {
                super.m_5716_(mouseX, mouseY);
                NavigatorScreen.this.m_7379_();
            }
        });
        this.generateRouteEntries();
        this.initialized = true;
    }

    protected void updateEditorSubwidgets(DLEditBox field) {
        this.clearSuggestions();
        this.destinationSuggestions = new ModDestinationSuggestions(this.f_96541_, (Screen)this, (EditBox)field, this.f_96547_, this.getViableStations(field), field.m_93694_() + 2 + field.f_93621_);
        this.destinationSuggestions.setAllowSuggestions(true);
        this.destinationSuggestions.updateCommandInfo();
    }

    private List<TrainStationAlias> getViableStations(DLEditBox field) {
        return ClientTrainStationSnapshot.getInstance().getAllTrainStations().stream().map(x -> GlobalSettingsManager.getInstance().getSettingsData().getAliasFor((String)x)).distinct().filter(x -> !GlobalSettingsManager.getInstance().getSettingsData().isBlacklisted((TrainStationAlias)x)).sorted((a, b) -> a.getAliasName().get().compareTo(b.getAliasName().get())).toList();
    }

    public void m_86600_() {
        this.angle += 6;
        if (this.angle > 360) {
            this.angle = 0;
        }
        this.scroll.tickChaser();
        if (this.destinationSuggestions != null) {
            this.destinationSuggestions.tick();
            if (!this.toBox.m_94204_() && !this.fromBox.m_94204_()) {
                this.clearSuggestions();
            }
        }
        if (this.goToTopButton != null) {
            this.goToTopButton.f_93624_ = this.routes != null && this.scroll.getValue() > 0.0f;
        }
        this.searchButton.f_93623_ = !this.isLoadingRoutes;
        super.m_86600_();
    }

    protected void startStencil(PoseStack matrixStack, float x, float y, float w, float h) {
        RenderSystem.m_69421_((int)1280, (boolean)Minecraft.f_91002_);
        GL11.glDisable((int)2960);
        RenderSystem.m_69929_((int)-1);
        RenderSystem.m_69421_((int)1024, (boolean)Minecraft.f_91002_);
        GL11.glEnable((int)2960);
        RenderSystem.m_69931_((int)7681, (int)7680, (int)7680);
        RenderSystem.m_69929_((int)255);
        RenderSystem.m_69925_((int)512, (int)1, (int)255);
        matrixStack.m_85836_();
        matrixStack.m_85837_((double)x, (double)y, 0.0);
        matrixStack.m_85841_(w, h, 1.0f);
        io.github.fabricators_of_create.porting_lib.util.client.GuiUtils.drawGradientRect((Matrix4f)matrixStack.m_85850_().m_85861_(), (int)-100, (int)0, (int)0, (int)1, (int)1, (int)-16777216, (int)-16777216);
        matrixStack.m_85849_();
        GL11.glEnable((int)2960);
        RenderSystem.m_69931_((int)7680, (int)7680, (int)7680);
        RenderSystem.m_69925_((int)514, (int)1, (int)255);
    }

    protected void endStencil() {
        GL11.glDisable((int)2960);
    }

    public void renderMainLayer(Graphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        pPartialTick = this.f_96541_.m_91296_();
        float scrollOffset = -this.scroll.getValue(pPartialTick);
        this.renderScreenBackground(graphics);
        GuiUtils.drawTexture((ResourceLocation)GUI, (Graphics)graphics, (int)this.guiLeft, (int)this.guiTop, (int)0, (int)0, (int)255, (int)247);
        super.renderMainLayer(graphics, pMouseX, pMouseY, pPartialTick);
        GuiUtils.drawString((Graphics)graphics, (Font)this.shadowlessFont, (int)(this.guiLeft + 19), (int)(this.guiTop + 4), (FormattedText)this.f_96539_, (int)0x4F4F4F, (EAlignment)EAlignment.LEFT, (boolean)false);
        String timeString = TimeUtils.parseTime((long)((int)((this.level.m_46468_() + 6000L) % 24000L)), (TimeUtils.TimeFormat)((TimeUtils.TimeFormat)ModClientConfig.TIME_FORMAT.get()));
        GuiUtils.drawString((Graphics)graphics, (Font)this.shadowlessFont, (int)(this.guiLeft + 255 - 22 - this.shadowlessFont.m_92895_(timeString)), (int)(this.guiTop + 4), (FormattedText)TextUtils.text((String)timeString), (int)0x4F4F4F, (EAlignment)EAlignment.LEFT, (boolean)false);
        if (!this.isLoadingRoutes && !this.generatingRouteEntries) {
            if (this.routes == null) {
                GuiUtils.drawString((Graphics)graphics, (Font)this.f_96547_, (int)(this.guiLeft + 127), (int)(this.guiTop + 32 + 123), (FormattedText)this.notSearchedText, (int)0xFFFFFF, (EAlignment)EAlignment.CENTER, (boolean)false);
                ModGuiIcons.INFO.render(graphics, this.guiLeft + 127 - 8, this.guiTop + 123);
            } else if (this.routes.length <= 0) {
                GuiUtils.drawString((Graphics)graphics, (Font)this.f_96547_, (int)(this.guiLeft + 127), (int)(this.guiTop + 32 + 123), (FormattedText)this.noConnectionsText, (int)0xFFFFFF, (EAlignment)EAlignment.CENTER, (boolean)false);
                AllIcons.I_ACTIVE.render(graphics.poseStack(), this.guiLeft + 127 - 8, this.guiTop + 123);
            } else {
                GuiUtils.enableScissor((Graphics)graphics, (int)(this.guiLeft + 16), (int)(this.guiTop + 67), (int)220, (int)143);
                graphics.poseStack().m_85837_(0.0, (double)scrollOffset, 0.0);
                int start = (int)(Math.abs(scrollOffset + 10.0f) / 58.0f);
                int end = Math.min(this.routesCollection.components.size(), start + 2 + 2);
                for (int i = start; i < end; ++i) {
                    ((AbstractWidget)this.routesCollection.components.get(i)).m_6305_(graphics.poseStack(), pMouseX, (int)((float)pMouseY - scrollOffset), pPartialTick);
                }
                GuiUtils.disableScissor((Graphics)graphics);
                GuiUtils.fillGradient((Graphics)graphics, (int)(this.guiLeft + 16), (int)(this.guiTop + 67), (int)0, (int)220, (int)10, (int)0x77000000, (int)0);
                GuiUtils.fillGradient((Graphics)graphics, (int)(this.guiLeft + 16), (int)(this.guiTop + 67 + 143 - 10), (int)0, (int)220, (int)10, (int)0, (int)0x77000000);
                double maxHeight = 10 + this.routes.length * 58 + 10;
                double aH = 144.0;
                if (aH / maxHeight < 1.0) {
                    int scrollerHeight = Math.max(10, (int)(aH * (aH / maxHeight)));
                    int startY = this.guiTop + 67 + (int)(143.0 * ((double)Math.abs(scrollOffset) / maxHeight));
                    GuiUtils.fill((Graphics)graphics, (int)(this.guiLeft + 16 + 220 - 3), (int)startY, (int)3, (int)scrollerHeight, (int)Integer.MAX_VALUE);
                }
            }
        } else {
            double offsetX = Math.sin(Math.toRadians(this.angle)) * 5.0;
            double offsetY = Math.cos(Math.toRadians(this.angle)) * 5.0;
            GuiUtils.drawString((Graphics)graphics, (Font)this.f_96547_, (int)(this.guiLeft + 127), (int)(this.guiTop + 32 + 123), (FormattedText)this.searchingText, (int)0xFFFFFF, (EAlignment)EAlignment.CENTER, (boolean)false);
            AllIcons.I_MTD_SCAN.render(graphics.poseStack(), (int)((double)(this.guiLeft + 127 - 8) + offsetX), (int)((double)(this.guiTop + 123) + offsetY));
        }
        if (this.switchButtonsArea.isInBounds((double)pMouseX, (double)pMouseY)) {
            GuiUtils.fill((Graphics)graphics, (int)this.switchButtonsArea.getLeft(), (int)this.switchButtonsArea.getTop(), (int)this.switchButtonsArea.getWidth(), (int)this.switchButtonsArea.getHeight(), (int)0x3FFFFFFF);
        }
    }

    public void renderFrontLayer(Graphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.destinationSuggestions != null) {
            graphics.poseStack().m_85836_();
            graphics.poseStack().m_85837_(0.0, 0.0, 500.0);
            this.destinationSuggestions.render(graphics.poseStack(), mouseX, mouseY);
            graphics.poseStack().m_85849_();
        }
        super.renderFrontLayer(graphics, mouseX, mouseY, partialTicks);
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        if (this.destinationSuggestions != null && this.destinationSuggestions.mouseClicked((int)pMouseX, (int)pMouseY, pButton)) {
            return true;
        }
        float scrollOffset = this.scroll.getValue();
        if (this.switchButtonsArea.isInBounds(pMouseX, pMouseY)) {
            this.switchButtonClick();
        }
        if (super.m_6375_(pMouseX, pMouseY, pButton)) {
            return true;
        }
        if (pMouseX > (double)(this.guiLeft + 16) && pMouseX < (double)(this.guiLeft + 16 + 220) && pMouseY > (double)(this.guiTop + 67) && pMouseY < (double)(this.guiTop + 67 + 143)) {
            this.routesCollection.performForEach(x -> x.m_6375_(pMouseX, pMouseY + (double)scrollOffset, pButton));
        }
        return false;
    }

    public boolean m_7933_(int pKeyCode, int pScanCode, int pModifiers) {
        if (this.destinationSuggestions != null && this.destinationSuggestions.keyPressed(pKeyCode, pScanCode, pModifiers)) {
            return true;
        }
        return super.m_7933_(pKeyCode, pScanCode, pModifiers);
    }

    public boolean m_6050_(double pMouseX, double pMouseY, double pDelta) {
        if (this.destinationSuggestions != null && this.destinationSuggestions.mouseScrolled(pMouseX, pMouseY, Mth.m_14008_((double)pDelta, (double)-1.0, (double)1.0))) {
            return true;
        }
        float chaseTarget = this.scroll.getChaseTarget();
        float max = -143.0f;
        if (this.routes != null && this.routes.length > 0) {
            max += (float)(10 + this.routes.length * 58 + 10);
        }
        if (max > 0.0f) {
            chaseTarget = (float)((double)chaseTarget - pDelta * 12.0);
            chaseTarget = Mth.m_14036_((float)chaseTarget, (float)0.0f, (float)max);
            this.scroll.chase((double)((int)chaseTarget), (double)0.7f, LerpedFloat.Chaser.EXP);
        } else {
            this.scroll.chase(0.0, (double)0.7f, LerpedFloat.Chaser.EXP);
        }
        return super.m_6050_(pMouseX, pMouseY, pDelta);
    }
}

