/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.gui.screen;

import de.mrjulsen.crn.client.gui.screen.AbstractEntryListSettingsScreen;
import de.mrjulsen.crn.client.gui.widgets.AliasEntryWidget;
import de.mrjulsen.crn.data.AliasName;
import de.mrjulsen.crn.data.GlobalSettingsManager;
import de.mrjulsen.crn.data.TrainStationAlias;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;

public class AliasSettingsScreen
extends AbstractEntryListSettingsScreen<TrainStationAlias, AliasEntryWidget> {
    public AliasSettingsScreen(Level level, Screen lastScreen) {
        super(level, lastScreen, (Component)TextUtils.translate((String)"gui.createrailwaysnavigator.alias_settings.title"));
    }

    @Override
    protected AliasEntryWidget createWidget(AbstractEntryListSettingsScreen.WidgetCreationData<TrainStationAlias, AbstractEntryListSettingsScreen<TrainStationAlias, AliasEntryWidget>> widgetData, TrainStationAlias data) {
        List<String> expandedAliasNames = widgetData.previousEntries().stream().filter(x -> x instanceof AliasEntryWidget && ((AliasEntryWidget)x).isExpanded()).map(x -> ((AliasEntryWidget)x).getAlias().getAliasName().get()).toList();
        return new AliasEntryWidget(widgetData.parent(), widgetData.x(), widgetData.y(), data, () -> this.refreshEntries(), expandedAliasNames.contains(data.getAliasName().get()));
    }

    protected TrainStationAlias[] getData(String searchText) {
        return (TrainStationAlias[])GlobalSettingsManager.getInstance().getSettingsData().getAliasList().stream().filter(x -> x.getAliasName().get().toLowerCase().contains(searchText.toLowerCase())).toArray(TrainStationAlias[]::new);
    }

    @Override
    protected void onCreateNewEntry(String value, Runnable refreshAction) {
        GlobalSettingsManager.getInstance().getSettingsData().registerAlias(new TrainStationAlias(AliasName.of(value)), refreshAction);
    }
}

