/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.gui.overlay;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.text2speech.Narrator;
import com.simibubi.create.content.trains.station.NoShadowFontWrapper;
import com.simibubi.create.foundation.gui.UIRenderHelper;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import de.mrjulsen.crn.CreateRailwaysNavigator;
import de.mrjulsen.crn.client.ClientWrapper;
import de.mrjulsen.crn.client.ModGuiUtils;
import de.mrjulsen.crn.client.gui.ModGuiIcons;
import de.mrjulsen.crn.client.gui.NavigatorToast;
import de.mrjulsen.crn.client.gui.overlay.OverlayPosition;
import de.mrjulsen.crn.client.input.ModKeys;
import de.mrjulsen.crn.client.lang.ELanguage;
import de.mrjulsen.crn.config.ModClientConfig;
import de.mrjulsen.crn.data.SimpleRoute;
import de.mrjulsen.crn.data.SimpleTrainConnection;
import de.mrjulsen.crn.event.listeners.IJourneyListenerClient;
import de.mrjulsen.crn.event.listeners.JourneyListener;
import de.mrjulsen.crn.event.listeners.JourneyListenerManager;
import de.mrjulsen.crn.network.InstanceManager;
import de.mrjulsen.crn.network.packets.cts.NextConnectionsRequestPacket;
import de.mrjulsen.crn.network.packets.cts.TrainDataRequestPacket;
import de.mrjulsen.crn.registry.ModItems;
import de.mrjulsen.crn.util.ESpeedUnit;
import de.mrjulsen.crn.util.ModUtils;
import de.mrjulsen.mcdragonlib.client.gui.DLOverlayScreen;
import de.mrjulsen.mcdragonlib.client.util.Graphics;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.core.EAlignment;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.TimeUtils;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.MultiLineLabel;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;

public class RouteDetailsOverlayScreen
extends DLOverlayScreen
implements IJourneyListenerClient {
    private static final ResourceLocation GUI = new ResourceLocation("createrailwaysnavigator", "textures/gui/overview.png");
    private static final Component title = TextUtils.translate((String)"gui.createrailwaysnavigator.route_overview.title");
    private static final int GUI_WIDTH = 226;
    private static final int GUI_HEIGHT = 118;
    private static final int SLIDING_TEXT_AREA_WIDTH = 220;
    private static final int ON_TIME = 1763935;
    private static final int DELAYED = 0xFF4242;
    private static final int COLOR_WARN = 0xFFAA00;
    private long fadeStart = 0L;
    private boolean fading = false;
    private boolean fadeInvert = true;
    private Runnable fadeDoneAction;
    private static final int ROUTE_LINE_HEIGHT = 14;
    private final Level level;
    private static final int MAX_STATION_PER_PAGE = 4;
    private Page currentPage = Page.NONE;
    private Collection<SimpleTrainConnection> connections;
    private long connectionsRefreshTime;
    private static final int CONNECTION_ENTRIES_PER_PAGE = 3;
    private static final int TIME_PER_CONNECTIONS_SUBPAGE = 200;
    private int connectionsSubPageTime = 0;
    private int connectionsSubPageIndex = 0;
    private int connectionsSubPagesCount = 0;
    private static final int TIME_PER_TRAIN_DATA_SUBPAGE = 200;
    private static final int TRAIN_DATA_PAGES = 2;
    private int trainDataSubPageTime = 0;
    private int trainDataSubPageIndex = 0;
    private final Font shadowlessFont;
    private Component slidingText = TextUtils.empty();
    private float slidingTextOffset = 0.0f;
    private int slidingTextWidth = 0;
    private MultiLineLabel messageLabel;
    private MutableComponent interruptedText;
    private LerpedFloat xPos;
    private LerpedFloat yPos;
    private static final String keyTrainDetails = "gui.createrailwaysnavigator.route_overview.train_details";
    private static final String keyTransfer = "gui.createrailwaysnavigator.route_overview.transfer";
    private static final String keyTransferWithPlatform = "gui.createrailwaysnavigator.route_overview.transfer_with_platform";
    private static final String keyTransferCount = "gui.createrailwaysnavigator.navigator.route_entry.transfer";
    private static final String keyTrainCanceled = "gui.createrailwaysnavigator.route_overview.stop_canceled";
    private static final String keyAfterJourney = "gui.createrailwaysnavigator.route_overview.after_journey";
    private static final String keyJourneyCompleted = "gui.createrailwaysnavigator.route_overview.journey_completed";
    private static final String keyNextConnections = "gui.createrailwaysnavigator.route_overview.next_connections";
    private static final String keyScheduleTransfer = "gui.createrailwaysnavigator.route_overview.schedule_transfer";
    private static final String keyConnectionEndangered = "gui.createrailwaysnavigator.route_overview.connection_endangered";
    private static final String keyConnectionMissed = "gui.createrailwaysnavigator.route_overview.connection_missed";
    private static final String keyConnectionCanceled = "gui.createrailwaysnavigator.route_overview.connection_canceled";
    private static final String keyConnectionMissedPageText = "gui.createrailwaysnavigator.route_overview.journey_interrupted_info";
    private static final String keyDepartureIn = "gui.createrailwaysnavigator.route_details.departure";
    private static final String keyTimeNow = "gui.createrailwaysnavigator.time.now";
    private static final String keyOptionsText = "gui.createrailwaysnavigator.route_overview.options";
    private static final String keyKeybindOptions = "key.createrailwaysnavigator.route_overlay_options";
    private final UUID listenerId;
    private JourneyListener listener;
    private final UUID clientId = UUID.randomUUID();

    public RouteDetailsOverlayScreen(Level level, SimpleRoute route, int width, int height) {
        this.level = level;
        this.shadowlessFont = new NoShadowFontWrapper(Minecraft.m_91087_().f_91062_);
        this.listenerId = route.getListenerId();
        this.xPos = LerpedFloat.linear().startWithValue((double)(width / 2) - (Double)ModClientConfig.OVERLAY_SCALE.get() * 113.0);
        this.yPos = LerpedFloat.linear().startWithValue((double)(height / 2) - (Double)ModClientConfig.OVERLAY_SCALE.get() * 59.0);
        this.getListener().registerOnNarratorAnnounce(this, this::narratorAnnouncement).registerOnAnnounceNextStop(this, this::announceNextStop).registerOnContinueWithJourneyAfterStop(this, this::nextStop).registerOnFinishJourney(this, this::finishJourney).registerOnReachNextStop(this, this::reachNextStop).registerOnJourneyBegin(this, this::journeyBegin).registerOnNotification(this, this::notificationReceive).registerOnJourneyInterrupt(this, this::journeyInterrupt);
        this.setSlidingText(this.getListener().getLastInfoText());
        if (this.getListener().getCurrentState() == JourneyListener.State.BEFORE_JOURNEY) {
            if (this.getListener().getLastNotification() != null) {
                this.notificationReceive(this.getListener().getLastNotification());
            }
            if (this.getListener().lastNarratorText() != null) {
                this.narratorAnnouncement(this.getListener().lastNarratorText());
            }
            this.setPageJourneyStart();
        } else {
            this.setPageRouteOverview();
        }
    }

    private float getUIScale() {
        return (float)((Double)ModClientConfig.OVERLAY_SCALE.get()).doubleValue();
    }

    public JourneyListener getListener() {
        return this.listener == null ? (this.listener = JourneyListenerManager.getInstance().get(this.listenerId, this)) : this.listener;
    }

    public UUID getListenerId() {
        return this.listenerId;
    }

    @Override
    public UUID getJourneyListenerClientId() {
        return this.clientId;
    }

    public void onClose() {
        this.getListener().unregister(this);
        JourneyListenerManager.getInstance().removeClientListenerForAll(this);
    }

    public void m_94120_() {
        if (Screen.m_96637_() && ModKeys.KEY_OVERLAY_SETTINGS.m_90857_() && Minecraft.m_91087_().f_91074_.m_150109_().m_18949_(Set.of((Item)ModItems.NAVIGATOR.get()))) {
            ClientWrapper.showRouteOverlaySettingsGui(this);
        }
        this.xPos.tickChaser();
        this.yPos.tickChaser();
        if (this.getListener() != null && this.getListener().getCurrentState() == JourneyListener.State.WHILE_TRAVELING) {
            ++this.trainDataSubPageTime;
            if (this.slidingTextWidth <= 220 && this.trainDataSubPageTime > 200 || this.slidingTextOffset < (float)(-(this.slidingTextWidth / 2))) {
                this.setTrainDataSubPage(false);
            }
        }
        switch (this.currentPage) {
            case NEXT_CONNECTIONS: {
                if (this.fading) break;
                ++this.connectionsSubPageTime;
                if (this.connectionsSubPageTime <= 200) break;
                this.setNextConnectionsSubPage();
                break;
            }
        }
    }

    public void tickSlidingText(float delta) {
        if ((float)this.slidingTextWidth > 165.0f) {
            this.slidingTextOffset -= delta;
            if (this.slidingTextOffset < (float)(-(this.slidingTextWidth / 2))) {
                this.slidingTextOffset = 220 + this.slidingTextWidth / 2 + 20;
            }
        }
    }

    private void fadeIn(Runnable andThen) {
        this.fadeInternal(andThen, false);
    }

    private void fadeOut(Runnable andThen) {
        this.fadeInternal(andThen, true);
    }

    private void fadeInternal(Runnable andThen, boolean fadeOut) {
        this.fadeDoneAction = andThen;
        this.fadeInvert = fadeOut;
        this.fadeStart = Util.m_137550_();
        this.fading = true;
    }

    private void setSlidingText(Component component) {
        this.slidingText = component;
        this.slidingTextWidth = this.shadowlessFont.m_92852_((FormattedText)component);
        this.slidingTextOffset = (float)this.slidingTextWidth > 165.0f ? (float)(220 + this.slidingTextWidth / 2 + 20) : 82.0f;
    }

    private void startStencil(Graphics graphics, int x, int y, int w, int h) {
        UIRenderHelper.swapAndBlitColor((RenderTarget)Minecraft.m_91087_().m_91385_(), (RenderTarget)UIRenderHelper.framebuffer);
        ModGuiUtils.startStencil(graphics, x, y, w, h);
    }

    private void endStencil() {
        ModGuiUtils.endStencil();
        UIRenderHelper.swapAndBlitColor((RenderTarget)UIRenderHelper.framebuffer, (RenderTarget)Minecraft.m_91087_().m_91385_());
    }

    private void notificationReceive(JourneyListener.NotificationData data) {
        if (((Boolean)ModClientConfig.ROUTE_NOTIFICATIONS.get()).booleanValue()) {
            Minecraft.m_91087_().m_91300_().m_94922_((Toast)NavigatorToast.multiline(data.title(), data.text()));
        }
    }

    private void journeyBegin(JourneyListener.JourneyBeginData data) {
        this.setSlidingText(data.infoText());
        this.setPageJourneyStart();
    }

    private void nextStop(JourneyListener.ContinueData data) {
        this.setTrainDataSubPage(true);
        this.setPageRouteOverview();
    }

    private void finishJourney(JourneyListener.FinishJourneyData data) {
        this.setSlidingText(data.infoText());
        this.setPageJourneyCompleted();
    }

    private void announceNextStop(JourneyListener.AnnounceNextStopData data) {
        this.setSlidingText(data.infoText());
        this.setPageNextConnections();
    }

    private void reachNextStop(JourneyListener.ReachNextStopData data) {
        this.setSlidingText(data.infoText());
        switch (data.transferState()) {
            case CONNECTION_MISSED: {
                this.setPageConnectionMissed();
                break;
            }
            case DEFAULT: {
                this.setPageTransfer();
                break;
            }
        }
    }

    private void journeyInterrupt(JourneyListener.JourneyInterruptData data) {
        this.setSlidingText(data.text());
        this.setPageJourneyInterrupted(data);
    }

    private void narratorAnnouncement(String text) {
        if (((Boolean)ModClientConfig.ROUTE_NARRATOR.get()).booleanValue()) {
            Narrator.getNarrator().say(text, true);
        }
    }

    private void setPageRouteOverview() {
        this.fadeOut(() -> {
            this.currentPage = Page.ROUTE_OVERVIEW;
            this.fadeIn(null);
        });
    }

    private void setPageJourneyStart() {
        this.fadeOut(() -> {
            this.currentPage = Page.JOURNEY_START;
            this.fadeIn(null);
        });
    }

    private void setPageTransfer() {
        this.fadeOut(() -> {
            this.currentPage = Page.TRANSFER;
            SimpleRoute.StationEntry station = this.getListener().currentStation();
            if (station != null) {
                this.messageLabel = MultiLineLabel.m_94341_((Font)this.shadowlessFont, (FormattedText)(station.getInfo().platform() == null || station.getInfo().platform().isBlank() ? ELanguage.translate(keyTransfer, station.getTrain().trainName(), station.getTrain().scheduleTitle()) : ELanguage.translate(keyTransferWithPlatform, station.getTrain().trainName(), station.getTrain().scheduleTitle(), station.getInfo().platform())), (int)189);
            }
            this.fadeIn(null);
        });
    }

    private void setPageConnectionMissed() {
        this.fadeOut(() -> {
            this.currentPage = Page.JOURNEY_INTERRUPTED;
            SimpleRoute.StationEntry station = this.getListener().lastStation();
            if (station != null) {
                MutableComponent text = TextUtils.translate((String)keyConnectionMissedPageText, (Object[])new Object[]{station.getStationName()});
                this.messageLabel = MultiLineLabel.m_94341_((Font)this.shadowlessFont, (FormattedText)text, (int)210);
                this.interruptedText = TextUtils.translate((String)keyConnectionMissed);
            }
            this.fadeIn(null);
        });
    }

    private void setPageJourneyInterrupted(JourneyListener.JourneyInterruptData data) {
        this.fadeOut(() -> {
            this.currentPage = Page.JOURNEY_INTERRUPTED;
            this.messageLabel = MultiLineLabel.m_94341_((Font)this.shadowlessFont, (FormattedText)data.text(), (int)210);
            this.interruptedText = TextUtils.text((String)data.title().getString());
            this.fadeIn(null);
        });
    }

    private void setPageJourneyCompleted() {
        this.fadeOut(() -> {
            this.currentPage = Page.JOURNEY_END;
            SimpleRoute.StationEntry station = this.getListener().currentStation();
            if (station != null) {
                this.messageLabel = MultiLineLabel.m_94341_((Font)this.shadowlessFont, (FormattedText)TextUtils.translate((String)keyAfterJourney, (Object[])new Object[]{station.getStationName()}), (int)210);
            }
            this.fadeIn(null);
        });
    }

    private void setPageNextConnections() {
        long id = InstanceManager.registerClientNextConnectionsResponseAction((connections, time) -> {
            this.connections = connections;
            this.connectionsRefreshTime = time;
            if (!connections.isEmpty()) {
                this.fadeOut(() -> {
                    this.currentPage = Page.NEXT_CONNECTIONS;
                    this.connectionsSubPagesCount = connections.size() / 3 + (connections.size() % 3 == 0 ? 0 : 1);
                    this.connectionsSubPageIndex = 0;
                    this.connectionsSubPageTime = 0;
                    this.fadeIn(null);
                });
            }
        });
        CreateRailwaysNavigator.net().CHANNEL.sendToServer((Object)new NextConnectionsRequestPacket(id, this.getListener().currentStation().getTrain().trainId(), this.getListener().currentStation().getStationName(), this.getListener().currentStation().getCurrentTicks() + (Integer)ModClientConfig.TRANSFER_TIME.get()));
    }

    private void setNextConnectionsSubPage() {
        if (this.connectionsSubPagesCount > 1) {
            this.fadeOut(() -> {
                this.connectionsSubPageTime = 0;
                ++this.connectionsSubPageIndex;
                if (this.connectionsSubPageIndex >= this.connectionsSubPagesCount) {
                    this.connectionsSubPageIndex = 0;
                }
                this.fadeIn(null);
            });
        } else {
            this.connectionsSubPageTime = 0;
        }
    }

    private void setTrainDataSubPage(boolean reset) {
        this.trainDataSubPageIndex = reset || this.trainDataSubPageIndex >= 2 ? 0 : ++this.trainDataSubPageIndex;
        switch (this.trainDataSubPageIndex) {
            default: {
                this.setSlidingText((Component)ELanguage.translate(keyTrainDetails, this.getListener().currentStation().getTrain().trainName(), this.getListener().currentStation().getTrain().scheduleTitle()));
                this.trainDataSubPageTime = 0;
                break;
            }
            case 1: {
                long id = InstanceManager.registerClientTrainDataResponseAction((data, time) -> {
                    this.setSlidingText((Component)ModUtils.calcSpeedString(data.speed(), (ESpeedUnit)((Object)((Object)ModClientConfig.SPEED_UNIT.get()))));
                    this.trainDataSubPageTime = 0;
                });
                CreateRailwaysNavigator.net().CHANNEL.sendToServer((Object)new TrainDataRequestPacket(id, this.getListener().currentStation().getTrain().trainId(), false));
            }
        }
    }

    public void render(Graphics graphics, float partialTicks, int width, int height) {
        width = Minecraft.m_91087_().m_91268_().m_85445_();
        height = Minecraft.m_91087_().m_91268_().m_85446_();
        partialTicks = Minecraft.m_91087_().m_91296_();
        OverlayPosition pos = (OverlayPosition)((Object)ModClientConfig.ROUTE_OVERLAY_POSITION.get());
        int x = pos == OverlayPosition.TOP_LEFT || pos == OverlayPosition.BOTTOM_LEFT ? 8 : (int)((float)width - 226.0f * this.getUIScale() - 10.0f);
        int y = pos == OverlayPosition.TOP_LEFT || pos == OverlayPosition.TOP_RIGHT ? 8 : (int)((float)height - 118.0f * this.getUIScale() - 10.0f);
        this.xPos.chase((double)x, (double)0.2f, LerpedFloat.Chaser.EXP);
        this.yPos.chase((double)y, (double)0.2f, LerpedFloat.Chaser.EXP);
        graphics.poseStack().m_85836_();
        graphics.poseStack().m_85837_((double)((int)this.xPos.getValue(partialTicks)), (double)((int)this.yPos.getValue(partialTicks)), 0.0);
        this.renderInternal(graphics, 0, 0, width, height, partialTicks);
        graphics.poseStack().m_85849_();
        this.tickSlidingText(2.0f * Minecraft.m_91087_().m_91297_());
    }

    private void renderInternal(Graphics graphics, int x, int y, int width, int height, float partialTicks) {
        graphics.poseStack().m_85836_();
        float fadePercentage = this.fading ? Mth.m_14036_((float)((float)(Util.m_137550_() - this.fadeStart) / 500.0f), (float)0.0f, (float)1.0f) : 1.0f;
        float alpha = this.fadeInvert ? Mth.m_14036_((float)(1.0f - fadePercentage), (float)0.0f, (float)1.0f) : Mth.m_14036_((float)fadePercentage, (float)0.0f, (float)1.0f);
        int fontAlpha = Mth.m_14167_((float)(alpha * 255.0f)) << 24;
        graphics.poseStack().m_85841_(this.getUIScale(), this.getUIScale(), this.getUIScale());
        RenderSystem.m_157456_((int)0, (ResourceLocation)GUI);
        GuiUtils.drawTexture((ResourceLocation)GUI, (Graphics)graphics, (int)x, (int)y, (int)226, (int)118, (int)0, (int)(this.getListener().getCurrentState().important() ? 138 : 0), (int)256, (int)256);
        GuiUtils.drawString((Graphics)graphics, (Font)this.shadowlessFont, (int)(x + 6), (int)(y + 4), (FormattedText)title, (int)0x4F4F4F, (EAlignment)EAlignment.LEFT, (boolean)false);
        Objects.requireNonNull(this.shadowlessFont);
        GuiUtils.drawString((Graphics)graphics, (Font)this.shadowlessFont, (int)(x + 6), (int)(y + 118 - 2 - 9), (FormattedText)TextUtils.translate((String)keyOptionsText, (Object[])new Object[]{TextUtils.translate((String)InputConstants.m_84827_((int)(Minecraft.f_91002_ ? 343 : 341), (int)0).m_84874_()).m_130946_(" + ").m_7220_((Component)TextUtils.keybind((String)keyKeybindOptions)).m_130940_(ChatFormatting.BOLD)}), (int)0x4F4F4F, (EAlignment)EAlignment.LEFT, (boolean)false);
        String timeString = TimeUtils.parseTime((long)((int)((this.level.m_46468_() + 6000L) % 24000L)), (TimeUtils.TimeFormat)((TimeUtils.TimeFormat)ModClientConfig.TIME_FORMAT.get()));
        GuiUtils.drawString((Graphics)graphics, (Font)this.shadowlessFont, (int)(x + 226 - 4 - this.shadowlessFont.m_92895_(timeString)), (int)(y + 4), (String)timeString, (int)0x4F4F4F, (EAlignment)EAlignment.LEFT, (boolean)false);
        this.renderSlidingText(graphics, x, y + 2);
        this.startStencil(graphics, x + 3, y + 40, 220, 62);
        graphics.poseStack().m_85836_();
        graphics.poseStack().m_85837_((double)((float)(this.fadeInvert ? 0 : -20) + fadePercentage * 20.0f), 0.0, 0.0);
        if (alpha > 0.1f && (fontAlpha & 0xFC000000) != 0) {
            switch (this.currentPage) {
                case JOURNEY_START: {
                    this.renderPageJourneyStart(graphics, x, y + 40, fadePercentage, fontAlpha);
                    break;
                }
                case NEXT_CONNECTIONS: {
                    this.renderNextConnections(graphics, x, y + 40, fadePercentage, fontAlpha, null);
                    break;
                }
                case TRANSFER: {
                    this.renderPageTransfer(graphics, x, y + 40, fadePercentage, fontAlpha, null);
                    break;
                }
                case JOURNEY_INTERRUPTED: {
                    this.renderPageJourneyInterrupted(graphics, x, y + 40, fadePercentage, fontAlpha);
                    break;
                }
                case JOURNEY_END: {
                    this.renderPageJourneyCompleted(graphics, x, y + 40, fadePercentage, fontAlpha);
                    break;
                }
                case ROUTE_OVERVIEW: {
                    int[] yOffset = new int[]{y + 40 - 1};
                    int i = this.getListener().getIndex();
                    while (i < Math.min(this.getListener().getIndex() + 4, this.getListener().getListeningRoute().getStationCount(true))) {
                        int k = i++;
                        yOffset[0] = yOffset[0] + this.renderRouteOverview(graphics, k, x, yOffset[0], alpha, fontAlpha);
                    }
                    break;
                }
            }
        }
        graphics.poseStack().m_85849_();
        this.endStencil();
        graphics.poseStack().m_85849_();
        if (fadePercentage >= 1.0f) {
            this.fading = false;
            if (this.fadeDoneAction != null) {
                this.fadeDoneAction.run();
            }
        }
    }

    public void renderSlidingText(Graphics graphics, int x, int y) {
        this.startStencil(graphics, x + 3, y + 16, 220, 21);
        graphics.poseStack().m_85836_();
        graphics.poseStack().m_85841_(1.3333334f, 1.3333334f, 1.3333334f);
        GuiUtils.drawString((Graphics)graphics, (Font)this.shadowlessFont, (int)((int)((float)(x + 3) + this.slidingTextOffset)), (int)(y + 14), (FormattedText)this.slidingText, (int)0xFF9900, (EAlignment)EAlignment.CENTER, (boolean)false);
        graphics.poseStack().m_85849_();
        this.endStencil();
    }

    public int renderRouteOverview(Graphics graphics, int index, int x, int y, float alphaPercentage, int fontAlpha) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)GUI);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)alphaPercentage);
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_69482_();
        Optional<SimpleRoute.StationEntry> stationOptional = this.getListener().getEntryAt(index);
        Optional<SimpleRoute.StationEntry> nextStation = this.getListener().getEntryAt(index + 1);
        if (!stationOptional.isPresent()) {
            return y;
        }
        SimpleRoute.StationEntry station = stationOptional.get();
        boolean reachable = station.reachable(false);
        int dY = index <= 0 ? 0 : 14;
        int transferY = 42;
        switch (station.getTag()) {
            case PART_START: {
                dY = 28;
                break;
            }
            case START: {
                dY = 56;
                break;
            }
        }
        GuiUtils.drawTexture((ResourceLocation)GUI, (Graphics)graphics, (int)(x + 75), (int)y, (int)7, (int)14, (int)226, (int)dY, (int)256, (int)256);
        if (index >= this.getListener().getIndex() + 4 - 1 && station.getTag() != SimpleRoute.StationTag.END) {
            GuiUtils.drawTexture((ResourceLocation)GUI, (Graphics)graphics, (int)(x + 75), (int)(y + 14), (int)7, (int)14, (int)226, (int)14, (int)256, (int)256);
        }
        if (station.isTrainCanceled()) {
            Objects.requireNonNull(this.shadowlessFont);
            GuiUtils.drawString((Graphics)graphics, (Font)this.shadowlessFont, (int)(x + 10), (int)(y + 14 - 2 - 9 / 2), (FormattedText)ELanguage.translate(keyTrainCanceled), (int)(0xFF4242 | fontAlpha), (EAlignment)EAlignment.LEFT, (boolean)false);
        } else {
            long timeDiff = station.getDifferenceTime();
            MutableComponent timeText = TextUtils.text((String)TimeUtils.parseTime((long)((int)((station.getScheduleTime() + 6000L) % 24000L)), (TimeUtils.TimeFormat)((TimeUtils.TimeFormat)ModClientConfig.TIME_FORMAT.get()))).m_130940_(reachable ? ChatFormatting.RESET : ChatFormatting.STRIKETHROUGH);
            float scale = this.shadowlessFont.m_92852_((FormattedText)timeText) >= 30 ? 0.7f : 1.0f;
            graphics.poseStack().m_85836_();
            graphics.poseStack().m_85841_(scale, 1.0f, 1.0f);
            int n = (int)((float)(x + 10) / scale);
            Objects.requireNonNull(this.shadowlessFont);
            GuiUtils.drawString((Graphics)graphics, (Font)this.shadowlessFont, (int)n, (int)(y + 14 - 2 - 9 / 2), (FormattedText)timeText, (int)(reachable ? (index <= this.getListener().getIndex() ? 0xFFFFFF | fontAlpha : 0xDBDBDB | fontAlpha) : 0xFF4242 | fontAlpha), (EAlignment)EAlignment.LEFT, (boolean)false);
            graphics.poseStack().m_85849_();
            if (station.reachable(false) && station.shouldRenderRealtime()) {
                MutableComponent realtimeText = TextUtils.text((String)TimeUtils.parseTime((long)((int)((station.getEstimatedTimeWithThreshold() + 6000L) % 24000L)), (TimeUtils.TimeFormat)((TimeUtils.TimeFormat)ModClientConfig.TIME_FORMAT.get()))).m_130940_(reachable ? ChatFormatting.RESET : ChatFormatting.STRIKETHROUGH);
                float realtimeScale = this.shadowlessFont.m_92852_((FormattedText)realtimeText) >= 30 ? 0.7f : 1.0f;
                graphics.poseStack().m_85836_();
                graphics.poseStack().m_85841_(realtimeScale, 1.0f, 1.0f);
                int n2 = (int)((float)(x + 40) / realtimeScale);
                Objects.requireNonNull(this.shadowlessFont);
                GuiUtils.drawString((Graphics)graphics, (Font)this.shadowlessFont, (int)n2, (int)(y + 14 - 2 - 9 / 2), (FormattedText)realtimeText, (int)(timeDiff < (long)((Integer)ModClientConfig.DEVIATION_THRESHOLD.get()).intValue() && reachable ? 0x1AEA5F | fontAlpha : 0xFF4242 | fontAlpha), (EAlignment)EAlignment.LEFT, (boolean)false);
                graphics.poseStack().m_85849_();
            }
        }
        MutableComponent platformText = TextUtils.text((String)station.getUpdatedInfo().platform());
        int platformTextWidth = this.shadowlessFont.m_92852_((FormattedText)platformText);
        int maxStationNameWidth = 220 - platformTextWidth - 105;
        MutableComponent stationText = TextUtils.text((String)station.getStationName());
        if (index == this.getListener().getIndex()) {
            stationText = stationText.m_130940_(ChatFormatting.BOLD);
        }
        if (!reachable) {
            stationText = stationText.m_130940_(ChatFormatting.STRIKETHROUGH);
        }
        if (this.shadowlessFont.m_92852_((FormattedText)stationText) > maxStationNameWidth) {
            stationText = TextUtils.text((String)this.shadowlessFont.m_92854_((FormattedText)stationText, maxStationNameWidth).getString()).m_7220_((Component)TextUtils.text((String)"...")).m_130948_(stationText.m_7383_());
        }
        Objects.requireNonNull(this.shadowlessFont);
        GuiUtils.drawString((Graphics)graphics, (Font)this.shadowlessFont, (int)(x + 90), (int)(y + 14 - 2 - 9 / 2), (FormattedText)stationText, (int)(reachable ? (index <= this.getListener().getIndex() ? 0xFFFFFF | fontAlpha : 0xDBDBDB | fontAlpha) : 0xFF4242 | fontAlpha), (EAlignment)EAlignment.LEFT, (boolean)false);
        Objects.requireNonNull(this.shadowlessFont);
        GuiUtils.drawString((Graphics)graphics, (Font)this.shadowlessFont, (int)(x + 220 - platformTextWidth), (int)(y + 14 - 2 - 9 / 2), (FormattedText)platformText, (int)(reachable && !station.stationInfoChanged() ? (index <= this.getListener().getIndex() ? 0xFFFFFF | fontAlpha : 0xDBDBDB | fontAlpha) : 0xFF4242 | fontAlpha), (EAlignment)EAlignment.LEFT, (boolean)false);
        if (station.getTag() == SimpleRoute.StationTag.PART_END) {
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)alphaPercentage);
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
            RenderSystem.m_69482_();
            GuiUtils.drawTexture((ResourceLocation)GUI, (Graphics)graphics, (int)(x + 75), (int)(y += 14), (int)7, (int)14, (int)226, (int)42, (int)256, (int)256);
            if (nextStation.isPresent() && !nextStation.get().reachable(true)) {
                if (nextStation.get().isDeparted() || nextStation.get().isTrainCanceled()) {
                    ModGuiIcons.CROSS.render(graphics, x + 10, y + 14 - 2 - 8);
                    Objects.requireNonNull(this.shadowlessFont);
                    GuiUtils.drawString((Graphics)graphics, (Font)this.shadowlessFont, (int)(x + 90), (int)(y + 14 - 2 - 9 / 2), (FormattedText)ELanguage.translate(nextStation.get().isTrainCanceled() ? keyConnectionCanceled : keyConnectionMissed).m_130940_(ChatFormatting.BOLD), (int)(0xFF4242 | fontAlpha), (EAlignment)EAlignment.LEFT, (boolean)false);
                } else {
                    ModGuiIcons.WARN.render(graphics, x + 10, y + 14 - 2 - 8);
                    Objects.requireNonNull(this.shadowlessFont);
                    GuiUtils.drawString((Graphics)graphics, (Font)this.shadowlessFont, (int)(x + 90), (int)(y + 14 - 2 - 9 / 2), (FormattedText)ELanguage.translate(keyConnectionEndangered).m_130940_(ChatFormatting.BOLD), (int)(0xFFAA00 | fontAlpha), (EAlignment)EAlignment.LEFT, (boolean)false);
                }
            } else {
                Objects.requireNonNull(this.shadowlessFont);
                GuiUtils.drawString((Graphics)graphics, (Font)this.shadowlessFont, (int)(x + 10), (int)(y + 14 - 2 - 9 / 2), (FormattedText)TextUtils.text((String)TimeUtils.parseDurationShort((int)((int)this.getListener().getTransferTime(index)))).m_130940_(ChatFormatting.ITALIC), (int)(0xDBDBDB | fontAlpha), (EAlignment)EAlignment.LEFT, (boolean)false);
                Objects.requireNonNull(this.shadowlessFont);
                GuiUtils.drawString((Graphics)graphics, (Font)this.shadowlessFont, (int)(x + 90), (int)(y + 14 - 2 - 9 / 2), (FormattedText)ELanguage.translate(keyScheduleTransfer).m_130940_(ChatFormatting.ITALIC), (int)(0xDBDBDB | fontAlpha), (EAlignment)EAlignment.LEFT, (boolean)false);
            }
            return 28;
        }
        return 14;
    }

    public void renderNextConnections(Graphics graphics, int x, int y, float alphaPercentage, int fontAlpha, SimpleRoute.StationEntry station) {
        GuiUtils.drawString((Graphics)graphics, (Font)this.shadowlessFont, (int)(x + 10), (int)(y + 4), (FormattedText)ELanguage.translate(keyNextConnections).m_130940_(ChatFormatting.BOLD), (int)(0xFFFFFF | fontAlpha), (EAlignment)EAlignment.LEFT, (boolean)false);
        SimpleTrainConnection[] conns = (SimpleTrainConnection[])this.connections.toArray(SimpleTrainConnection[]::new);
        int i = this.connectionsSubPageIndex * 3;
        int k = 0;
        while (i < Math.min((this.connectionsSubPageIndex + 1) * 3, this.connections.size())) {
            MutableComponent time = TextUtils.text((String)TimeUtils.parseTime((long)((int)((this.connectionsRefreshTime + (long)conns[i].ticks() + 6000L) % 24000L)), (TimeUtils.TimeFormat)((TimeUtils.TimeFormat)ModClientConfig.TIME_FORMAT.get())));
            MutableComponent platform = TextUtils.text((String)conns[i].stationDetails().platform());
            int x1 = x + 10;
            int x2 = x + 55;
            int x3 = x + 100;
            int x4 = x + 220 - this.shadowlessFont.m_92852_((FormattedText)platform);
            int maxTrainNameWidth = x3 - x2 - 5;
            MutableComponent trainName = TextUtils.text((String)conns[i].trainName());
            if (this.shadowlessFont.m_92852_((FormattedText)trainName) > maxTrainNameWidth) {
                trainName = TextUtils.text((String)this.shadowlessFont.m_92854_((FormattedText)trainName, maxTrainNameWidth).getString()).m_7220_((Component)TextUtils.text((String)"..."));
            }
            int maxDestinationWidth = x4 - x3 - 5;
            MutableComponent destination = TextUtils.text((String)conns[i].scheduleTitle());
            if (this.shadowlessFont.m_92852_((FormattedText)destination) > maxDestinationWidth) {
                destination = TextUtils.text((String)this.shadowlessFont.m_92854_((FormattedText)destination, maxDestinationWidth).getString()).m_7220_((Component)TextUtils.text((String)"..."));
            }
            GuiUtils.drawString((Graphics)graphics, (Font)this.shadowlessFont, (int)x1, (int)(y + 15 + 12 * k), (FormattedText)time, (int)(0xDBDBDB | fontAlpha), (EAlignment)EAlignment.LEFT, (boolean)false);
            GuiUtils.drawString((Graphics)graphics, (Font)this.shadowlessFont, (int)x2, (int)(y + 15 + 12 * k), (FormattedText)trainName, (int)(0xDBDBDB | fontAlpha), (EAlignment)EAlignment.LEFT, (boolean)false);
            GuiUtils.drawString((Graphics)graphics, (Font)this.shadowlessFont, (int)x3, (int)(y + 15 + 12 * k), (FormattedText)destination, (int)(0xDBDBDB | fontAlpha), (EAlignment)EAlignment.LEFT, (boolean)false);
            GuiUtils.drawString((Graphics)graphics, (Font)this.shadowlessFont, (int)x4, (int)(y + 15 + 12 * k), (FormattedText)platform, (int)(0xDBDBDB | fontAlpha), (EAlignment)EAlignment.LEFT, (boolean)false);
            ++i;
            ++k;
        }
        int dotSize = 4;
        int dotY = y + 62 - 10;
        int startX = x + 113 - this.connectionsSubPagesCount * 4 - 4;
        for (int i2 = 0; i2 < this.connectionsSubPagesCount; ++i2) {
            int s = 4 + (i2 == this.connectionsSubPageIndex ? 2 : 0);
            int dX = startX + i2 * 4 * 3 - (i2 == this.connectionsSubPageIndex ? 1 : 0);
            int dY = dotY - (i2 == this.connectionsSubPageIndex ? 1 : 0);
            GuiUtils.fill((Graphics)graphics, (int)dX, (int)dY, (int)s, (int)s, (int)(i2 == this.connectionsSubPageIndex ? 0xFFFFFF | fontAlpha : 0xDBDBDB | fontAlpha));
            GuiUtils.fill((Graphics)graphics, (int)(dX + 1), (int)(dY + 1), (int)(s - 2), (int)(s - 2), (int)(i2 == this.connectionsSubPageIndex ? 0xAAAAAA | fontAlpha : 0x888888 | fontAlpha));
        }
    }

    public void renderPageJourneyStart(Graphics graphics, int x, int y, float alphaPercentage, int fontAlpha) {
        y += 3 + this.renderRouteOverview(graphics, this.getListener().getIndex(), x, y - 3, alphaPercentage, fontAlpha);
        GuiUtils.fill((Graphics)graphics, (int)(x + 3), (int)y, (int)220, (int)1, (int)(0xDBDBDB | fontAlpha));
        ModGuiIcons.TIME.render(graphics, x + 10, y + 3);
        long time = this.getListener().currentStation().getEstimatedTimeWithThreshold() - this.level.m_46468_();
        Objects.requireNonNull(this.shadowlessFont);
        GuiUtils.drawString((Graphics)graphics, (Font)this.shadowlessFont, (int)(x + 15 + 16), (int)(y + 3 + 8 - 9 / 2), (FormattedText)ELanguage.translate(keyDepartureIn).m_130946_(" ").m_7220_((Component)(time > 0L ? TextUtils.text((String)TimeUtils.parseTime((long)((int)(time % 24000L)), (TimeUtils.TimeFormat)TimeUtils.TimeFormat.HOURS_24)) : ELanguage.translate(keyTimeNow))).m_130940_(ChatFormatting.BOLD), (int)(0xFFFFFF | fontAlpha), (EAlignment)EAlignment.LEFT, (boolean)false);
        y += 21;
        int detailsLineHeight = 12;
        SimpleRoute.StationEntry endStation = this.getListener().lastStation();
        MutableComponent platformText = TextUtils.text((String)endStation.getInfo().platform());
        int platformTextWidth = this.shadowlessFont.m_92852_((FormattedText)platformText);
        int maxStationNameWidth = 220 - platformTextWidth - 10 - 5;
        MutableComponent stationText = TextUtils.text((String)TimeUtils.parseTime((long)((int)((endStation.getEstimatedTimeWithThreshold() + 6000L) % 24000L)), (TimeUtils.TimeFormat)((TimeUtils.TimeFormat)ModClientConfig.TIME_FORMAT.get()))).m_7220_((Component)TextUtils.text((String)(" " + endStation.getStationName())));
        if (this.shadowlessFont.m_92852_((FormattedText)stationText) > maxStationNameWidth) {
            stationText = TextUtils.text((String)this.shadowlessFont.m_92854_((FormattedText)stationText, maxStationNameWidth).getString()).m_7220_((Component)TextUtils.text((String)"...")).m_130948_(stationText.m_7383_());
        }
        Objects.requireNonNull(this.shadowlessFont);
        ModGuiIcons.TARGET.render(graphics, x + 10, y + 9 / 2 - 8);
        GuiUtils.drawString((Graphics)graphics, (Font)this.shadowlessFont, (int)(x + 15 + 16), (int)y, (FormattedText)stationText, (int)(0xDBDBDB | fontAlpha), (EAlignment)EAlignment.LEFT, (boolean)false);
        GuiUtils.drawString((Graphics)graphics, (Font)this.shadowlessFont, (int)(x + 220 - platformTextWidth), (int)y, (FormattedText)platformText, (int)(endStation.stationInfoChanged() ? 0xFF4242 | fontAlpha : 0xDBDBDB | fontAlpha), (EAlignment)EAlignment.LEFT, (boolean)false);
        Objects.requireNonNull(this.shadowlessFont);
        ModGuiIcons.INFO.render(graphics, x + 10, y + 12 + 9 / 2 - 8);
        GuiUtils.drawString((Graphics)graphics, (Font)this.shadowlessFont, (int)(x + 15 + 16), (int)(y + 12), (FormattedText)TextUtils.text((String)String.format("%s %s | %s", this.getListener().getListeningRoute().getTransferCount(), ELanguage.translate(keyTransferCount).getString(), TimeUtils.parseDurationShort((int)this.getListener().getListeningRoute().getTotalDuration()))), (int)(0xDBDBDB | fontAlpha), (EAlignment)EAlignment.LEFT, (boolean)false);
    }

    public void renderPageTransfer(Graphics graphics, int x, int y, float alphaPercentage, int fontAlpha, SimpleRoute.StationEntry station) {
        y += 3 + this.renderRouteOverview(graphics, this.getListener().getIndex(), x, y - 3, alphaPercentage, fontAlpha);
        GuiUtils.fill((Graphics)graphics, (int)(x + 3), (int)y, (int)220, (int)1, (int)(0xDBDBDB | fontAlpha));
        ModGuiIcons.WALK.render(graphics, x + 10, y + 3);
        long transferTime = this.getListener().currentStation().getEstimatedTimeWithThreshold() - this.level.m_46468_();
        Objects.requireNonNull(this.shadowlessFont);
        GuiUtils.drawString((Graphics)graphics, (Font)this.shadowlessFont, (int)(x + 15 + 16), (int)(y + 3 + 8 - 9 / 2), (FormattedText)ELanguage.translate(keyScheduleTransfer).m_130946_(" ").m_7220_((Component)(transferTime > 0L ? TextUtils.text((String)TimeUtils.parseTime((long)((int)(transferTime % 24000L)), (TimeUtils.TimeFormat)TimeUtils.TimeFormat.HOURS_24)) : ELanguage.translate(keyTimeNow))).m_130940_(ChatFormatting.BOLD), (int)(0xFFFFFF | fontAlpha), (EAlignment)EAlignment.LEFT, (boolean)false);
        this.messageLabel.m_6516_(graphics.poseStack(), x + 15 + 16, y += 21, 12, 0xDBDBDB | fontAlpha);
    }

    public void renderPageJourneyInterrupted(Graphics graphics, int x, int y, float alphaPercentage, int fontAlpha) {
        ModGuiIcons.CROSS.render(graphics, x + 10, y + 3);
        Objects.requireNonNull(this.shadowlessFont);
        GuiUtils.drawString((Graphics)graphics, (Font)this.shadowlessFont, (int)(x + 15 + 16), (int)(y + 3 + 8 - 9 / 2), (FormattedText)this.interruptedText.m_130940_(ChatFormatting.BOLD), (int)(0xFF4242 | fontAlpha), (EAlignment)EAlignment.LEFT, (boolean)false);
        this.messageLabel.m_6516_(graphics.poseStack(), x + 10, y += 21, 10, 0xDBDBDB | fontAlpha);
    }

    public void renderPageJourneyCompleted(Graphics graphics, int x, int y, float alphaPercentage, int fontAlpha) {
        ModGuiIcons.CHECK.render(graphics, x + 10, y + 3);
        Objects.requireNonNull(this.shadowlessFont);
        GuiUtils.drawString((Graphics)graphics, (Font)this.shadowlessFont, (int)(x + 15 + 16), (int)(y + 3 + 8 - 9 / 2), (FormattedText)TextUtils.translate((String)keyJourneyCompleted).m_130940_(ChatFormatting.BOLD), (int)(0x1AEA5F | fontAlpha), (EAlignment)EAlignment.LEFT, (boolean)false);
        this.messageLabel.m_6516_(graphics.poseStack(), x + 10, y += 21, 10, 0xDBDBDB | fontAlpha);
    }

    protected static enum Page {
        NONE,
        ROUTE_OVERVIEW,
        NEXT_CONNECTIONS,
        JOURNEY_START,
        JOURNEY_END,
        TRANSFER,
        JOURNEY_INTERRUPTED;

    }
}

