/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.ber.variants;

import com.mojang.blaze3d.vertex.PoseStack;
import de.mrjulsen.crn.block.be.AdvancedDisplayBlockEntity;
import de.mrjulsen.crn.client.ber.AdvancedDisplayRenderInstance;
import de.mrjulsen.crn.client.ber.base.BERText;
import de.mrjulsen.crn.client.ber.variants.IBERRenderSubtype;
import de.mrjulsen.crn.client.lang.ELanguage;
import de.mrjulsen.crn.config.ModClientConfig;
import de.mrjulsen.crn.data.DeparturePrediction;
import de.mrjulsen.crn.util.ModUtils;
import de.mrjulsen.mcdragonlib.client.ber.IBlockEntityRendererInstance;
import de.mrjulsen.mcdragonlib.util.DLUtils;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.TimeUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class BERPlatformDetailed
implements IBERRenderSubtype<AdvancedDisplayBlockEntity, AdvancedDisplayRenderInstance, Boolean> {
    private static final String keyTime = "gui.createrailwaysnavigator.time";
    private static final int TIME_LABEL_WIDTH = 16;
    private List<DeparturePrediction.SimpleDeparturePrediction> lastPredictions = new ArrayList<DeparturePrediction.SimpleDeparturePrediction>();
    private BERText timeLabel;
    private BERText[][] additionalLabels;
    private int timer;
    private static final int MAX_TIMER = 100;
    private boolean showTime = false;

    @Override
    public boolean isSingleLined() {
        return false;
    }

    @Override
    public void tick(Level level, BlockPos pos, BlockState state, AdvancedDisplayBlockEntity pBlockEntity, AdvancedDisplayRenderInstance parent) {
        if (this.timeLabel != null) {
            this.timeLabel.tick();
        }
        if (this.additionalLabels != null) {
            for (int i = 0; i < this.additionalLabels.length; ++i) {
                if (this.additionalLabels[i] == null) continue;
                for (int k = 0; k < this.additionalLabels[i].length; ++k) {
                    if (this.additionalLabels[i][k] == null) continue;
                    this.additionalLabels[i][k].tick();
                }
            }
        }
        ++this.timer;
        if ((this.timer %= 100) == 0) {
            this.showTime = !this.showTime;
        }
    }

    @Override
    public void renderAdditional(IBlockEntityRendererInstance.BlockEntityRendererContext context, AdvancedDisplayBlockEntity pBlockEntity, AdvancedDisplayRenderInstance parent, float pPartialTicks, PoseStack pPoseStack, MultiBufferSource pBufferSource, int pPackedLight, int pOverlay, Boolean backSide) {
        if (this.additionalLabels != null) {
            for (int i = 0; i < this.additionalLabels.length; ++i) {
                if (this.additionalLabels[i] == null) continue;
                if (i >= pBlockEntity.getPlatformInfoLinesCount() - 1 && this.showTime) break;
                for (int k = 0; k < this.additionalLabels[i].length; ++k) {
                    if (this.additionalLabels[i][k] == null) continue;
                    this.additionalLabels[i][k].render(pPoseStack, pBufferSource, pPackedLight);
                }
                if (i < pBlockEntity.getPlatformInfoLinesCount() - 1) continue;
                return;
            }
        }
        this.timeLabel.render(pPoseStack, pBufferSource, pPackedLight);
    }

    @Override
    public void update(Level level, BlockPos pos, BlockState state, AdvancedDisplayBlockEntity blockEntity, AdvancedDisplayRenderInstance parent, IBlockEntityRendererInstance.EUpdateReason reason) {
        parent.labels.clear();
        List<DeparturePrediction.SimpleDeparturePrediction> preds = blockEntity.getPredictions().stream().filter(x -> x.departureTicks() < (Integer)ModClientConfig.DISPLAY_LEAD_TIME.get()).toList();
        if (preds.size() <= 0) {
            this.additionalLabels = null;
            this.setTimer(level, pos, state, blockEntity, parent, reason, 4.0f);
            return;
        }
        int maxLines = blockEntity.getPlatformInfoLinesCount();
        boolean refreshAll = reason != IBlockEntityRendererInstance.EUpdateReason.DATA_CHANGED || !DLUtils.compareCollections(this.lastPredictions, preds, (a, b) -> a.stationInfo().platform().equals(b.stationInfo().platform()) && a.trainId().equals(b.trainId()));
        this.lastPredictions = preds;
        if (refreshAll) {
            this.additionalLabels = null;
            this.timeLabel = null;
            this.additionalLabels = new BERText[Math.min(preds.size(), maxLines)][];
            for (int i = 0; i < this.additionalLabels.length; ++i) {
                this.additionalLabels[i] = this.addLine(level, pos, state, blockEntity, parent, reason, i, 4.0f + (float)i * 5.4f);
            }
            this.setTimer(level, pos, state, blockEntity, parent, reason, 4.0f + (float)(this.additionalLabels.length < maxLines ? this.additionalLabels.length : maxLines - 1) * 5.34f);
        }
    }

    private BERText[] addLine(Level level, BlockPos pos, BlockState state, AdvancedDisplayBlockEntity blockEntity, AdvancedDisplayRenderInstance parent, IBlockEntityRendererInstance.EUpdateReason reason, int predictionIdx, float y) {
        BERText lastLabel;
        float displayWidth = blockEntity.getXSizeScaled() * 16 - 4;
        BERText[] labels = new BERText[4];
        MutableComponent label = TextUtils.text((String)this.lastPredictions.get(predictionIdx).stationInfo().platform());
        float labelWidth = blockEntity.getPlatformWidth() < 0 ? (float)parent.getFontUtils().font.m_92852_((FormattedText)label) * 0.4f : Math.min((float)parent.getFontUtils().font.m_92852_((FormattedText)label) * 0.4f, (float)(blockEntity.getPlatformWidth() - 2));
        int platformMaxWidth = blockEntity.getPlatformWidth() < 0 ? (int)(displayWidth - 6.0f) : blockEntity.getPlatformWidth() - 2;
        labels[0] = lastLabel = new BERText(parent.getFontUtils(), (Component)label, 0.0f).withIsCentered(false).withMaxWidth(platformMaxWidth, true).withStretchScale(0.2f, 0.4f).withStencil(0.0f, platformMaxWidth).withColor(0xFF000000 | blockEntity.getColor()).withPredefinedTextTransformation(new BERText.TextTransformation((float)(blockEntity.getXSizeScaled() * 16 - 3) - labelWidth, y, 0.01f, 1.0f, 0.4f)).build();
        labels[1] = new BERText(parent.getFontUtils(), () -> {
            ArrayList<MutableComponent> texts = new ArrayList<MutableComponent>();
            switch (blockEntity.getTimeDisplay()) {
                case ETA: {
                    texts.add(TextUtils.text((String)ModUtils.timeRemainingString(this.lastPredictions.get(predictionIdx).departureTicks())));
                    break;
                }
                default: {
                    int rawTime = (int)(blockEntity.getLastRefreshedTime() % 24000L + 6000L + (long)this.lastPredictions.get(predictionIdx).departureTicks());
                    texts.add(TextUtils.text((String)TimeUtils.parseTime((long)(rawTime - rawTime % (Integer)ModClientConfig.REALTIME_PRECISION_THRESHOLD.get()), (TimeUtils.TimeFormat)((TimeUtils.TimeFormat)ModClientConfig.TIME_FORMAT.get()))));
                }
            }
            return texts;
        }, 0.0f).withIsCentered(false).withMaxWidth(12.0f, true).withStretchScale(0.2f, 0.4f).withStencil(0.0f, 12.0f).withColor(0xFF000000 | blockEntity.getColor()).withRefreshRate(100).withPredefinedTextTransformation(new BERText.TextTransformation(3.0f, y, 0.01f, 1.0f, 0.4f)).build();
        float platformWidth = blockEntity.getPlatformWidth() < 0 ? lastLabel.getScaledTextWidth() + 2.0f : (float)blockEntity.getPlatformWidth();
        byte trainNameWidth = blockEntity.getTrainNameWidth();
        labels[2] = lastLabel = new BERText(parent.getFontUtils(), () -> {
            ArrayList<MutableComponent> texts = new ArrayList<MutableComponent>();
            texts.add(TextUtils.text((String)this.lastPredictions.get(predictionIdx).trainName()));
            return texts;
        }, 0.0f).withIsCentered(false).withMaxWidth(Math.min((float)(trainNameWidth - 1), displayWidth - 16.0f - platformWidth - 1.0f), false).withStretchScale(0.2f, 0.4f).withStencil(0.0f, Math.min((float)(trainNameWidth - 1), displayWidth - 16.0f - platformWidth - 1.0f)).withColor(0xFF000000 | blockEntity.getColor()).withPredefinedTextTransformation(new BERText.TextTransformation(16.0f, y, 0.01f, 1.0f, 0.4f)).build();
        labels[3] = lastLabel = new BERText(parent.getFontUtils(), () -> {
            ArrayList<MutableComponent> texts = new ArrayList<MutableComponent>();
            texts.add(TextUtils.text((String)this.lastPredictions.get(predictionIdx).scheduleTitle()));
            return texts;
        }, 0.0f).withIsCentered(false).withMaxWidth(displayWidth - 16.0f - (float)trainNameWidth - platformWidth + 1.0f, true).withStretchScale(0.25f, 0.4f).withStencil(0.0f, displayWidth - 16.0f - (float)trainNameWidth - platformWidth + 1.0f).withCanScroll(true, 1.0f).withColor(0xFF000000 | blockEntity.getColor()).withPredefinedTextTransformation(new BERText.TextTransformation(16 + trainNameWidth, y, 0.01f, 1.0f, 0.4f)).build();
        return labels;
    }

    public void setTimer(Level level, BlockPos pos, BlockState state, AdvancedDisplayBlockEntity blockEntity, AdvancedDisplayRenderInstance parent, IBlockEntityRendererInstance.EUpdateReason reason, float y) {
        float displayWidth = blockEntity.getXSizeScaled() * 16 - 6;
        this.timeLabel = new BERText(parent.getFontUtils(), () -> List.of(ELanguage.translate(keyTime, TimeUtils.parseTime((long)((int)(blockEntity.m_58904_().m_46468_() % 24000L + 6000L)), (TimeUtils.TimeFormat)((TimeUtils.TimeFormat)ModClientConfig.TIME_FORMAT.get())))), 0.0f).withIsCentered(true).withMaxWidth(displayWidth, true).withStretchScale(0.4f, 0.4f).withStencil(0.0f, displayWidth).withCanScroll(true, 1.0f).withColor(0xFF000000 | blockEntity.getColor()).withTicksPerPage(100).withRefreshRate(16).withPredefinedTextTransformation(new BERText.TextTransformation(3.0f, y, 0.0f, 1.0f, 0.4f)).build();
    }
}

