/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.block.display;

import com.simibubi.create.content.redstone.displayLink.DisplayLinkContext;
import com.simibubi.create.content.redstone.displayLink.target.DisplayBoardTarget;
import com.simibubi.create.content.redstone.displayLink.target.DisplayTarget;
import com.simibubi.create.content.redstone.displayLink.target.DisplayTargetStats;
import com.simibubi.create.content.trains.display.GlobalTrainDisplayData;
import com.simibubi.create.content.trains.entity.Train;
import de.mrjulsen.crn.block.be.AdvancedDisplayBlockEntity;
import de.mrjulsen.crn.data.DeparturePrediction;
import de.mrjulsen.crn.data.GlobalSettingsManager;
import de.mrjulsen.crn.data.SimpleTrainSchedule;
import de.mrjulsen.crn.data.SimulatedTrainSchedule;
import de.mrjulsen.crn.data.TrainStop;
import de.mrjulsen.crn.util.TrainUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;

public class AdvancedDisplayTarget
extends DisplayBoardTarget {
    public void acceptFlapText(int line, List<List<MutableComponent>> text, DisplayLinkContext context) {
        AdvancedDisplayBlockEntity blockEntity;
        AdvancedDisplayBlockEntity controller;
        CompoundTag nbt = context.sourceConfig();
        if (!nbt.m_128441_("AdvancedDisplay")) {
            return;
        }
        String filter = context.sourceConfig().m_128461_("Filter");
        BlockEntity blockEntity2 = context.getTargetBlockEntity();
        if (blockEntity2 instanceof AdvancedDisplayBlockEntity && (controller = (blockEntity = (AdvancedDisplayBlockEntity)blockEntity2).getController()) != null) {
            DeparturePrediction.SimpleDeparturePrediction pred;
            Train train;
            List<DeparturePrediction.SimpleDeparturePrediction> preds = AdvancedDisplayTarget.prepare(filter, controller.getPlatformInfoLinesCount()).stream().map(x -> new DeparturePrediction((GlobalTrainDisplayData.TrainDeparturePrediction)x).simplify()).sorted(Comparator.comparingInt(x -> x.departureTicks())).toList();
            ArrayList<String> stopovers = new ArrayList<String>();
            if (!preds.isEmpty() && (train = TrainUtils.getTrain((pred = preds.iterator().next()).trainId())) != null) {
                SimulatedTrainSchedule sched = SimpleTrainSchedule.of(TrainUtils.getTrainStopsSorted(pred.trainId(), context.blockEntity().m_58904_())).simulate(train, 0, pred.stationName());
                ArrayList<TrainStop> stops = new ArrayList<TrainStop>(sched.getAllStops());
                boolean foundStart = false;
                if (!stops.isEmpty()) {
                    for (int i = 0; i < stops.size() - 1; ++i) {
                        TrainStop x2 = (TrainStop)stops.get(i);
                        if (foundStart) {
                            stopovers.add(x2.getStationAlias().getAliasName().get());
                        }
                        foundStart = foundStart || x2.getPrediction().getStationName().equals(pred.stationName());
                    }
                }
            }
            controller.setDepartureData(preds, stopovers, filter, GlobalSettingsManager.getInstance().getSettingsData().getAliasFor(filter).getInfoForStation(filter), context.getTargetBlockEntity().m_58904_().m_46468_(), (byte)context.sourceConfig().m_128451_("PlatformWidth"), (byte)context.sourceConfig().m_128451_("TrainNameWidth"), context.sourceConfig().m_128445_("TimeDisplay"));
            controller.sendData();
        }
    }

    public static List<GlobalTrainDisplayData.TrainDeparturePrediction> prepare(String filter, int maxLines) {
        String regex = filter.isBlank() ? filter : "\\Q" + filter.replace("*", "\\E.*\\Q") + "\\E";
        return new HashMap(GlobalTrainDisplayData.statusByDestination).entrySet().stream().filter(e -> ((String)e.getKey()).matches(regex)).flatMap(e -> ((Collection)e.getValue()).stream()).sorted().limit(maxLines).toList();
    }

    public boolean isReserved(int line, BlockEntity target, DisplayLinkContext context) {
        return super.isReserved(line, target, context) || target instanceof AdvancedDisplayBlockEntity;
    }

    public DisplayTargetStats provideStats(DisplayLinkContext context) {
        AdvancedDisplayBlockEntity controller = this.getController(context);
        if (controller == null) {
            return new DisplayTargetStats(1, 1, (DisplayTarget)this);
        }
        return new DisplayTargetStats(1, 1, (DisplayTarget)this);
    }

    private AdvancedDisplayBlockEntity getController(DisplayLinkContext context) {
        BlockEntity teIn = context.getTargetBlockEntity();
        if (!(teIn instanceof AdvancedDisplayBlockEntity)) {
            return null;
        }
        AdvancedDisplayBlockEntity be = (AdvancedDisplayBlockEntity)teIn;
        return be.getController();
    }

    public AABB getMultiblockBounds(LevelAccessor level, BlockPos pos) {
        AABB baseShape = super.getMultiblockBounds(level, pos);
        BlockEntity be = level.m_7702_(pos);
        if (!(be instanceof AdvancedDisplayBlockEntity)) {
            return baseShape;
        }
        AdvancedDisplayBlockEntity fdbe = (AdvancedDisplayBlockEntity)be;
        AdvancedDisplayBlockEntity controller = fdbe.getController();
        if (controller == null) {
            return baseShape;
        }
        Vec3i normal = controller.getDirection().m_122427_().m_122436_();
        return baseShape.m_82338_(controller.m_58899_().m_121996_((Vec3i)pos)).m_82363_((double)(normal.m_123341_() * (controller.getXSize() - 1)), (double)(1 - controller.getYSize()), (double)(normal.m_123343_() * (controller.getXSize() - 1)));
    }
}

