/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.network.packets.cts;

import de.mrjulsen.crn.CreateRailwaysNavigator;
import de.mrjulsen.crn.data.NearestTrackStationResult;
import de.mrjulsen.crn.network.packets.stc.NearestStationResponsePacket;
import de.mrjulsen.crn.network.packets.stc.ServerErrorPacket;
import de.mrjulsen.crn.util.TrainUtils;
import de.mrjulsen.mcdragonlib.net.IPacketBase;
import dev.architectury.networking.NetworkManager;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.phys.Vec3;

public class NearestStationRequestPacket
implements IPacketBase<NearestStationRequestPacket> {
    public long id;
    public BlockPos pos;

    public NearestStationRequestPacket() {
    }

    public NearestStationRequestPacket(long id, Vec3 pos) {
        this(id, new BlockPos(pos));
    }

    public NearestStationRequestPacket(long id, BlockPos pos) {
        this.id = id;
        this.pos = pos;
    }

    public void encode(NearestStationRequestPacket packet, FriendlyByteBuf buffer) {
        buffer.writeLong(packet.id);
        buffer.m_130064_(packet.pos);
    }

    public NearestStationRequestPacket decode(FriendlyByteBuf buffer) {
        long id = buffer.readLong();
        BlockPos pos = buffer.m_130135_();
        return new NearestStationRequestPacket(id, pos);
    }

    public void handle(NearestStationRequestPacket packet, Supplier<NetworkManager.PacketContext> contextSupplier) {
        contextSupplier.get().queue(() -> {
            Thread navigationThread = new Thread(() -> NearestStationRequestPacket.lambda$handle$0((Supplier)contextSupplier, packet));
            navigationThread.setPriority(1);
            navigationThread.setName("Station Location Calculator");
            navigationThread.start();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static /* synthetic */ void lambda$handle$0(Supplier contextSupplier, NearestStationRequestPacket packet) {
        NearestTrackStationResult result = NearestTrackStationResult.empty();
        try {
            result = TrainUtils.getNearestTrackStation(((NetworkManager.PacketContext)contextSupplier.get()).getPlayer().m_9236_(), (Vec3i)packet.pos);
        }
        catch (Exception e) {
            CreateRailwaysNavigator.LOGGER.error("Error while trying to find nearest track station ", (Throwable)e);
            CreateRailwaysNavigator.net().CHANNEL.sendToPlayer((ServerPlayer)((NetworkManager.PacketContext)contextSupplier.get()).getPlayer(), (Object)new ServerErrorPacket(e.getMessage()));
        }
        finally {
            CreateRailwaysNavigator.net().CHANNEL.sendToPlayer((ServerPlayer)((NetworkManager.PacketContext)contextSupplier.get()).getPlayer(), (Object)new NearestStationResponsePacket(packet.id, result));
        }
    }
}

