/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.network.packets.cts;

import de.mrjulsen.crn.CreateRailwaysNavigator;
import de.mrjulsen.crn.core.navigation.Graph;
import de.mrjulsen.crn.data.GlobalSettingsManager;
import de.mrjulsen.crn.data.Route;
import de.mrjulsen.crn.data.SimpleRoute;
import de.mrjulsen.crn.data.TrainStationAlias;
import de.mrjulsen.crn.data.UserSettings;
import de.mrjulsen.crn.network.packets.stc.NavigationResponsePacket;
import de.mrjulsen.crn.network.packets.stc.ServerErrorPacket;
import de.mrjulsen.mcdragonlib.net.IPacketBase;
import dev.architectury.networking.NetworkManager;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;

public class NavigationRequestPacket
implements IPacketBase<NavigationRequestPacket> {
    public long id;
    public String start;
    public String end;
    public UserSettings filterSettings;

    public NavigationRequestPacket() {
    }

    public NavigationRequestPacket(long id, String start, String end) {
        this(id, start, end, new UserSettings());
    }

    private NavigationRequestPacket(long id, String start, String end, UserSettings settings) {
        this.id = id;
        this.start = start;
        this.end = end;
        this.filterSettings = settings;
    }

    public void encode(NavigationRequestPacket packet, FriendlyByteBuf buffer) {
        buffer.writeLong(packet.id);
        buffer.m_130070_(packet.start);
        buffer.m_130070_(packet.end);
        buffer.m_130079_(packet.filterSettings.toNbt());
    }

    public NavigationRequestPacket decode(FriendlyByteBuf buffer) {
        long id = buffer.readLong();
        String start = buffer.m_130277_();
        String end = buffer.m_130277_();
        UserSettings filterSettings = UserSettings.fromNbt(buffer.m_130260_());
        return new NavigationRequestPacket(id, start, end, filterSettings);
    }

    public void handle(NavigationRequestPacket packet, Supplier<NetworkManager.PacketContext> contextSupplier) {
        contextSupplier.get().queue(() -> {
            Thread navigationThread = new Thread(() -> NavigationRequestPacket.lambda$handle$2((Supplier)contextSupplier, packet));
            navigationThread.setPriority(1);
            navigationThread.setName("Navigator");
            navigationThread.start();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static /* synthetic */ void lambda$handle$2(Supplier contextSupplier, NavigationRequestPacket packet) {
        TrainStationAlias endAlias;
        TrainStationAlias startAlias;
        long startTime;
        long updateTime;
        ArrayList<Route> routes;
        block5: {
            routes = new ArrayList<Route>();
            updateTime = ((NetworkManager.PacketContext)contextSupplier.get()).getPlayer().f_19853_.m_46468_();
            startTime = System.currentTimeMillis();
            startAlias = GlobalSettingsManager.getInstance().getSettingsData().getAliasFor(packet.start);
            endAlias = GlobalSettingsManager.getInstance().getSettingsData().getAliasFor(packet.end);
            if (startAlias != null && endAlias != null) break block5;
            long estimatedTime = System.currentTimeMillis() - startTime;
            CreateRailwaysNavigator.LOGGER.info(String.format("Route calculated. Took %sms.", estimatedTime));
            CreateRailwaysNavigator.net().CHANNEL.sendToPlayer((ServerPlayer)((NetworkManager.PacketContext)contextSupplier.get()).getPlayer(), (Object)new NavigationResponsePacket(packet.id, new ArrayList<SimpleRoute>(routes.stream().filter(x -> !x.isEmpty()).map(x -> new SimpleRoute((Route)x)).toList()), estimatedTime, updateTime));
            return;
        }
        try {
            Graph graph = new Graph(((NetworkManager.PacketContext)contextSupplier.get()).getPlayer().m_9236_(), packet.filterSettings);
            routes.addAll(graph.navigate(startAlias, endAlias, true));
        }
        catch (Exception e) {
            try {
                CreateRailwaysNavigator.LOGGER.error("Navigation error: ", (Throwable)e);
                CreateRailwaysNavigator.net().CHANNEL.sendToPlayer((ServerPlayer)((NetworkManager.PacketContext)contextSupplier.get()).getPlayer(), (Object)new ServerErrorPacket(e.getMessage()));
            }
            catch (Throwable throwable) {
                long estimatedTime = System.currentTimeMillis() - startTime;
                CreateRailwaysNavigator.LOGGER.info(String.format("Route calculated. Took %sms.", estimatedTime));
                CreateRailwaysNavigator.net().CHANNEL.sendToPlayer((ServerPlayer)((NetworkManager.PacketContext)contextSupplier.get()).getPlayer(), (Object)new NavigationResponsePacket(packet.id, new ArrayList<SimpleRoute>(routes.stream().filter(x -> !x.isEmpty()).map(x -> new SimpleRoute((Route)x)).toList()), estimatedTime, updateTime));
                throw throwable;
            }
            long estimatedTime = System.currentTimeMillis() - startTime;
            CreateRailwaysNavigator.LOGGER.info(String.format("Route calculated. Took %sms.", estimatedTime));
            CreateRailwaysNavigator.net().CHANNEL.sendToPlayer((ServerPlayer)((NetworkManager.PacketContext)contextSupplier.get()).getPlayer(), (Object)new NavigationResponsePacket(packet.id, new ArrayList<SimpleRoute>(routes.stream().filter(x -> !x.isEmpty()).map(x -> new SimpleRoute((Route)x)).toList()), estimatedTime, updateTime));
        }
        long estimatedTime = System.currentTimeMillis() - startTime;
        CreateRailwaysNavigator.LOGGER.info(String.format("Route calculated. Took %sms.", estimatedTime));
        CreateRailwaysNavigator.net().CHANNEL.sendToPlayer((ServerPlayer)((NetworkManager.PacketContext)contextSupplier.get()).getPlayer(), (Object)new NavigationResponsePacket(packet.id, new ArrayList<SimpleRoute>(routes.stream().filter(x -> !x.isEmpty()).map(x -> new SimpleRoute((Route)x)).toList()), estimatedTime, updateTime));
    }
}

