/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.network;

import de.mrjulsen.crn.data.DeparturePrediction;
import de.mrjulsen.crn.data.NearestTrackStationResult;
import de.mrjulsen.crn.data.SimpleRoute;
import de.mrjulsen.crn.data.SimpleTrainConnection;
import de.mrjulsen.crn.network.packets.cts.TrainDataRequestPacket;
import de.mrjulsen.crn.network.packets.stc.NavigationResponsePacket;
import de.mrjulsen.mcdragonlib.client.OverlayManager;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public class InstanceManager {
    private static final Map<Long, Runnable> CLIENT_RESPONSE_RECEIVED_ACTION = new HashMap<Long, Runnable>();
    private static final Map<Long, BiConsumer<List<SimpleRoute>, NavigationResponsePacket.NavigationResponseData>> CLIENT_NAVIGATION_RESPONSE_ACTION = new HashMap<Long, BiConsumer<List<SimpleRoute>, NavigationResponsePacket.NavigationResponseData>>();
    private static final Map<Long, Consumer<NearestTrackStationResult>> CLIENT_NEAREST_STATION_RESPONSE_ACTION = new HashMap<Long, Consumer<NearestTrackStationResult>>();
    private static final Map<Long, BiConsumer<Collection<DeparturePrediction.SimpleDeparturePrediction>, Long>> CLIENT_REALTIME_RESPONSE_ACTION = new HashMap<Long, BiConsumer<Collection<DeparturePrediction.SimpleDeparturePrediction>, Long>>();
    private static final Map<Long, BiConsumer<Collection<SimpleTrainConnection>, Long>> CLIENT_NEXT_CONNECTIONS_RESPONSE_ACTION = new HashMap<Long, BiConsumer<Collection<SimpleTrainConnection>, Long>>();
    private static final Map<Long, BiConsumer<TrainDataRequestPacket.TrainData, Long>> CLIENT_NEXT_TRAIN_DATA_RESPONSE_ACTION = new HashMap<Long, BiConsumer<TrainDataRequestPacket.TrainData, Long>>();
    private static long currentRouteOverlayId;

    public static String getInstancesCountString() {
        return String.format("[%s, %s, %s, %s, %s, %s]", CLIENT_RESPONSE_RECEIVED_ACTION.size(), CLIENT_NAVIGATION_RESPONSE_ACTION.size(), CLIENT_NEAREST_STATION_RESPONSE_ACTION.size(), CLIENT_REALTIME_RESPONSE_ACTION.size(), CLIENT_NEXT_CONNECTIONS_RESPONSE_ACTION.size(), CLIENT_NEXT_TRAIN_DATA_RESPONSE_ACTION.size());
    }

    public static void clearAll() {
        CLIENT_RESPONSE_RECEIVED_ACTION.clear();
        CLIENT_NAVIGATION_RESPONSE_ACTION.clear();
        CLIENT_NEAREST_STATION_RESPONSE_ACTION.clear();
        CLIENT_REALTIME_RESPONSE_ACTION.clear();
        CLIENT_NEXT_CONNECTIONS_RESPONSE_ACTION.clear();
        CLIENT_NEXT_TRAIN_DATA_RESPONSE_ACTION.clear();
    }

    public static long registerClientResponseReceievedAction(Runnable runnable) {
        long id = System.nanoTime();
        CLIENT_RESPONSE_RECEIVED_ACTION.put(id, runnable);
        return id;
    }

    public static void runClientResponseReceievedAction(long id) {
        Runnable run;
        if (CLIENT_RESPONSE_RECEIVED_ACTION.containsKey(id) && (run = CLIENT_RESPONSE_RECEIVED_ACTION.remove(id)) != null) {
            run.run();
        }
    }

    public static long registerClientNavigationResponseAction(BiConsumer<List<SimpleRoute>, NavigationResponsePacket.NavigationResponseData> consumer) {
        long id = System.nanoTime();
        CLIENT_NAVIGATION_RESPONSE_ACTION.put(id, consumer);
        return id;
    }

    public static void runClientNavigationResponseAction(long id, List<SimpleRoute> routes, NavigationResponsePacket.NavigationResponseData data) {
        BiConsumer<List<SimpleRoute>, NavigationResponsePacket.NavigationResponseData> action;
        if (CLIENT_NAVIGATION_RESPONSE_ACTION.containsKey(id) && (action = CLIENT_NAVIGATION_RESPONSE_ACTION.remove(id)) != null) {
            action.accept(routes, data);
        }
    }

    public static long registerClientNearestStationResponseAction(Consumer<NearestTrackStationResult> consumer) {
        long id = System.nanoTime();
        CLIENT_NEAREST_STATION_RESPONSE_ACTION.put(id, consumer);
        return id;
    }

    public static void runClientNearestStationResponseAction(long id, NearestTrackStationResult result) {
        Consumer<NearestTrackStationResult> action;
        if (CLIENT_NEAREST_STATION_RESPONSE_ACTION.containsKey(id) && (action = CLIENT_NEAREST_STATION_RESPONSE_ACTION.remove(id)) != null) {
            action.accept(result);
        }
    }

    public static long registerClientRealtimeResponseAction(BiConsumer<Collection<DeparturePrediction.SimpleDeparturePrediction>, Long> consumer) {
        long id = System.nanoTime();
        CLIENT_REALTIME_RESPONSE_ACTION.put(id, consumer);
        return id;
    }

    public static void runClientRealtimeResponseAction(long id, Collection<DeparturePrediction.SimpleDeparturePrediction> result, long time) {
        BiConsumer<Collection<DeparturePrediction.SimpleDeparturePrediction>, Long> action;
        if (CLIENT_REALTIME_RESPONSE_ACTION.containsKey(id) && (action = CLIENT_REALTIME_RESPONSE_ACTION.remove(id)) != null) {
            action.accept(result, time);
        }
    }

    public static long registerClientNextConnectionsResponseAction(BiConsumer<Collection<SimpleTrainConnection>, Long> consumer) {
        long id = System.nanoTime();
        CLIENT_NEXT_CONNECTIONS_RESPONSE_ACTION.put(id, consumer);
        return id;
    }

    public static void runClientNextConnectionsResponseAction(long id, Collection<SimpleTrainConnection> result, long time) {
        BiConsumer<Collection<SimpleTrainConnection>, Long> action;
        if (CLIENT_NEXT_CONNECTIONS_RESPONSE_ACTION.containsKey(id) && (action = CLIENT_NEXT_CONNECTIONS_RESPONSE_ACTION.remove(id)) != null) {
            action.accept(result, time);
        }
    }

    public static long registerClientTrainDataResponseAction(BiConsumer<TrainDataRequestPacket.TrainData, Long> consumer) {
        long id = System.nanoTime();
        CLIENT_NEXT_TRAIN_DATA_RESPONSE_ACTION.put(id, consumer);
        return id;
    }

    public static void runClientTrainDataResponseAction(long id, TrainDataRequestPacket.TrainData data, long time) {
        BiConsumer<TrainDataRequestPacket.TrainData, Long> action;
        if (CLIENT_NEXT_TRAIN_DATA_RESPONSE_ACTION.containsKey(id) && (action = CLIENT_NEXT_TRAIN_DATA_RESPONSE_ACTION.remove(id)) != null) {
            action.accept(data, time);
        }
    }

    public static void setRouteOverlay(long id) {
        InstanceManager.removeRouteOverlay();
        currentRouteOverlayId = id;
    }

    public static void removeRouteOverlay() {
        if (OverlayManager.has((long)currentRouteOverlayId)) {
            OverlayManager.remove((long)currentRouteOverlayId);
        }
    }
}

