/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.event.listeners;

import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.schedule.ScheduleEntry;
import com.simibubi.create.content.trains.schedule.condition.ScheduleWaitCondition;
import com.simibubi.create.content.trains.schedule.condition.TimedWaitCondition;
import de.mrjulsen.crn.CreateRailwaysNavigator;
import de.mrjulsen.crn.config.ModCommonConfig;
import de.mrjulsen.crn.mixin.ScheduleDataAccessor;
import de.mrjulsen.crn.util.TrainUtils;
import de.mrjulsen.mcdragonlib.util.ScheduledTask;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;

public class TrainListener {
    private static TrainListener instance;
    private boolean isRunning = true;
    private int totalTrainCount;
    private int listeingTrainCount;
    private final Map<UUID, List<Integer>> TRAIN_DURATIONS = new HashMap<UUID, List<Integer>>();
    private final Map<UUID, Integer> lastTicks = new HashMap<UUID, Integer>();

    public int getDepartmentTime(Level level, Train train) {
        List conditions = ((ScheduleEntry)train.runtime.getSchedule().entries.get((int)train.runtime.currentEntry)).conditions;
        if (conditions.isEmpty() || ((ScheduleDataAccessor)train.runtime).crn$conditionProgress().isEmpty() || ((ScheduleDataAccessor)train.runtime).crn$conditionContext().isEmpty()) {
            return 0;
        }
        List list = (List)conditions.get(0);
        int progress = ((ScheduleDataAccessor)train.runtime).crn$conditionProgress().get(0);
        if (progress >= list.size()) {
            return 0;
        }
        CompoundTag tag = ((ScheduleDataAccessor)train.runtime).crn$conditionContext().get(0);
        ScheduleWaitCondition condition = (ScheduleWaitCondition)list.get(progress);
        return ((TimedWaitCondition)condition).totalWaitTicks() - tag.m_128451_("Time");
    }

    private boolean performTask(TrainListener instance, ScheduledTask.ScheduledTaskContext context) {
        if (!this.isRunning) {
            return false;
        }
        new Thread(() -> {
            Collection<Train> trains = TrainUtils.getAllTrains();
            this.listeingTrainCount = 0;
            trains.forEach(train -> {
                if (!TrainUtils.isTrainValid(train)) {
                    return;
                }
                OptionalInt maxTrainDuration = TrainUtils.getTrainDeparturePredictions(train.id, null).stream().mapToInt(x -> x.getTicks()).max();
                if (maxTrainDuration.isPresent()) {
                    if (!this.lastTicks.containsKey(train.id)) {
                        this.lastTicks.put(train.id, 0);
                    }
                    if (this.lastTicks.get(train.id) < maxTrainDuration.getAsInt()) {
                        // empty if block
                    }
                    if (!this.TRAIN_DURATIONS.containsKey(train.id)) {
                        this.TRAIN_DURATIONS.put(train.id, new ArrayList());
                    }
                    this.TRAIN_DURATIONS.get(train.id).add(maxTrainDuration.getAsInt());
                    if (this.TRAIN_DURATIONS.get(train.id).size() > 30) {
                        this.TRAIN_DURATIONS.get(train.id).remove(0);
                    }
                    this.lastTicks.replace(train.id, maxTrainDuration.getAsInt());
                }
                ++this.listeingTrainCount;
            });
            this.totalTrainCount = trains.size();
        }, "Train Listener Worker").run();
        return this.isRunning;
    }

    public static TrainListener getInstance() {
        return instance;
    }

    public static TrainListener start(Level level) {
        if (instance == null) {
            instance = new TrainListener();
        }
        ScheduledTask.create((Object)instance, (Level)level, (int)((Integer)ModCommonConfig.TRAIN_WATCHER_INTERVALL.get()), (int)Integer.MAX_VALUE, instance::performTask);
        CreateRailwaysNavigator.LOGGER.info("TrainListener started.");
        return instance;
    }

    public static void stop() {
        if (instance == null) {
            return;
        }
        instance.stopInstance();
    }

    private void stopInstance() {
        this.isRunning = false;
        CreateRailwaysNavigator.LOGGER.info("TrainListener stopped.");
    }

    public int getApproximatedTrainDuration(Train train) {
        int a = this.getApproximatedTrainDuration(train.id);
        return a == 0 ? 1 : a;
    }

    public int getApproximatedTrainDuration(UUID trainId) {
        return this.TRAIN_DURATIONS.containsKey(trainId) ? this.TRAIN_DURATIONS.get(trainId).stream().mapToInt(v -> v).sum() / this.TRAIN_DURATIONS.get(trainId).size() : 0;
    }

    public int getTotalTrainCount() {
        return this.totalTrainCount;
    }

    public int getListeningTrainCount() {
        return this.listeingTrainCount;
    }
}

