/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.data;

import com.simibubi.create.content.trains.entity.Train;
import de.mrjulsen.crn.config.ModClientConfig;
import de.mrjulsen.crn.data.GlobalSettings;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;

public class UserSettings {
    private static final String NBT_TRANSFER_TIME = "TransferTime";
    private static final String NBT_TRAIN_GROUPS = "TrainGroupBlacklist";
    private final int transferTime;
    private final List<? extends String> trainGroupBlacklist;

    public UserSettings() {
        this((Integer)ModClientConfig.TRANSFER_TIME.get(), (List)ModClientConfig.TRAIN_GROUP_FILTER_BLACKLIST.get());
    }

    private UserSettings(int transferTime, List<? extends String> trainGroupBlacklist) {
        this.transferTime = transferTime;
        this.trainGroupBlacklist = trainGroupBlacklist;
    }

    public CompoundTag toNbt() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_(NBT_TRANSFER_TIME, this.getTransferTime());
        ListTag list = new ListTag();
        list.addAll(this.getTrainGroupBlacklist().stream().map(x -> StringTag.m_129297_((String)x)).toList());
        nbt.m_128365_(NBT_TRAIN_GROUPS, (Tag)list);
        return nbt;
    }

    public static UserSettings fromNbt(CompoundTag nbt) {
        return new UserSettings(nbt.m_128451_(NBT_TRANSFER_TIME), nbt.m_128437_(NBT_TRAIN_GROUPS, 8).stream().map(x -> ((StringTag)x).m_7916_()).toList());
    }

    public int getTransferTime() {
        return this.transferTime;
    }

    public List<? extends String> getTrainGroupBlacklist() {
        return this.trainGroupBlacklist;
    }

    public boolean isTrainExcluded(Train train, GlobalSettings settingsInstance) {
        boolean b = settingsInstance.getTrainGroupsList().stream().filter(x -> this.getTrainGroupBlacklist().contains(x.getGroupName())).anyMatch(x -> x.contains(train));
        return b;
    }
}

