/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.data;

import de.mrjulsen.crn.data.AliasName;
import de.mrjulsen.mcdragonlib.DragonLib;
import java.util.Date;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;

public class TrainStationAlias {
    private static final String NBT_ALIAS_NAME = "AliasName";
    private static final String NBT_STATION_LIST = "Stations";
    private static final String NBT_STATION_MAP = "StationData";
    private static final String NBT_LAST_EDITOR = "LastEditor";
    private static final String NBT_LAST_EDITED_TIME = "LastEditedTimestamp";
    private static final String NBT_STATION_ENTRY_NAME = "Name";
    protected AliasName aliasName;
    protected Map<String, StationInfo> stations = new HashMap<String, StationInfo>();
    protected String lastEditorName = null;
    protected long lastEditedTime = 0L;

    protected TrainStationAlias(AliasName aliasName, Map<String, StationInfo> initialValues, String lastEditorName, long lastEditedTime) {
        this(aliasName, initialValues);
        this.lastEditorName = lastEditorName;
        this.lastEditedTime = lastEditedTime;
    }

    public TrainStationAlias(AliasName aliasName, Map<String, StationInfo> initialValues) {
        this(aliasName);
        this.stations.putAll(initialValues);
    }

    public TrainStationAlias(AliasName aliasName) {
        this.aliasName = aliasName;
    }

    public TrainStationAlias copy() {
        return new TrainStationAlias(new AliasName(this.getAliasName().get()), new HashMap<String, StationInfo>(this.getAllStations()));
    }

    public CompoundTag toNbt() {
        CompoundTag nbt = new CompoundTag();
        if (this.aliasName == null) {
            return nbt;
        }
        nbt.m_128365_(NBT_ALIAS_NAME, (Tag)this.getAliasName().toNbt());
        if (this.lastEditorName != null) {
            nbt.m_128359_(NBT_LAST_EDITOR, this.getLastEditorName());
        }
        nbt.m_128356_(NBT_LAST_EDITED_TIME, this.lastEditedTime);
        ListTag stationsList = new ListTag();
        this.stations.forEach((key, value) -> {
            CompoundTag entry = new CompoundTag();
            entry.m_128359_(NBT_STATION_ENTRY_NAME, key);
            value.writeNbt(entry);
            stationsList.add((Object)entry);
        });
        nbt.m_128365_(NBT_STATION_MAP, (Tag)stationsList);
        return nbt;
    }

    public static TrainStationAlias fromNbt(CompoundTag nbt) {
        if (!nbt.m_128441_(NBT_ALIAS_NAME)) {
            return new TrainStationAlias(AliasName.of("null"));
        }
        AliasName name = AliasName.fromNbt(nbt.m_128469_(NBT_ALIAS_NAME));
        String lastEditorName = nbt.m_128441_(NBT_LAST_EDITOR) ? nbt.m_128461_(NBT_LAST_EDITOR) : null;
        long lastEditedTime = nbt.m_128454_(NBT_LAST_EDITED_TIME);
        Map<String, StationInfo> stations = nbt.m_128441_(NBT_STATION_LIST) ? nbt.m_128437_(NBT_STATION_LIST, 8).stream().map(x -> ((StringTag)x).m_7916_()).collect(Collectors.toMap(x -> x, x -> StationInfo.empty())) : (nbt.m_128441_(NBT_STATION_MAP) ? nbt.m_128437_(NBT_STATION_MAP, 10).stream().map(x -> (CompoundTag)x).collect(Collectors.toMap(x -> x.m_128461_(NBT_STATION_ENTRY_NAME), x -> StationInfo.fromNbt(x))) : new IdentityHashMap<String, StationInfo>());
        return new TrainStationAlias(name, stations, lastEditorName, lastEditedTime);
    }

    public String getLastEditorName() {
        return this.lastEditorName;
    }

    public void updateLastEdited(String name) {
        this.lastEditorName = name;
        this.lastEditedTime = new Date().getTime();
    }

    public Date getLastEditedTime() {
        return new Date(this.lastEditedTime);
    }

    public String getLastEditedTimeFormatted() {
        return DragonLib.DATE_FORMAT.format(this.getLastEditedTime());
    }

    public AliasName getAliasName() {
        return this.aliasName;
    }

    public void updateInfoForStation(String station, StationInfo info) {
        if (this.stations.containsKey(station)) {
            this.stations.replace(station, info);
        }
    }

    public void add(String station, StationInfo info) {
        if (!this.stations.containsKey(station)) {
            this.stations.put(station, info);
        }
    }

    public void addAll(Map<String, StationInfo> stations) {
        stations.forEach((key, value) -> {
            if (!this.stations.containsKey(key)) {
                this.stations.put((String)key, (StationInfo)value);
            }
        });
    }

    public boolean contains(String station) {
        String regex = station.isBlank() ? station : "\\Q" + station.replace("*", "\\E.*\\Q");
        return this.stations.keySet().stream().anyMatch(x -> x.matches(regex));
    }

    public Set<String> getAllStationNames() {
        return this.stations.keySet();
    }

    public Map<String, StationInfo> getAllStations() {
        return this.stations;
    }

    public StationInfo getInfoForStation(String stationName) {
        return this.stations.containsKey(stationName) ? this.stations.get(stationName) : StationInfo.empty();
    }

    public void setName(AliasName name) {
        this.aliasName = name;
    }

    public void remove(String station) {
        this.stations.remove(station);
    }

    public String toString() {
        return String.format("%s", this.getAliasName());
    }

    public boolean equals(Object obj) {
        if (obj instanceof TrainStationAlias) {
            TrainStationAlias alias = (TrainStationAlias)obj;
            return this.getAliasName().equals(alias.getAliasName()) && this.getAllStationNames().size() == alias.getAllStationNames().size() && this.getAllStationNames().stream().allMatch(x -> alias.contains((String)x));
        }
        return false;
    }

    public int hashCode() {
        return 7 * Objects.hash(this.aliasName);
    }

    public void update(TrainStationAlias newData) {
        this.aliasName = newData.aliasName;
        this.stations = newData.stations;
        this.lastEditedTime = newData.lastEditedTime;
        this.lastEditorName = newData.lastEditorName;
    }

    public record StationInfo(String platform) {
        private static final String NBT_PLATFORM = "Platform";

        public static StationInfo empty() {
            return new StationInfo("");
        }

        public void writeNbt(CompoundTag nbt) {
            nbt.m_128359_(NBT_PLATFORM, this.platform());
        }

        public static StationInfo fromNbt(CompoundTag nbt) {
            return new StationInfo(nbt.m_128461_(NBT_PLATFORM));
        }

        @Override
        public final boolean equals(Object obj) {
            if (obj instanceof StationInfo) {
                StationInfo other = (StationInfo)obj;
                return this.platform().equals(other.platform());
            }
            return false;
        }
    }
}

