/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.core.navigation;

import com.simibubi.create.content.trains.entity.Train;
import de.mrjulsen.crn.core.navigation.Edge;
import de.mrjulsen.crn.core.navigation.Graph;
import de.mrjulsen.crn.core.navigation.Node;
import de.mrjulsen.crn.data.GlobalSettings;
import de.mrjulsen.crn.data.GlobalTrainData;
import de.mrjulsen.crn.data.TrainStop;
import de.mrjulsen.crn.event.listeners.TrainListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class TrainSchedule {
    private final UUID id;
    private Set<Node> nodes;
    private Set<Edge> edges;
    private List<TrainStop> stops;

    public TrainSchedule(Train train, UUID id, GlobalSettings settingsInstance) {
        this.id = id;
        this.nodes = ConcurrentHashMap.newKeySet();
        this.edges = ConcurrentHashMap.newKeySet();
        this.makeSchedule(train, settingsInstance);
    }

    private void makeSchedule(Train train, GlobalSettings settingsInstance) {
        this.stops = new ArrayList<TrainStop>(GlobalTrainData.getInstance().getAllStopsSorted(train).stream().filter(x -> !settingsInstance.isBlacklisted(x.getPrediction().getStationName())).toList());
    }

    public boolean addToGraph(Graph graph, Train train) {
        if (this.stops.isEmpty()) {
            return false;
        }
        int cycleDuration = TrainListener.getInstance().getApproximatedTrainDuration(train);
        int size = this.stops.size();
        TrainStop lastStop = this.stops.get(size - 1);
        for (int i = 0; i < size; ++i) {
            TrainStop stop = this.stops.get(i);
            int duration = i == 0 ? cycleDuration - lastStop.getPrediction().getTicks() + stop.getPrediction().getTicks() : stop.getPrediction().getTicks() - lastStop.getPrediction().getTicks();
            Node node1 = graph.addNode(lastStop.getStationAlias(), train);
            Node node2 = graph.addNode(stop.getStationAlias(), train);
            Edge edge = graph.addEdge(node1, node2, this.getId()).withCost(duration, false);
            this.nodes.add(node1);
            this.nodes.add(node2);
            this.edges.add(edge);
            lastStop = stop;
        }
        return true;
    }

    public UUID getId() {
        return this.id;
    }

    public Set<Node> getNodes() {
        return this.nodes;
    }

    public Set<Edge> getEdges() {
        return this.edges;
    }

    public boolean equals(Object obj) {
        if (obj instanceof TrainSchedule) {
            TrainSchedule other = (TrainSchedule)obj;
            boolean b = this.getNodes().size() == other.getNodes().size() && this.getEdges().size() == other.getEdges().size();
            return b && this.getNodes().containsAll(other.getNodes()) && this.getEdges().containsAll(other.getEdges());
        }
        return false;
    }

    public int hashCode() {
        return 41 * Objects.hash(this.getEdges(), this.getNodes());
    }

    public void debugPrint() {
        System.out.println(String.format("TRAIN SCHEDULE DETAILS (%s nodes, %s edges)", this.nodes.size(), this.edges.size()));
        System.out.println("Nodes");
        for (Node node : this.nodes) {
            System.out.println(" -> " + node);
        }
        System.out.println("Edges");
        for (Edge edge : this.edges) {
            System.out.println(" -> " + edge);
        }
        System.out.println("--- END OF SCHEDULE ---");
    }
}

