/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.gui.screen;

import com.simibubi.create.content.trains.station.NoShadowFontWrapper;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.element.ScreenElement;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import de.mrjulsen.crn.Constants;
import de.mrjulsen.crn.client.gui.widgets.DLCreateIconButton;
import de.mrjulsen.crn.client.gui.widgets.ModStationSuggestions;
import de.mrjulsen.crn.config.ModClientConfig;
import de.mrjulsen.mcdragonlib.client.gui.DLScreen;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLEditBox;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLTooltip;
import de.mrjulsen.mcdragonlib.client.util.Graphics;
import de.mrjulsen.mcdragonlib.client.util.GuiAreaDefinition;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.core.EAlignment;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.TimeUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;

public abstract class AbstractBlacklistScreen
extends DLScreen {
    private static final ResourceLocation GUI = new ResourceLocation("createrailwaysnavigator", "textures/gui/settings.png");
    public static final ResourceLocation WIDGETS = new ResourceLocation("createrailwaysnavigator", "textures/gui/settings_widgets.png");
    private static final int GUI_WIDTH = 255;
    private static final int GUI_HEIGHT = 247;
    private static final int DEFAULT_ICON_BUTTON_WIDTH = 18;
    private static final int DEFAULT_ICON_BUTTON_HEIGHT = 18;
    private static final int ENTRIES_START_Y_OFFSET = 10;
    private static final int ENTRY_HEIGHT = 20;
    private final int AREA_X = 16;
    private final int AREA_Y = 72;
    private final int AREA_W = 220;
    private final int AREA_H = 138;
    private int guiLeft;
    private int guiTop;
    private LerpedFloat scroll = LerpedFloat.linear().startWithValue(0.0);
    private final Level level;
    private final Font shadowlessFont;
    private final Screen lastScreen;
    private boolean initialized;
    private DLCreateIconButton backButton;
    private DLEditBox newEntryBox;
    private DLEditBox searchBox;
    private GuiAreaDefinition addButton;
    private ModStationSuggestions suggestions;
    private final Map<String, GuiAreaDefinition> blacklistEntryButton = new HashMap<String, GuiAreaDefinition>();
    private final Map<String, GuiAreaDefinition> entryAreas = new HashMap<String, GuiAreaDefinition>();
    private final MutableComponent tooltipAdd = TextUtils.translate((String)"gui.createrailwaysnavigator.blacklist.add.tooltip");
    private final MutableComponent tooltipRemove = TextUtils.translate((String)"gui.createrailwaysnavigator.blacklist.delete.tooltip");

    public AbstractBlacklistScreen(Level level, Screen lastScreen, Component title) {
        super(title);
        this.level = level;
        this.lastScreen = lastScreen;
        this.shadowlessFont = new NoShadowFontWrapper(Minecraft.m_91087_().f_91062_);
    }

    protected abstract Collection<String> getSuggestions();

    protected abstract boolean checkIsBlacklisted(String var1);

    protected abstract String[] getBlacklistedNames(String var1);

    protected abstract void addToBlacklist(String var1, Runnable var2);

    protected abstract void removeFromBlacklist(String var1, Runnable var2);

    protected void m_7856_() {
        this.initialized = false;
        super.m_7856_();
        this.guiLeft = this.f_96543_ / 2 - 127;
        this.guiTop = this.f_96544_ / 2 - 123;
        this.backButton = (DLCreateIconButton)this.m_142416_((GuiEventListener)new DLCreateIconButton(this.guiLeft + 21, this.guiTop + 222, 18, 18, (ScreenElement)AllIcons.I_CONFIG_BACK){

            public void m_5716_(double mouseX, double mouseY) {
                super.m_5716_(mouseX, mouseY);
                AbstractBlacklistScreen.this.m_7379_();
            }
        });
        this.addTooltip(DLTooltip.of((FormattedText)Constants.TOOLTIP_GO_BACK).assignedTo((AbstractWidget)this.backButton));
        this.newEntryBox = this.addEditBox(this.guiLeft + 16 + 5 + 35, this.guiTop + 72 - 28 + 10, 129, 12, "", (Component)TextUtils.empty(), false, s -> this.updateEditorSubwidgets(this.newEntryBox), (box, focus) -> {
            if (!focus.booleanValue()) {
                this.clearSuggestions();
            }
        }, null);
        this.newEntryBox.m_94199_(25);
        this.newEntryBox.m_94202_(0xFFFFFF);
        this.addButton = new GuiAreaDefinition(this.guiLeft + 16 + 165 + 10, this.guiTop + 72 - 28 + 6, 16, 16);
        this.addTooltip(DLTooltip.of((FormattedText)this.tooltipAdd).assignedTo(this.addButton));
        this.searchBox = this.addEditBox(this.guiLeft + 16 + 1, this.guiTop + 16 + 1, 218, 16, "", Constants.TEXT_SEARCH, true, s -> this.initStationDeleteButtons(), null, null);
        this.initialized = true;
        this.initStationDeleteButtons();
    }

    private void initStationDeleteButtons() {
        if (!this.initialized) {
            return;
        }
        this.blacklistEntryButton.clear();
        this.entryAreas.clear();
        String[] names = this.getBlacklistedNames(this.searchBox.m_94155_());
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            this.blacklistEntryButton.put(name, new GuiAreaDefinition(this.guiLeft + 16 + 165 + 10, this.guiTop + 72 + i * 20 + 2, 16, 16));
            this.entryAreas.put(name, new GuiAreaDefinition(this.guiLeft + 16 + 35, this.guiTop + 72 + i * 20 + 2, 129, 16));
        }
    }

    private void addToBlacklistInternal() {
        String value = this.newEntryBox.m_94155_();
        this.newEntryBox.m_94144_("");
        if (value.isBlank()) {
            return;
        }
        this.addToBlacklist(value, this::initStationDeleteButtons);
    }

    private int getMaxScrollHeight() {
        return 10 + 20 * this.getBlacklistedNames(this.searchBox.m_94155_()).length;
    }

    private void clearSuggestions() {
        if (this.suggestions != null) {
            this.suggestions.getEditBox().m_94167_("");
        }
        this.suggestions = null;
    }

    protected void updateEditorSubwidgets(DLEditBox field) {
        if (!this.initialized) {
            return;
        }
        this.clearSuggestions();
        this.suggestions = new ModStationSuggestions(this.f_96541_, (Screen)this, (EditBox)field, this.f_96541_.f_91062_, this.getViableStations(field), field.m_93694_() + 2 + field.f_93621_);
        this.suggestions.setAllowSuggestions(true);
        this.suggestions.updateCommandInfo();
    }

    private List<String> getViableStations(DLEditBox field) {
        return this.getSuggestions().stream().distinct().filter(x -> !this.checkIsBlacklisted((String)x)).sorted((a, b) -> a.compareTo((String)b)).toList();
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.lastScreen);
    }

    public void m_86600_() {
        super.m_86600_();
        this.scroll.tickChaser();
        float scrollMax = this.getMaxScrollHeight();
        if (this.scroll.getValue() > 0.0f && this.scroll.getValue() > scrollMax) {
            this.scroll.chase((double)Math.max(0.0f, scrollMax), (double)0.7f, LerpedFloat.Chaser.EXP);
        }
        if (this.suggestions != null) {
            this.suggestions.tick();
            if (!this.newEntryBox.m_94204_()) {
                this.clearSuggestions();
            }
        }
    }

    public void renderMainLayer(Graphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        pPartialTick = Minecraft.m_91087_().m_91296_();
        float scrollOffset = -this.scroll.getValue(pPartialTick);
        this.renderScreenBackground(graphics);
        GuiUtils.drawTexture((ResourceLocation)GUI, (Graphics)graphics, (int)this.guiLeft, (int)this.guiTop, (int)0, (int)0, (int)255, (int)247);
        GuiUtils.drawTexture((ResourceLocation)WIDGETS, (Graphics)graphics, (int)(this.guiLeft + 16 + 10), (int)(this.guiTop + 72 - 28), (int)0, (int)110, (int)200, (int)28);
        GuiUtils.drawTexture((ResourceLocation)WIDGETS, (Graphics)graphics, (int)(this.guiLeft + 16 + 35), (int)(this.guiTop + 72 - 28 + 5), (int)0, (int)92, (int)139, (int)18);
        GuiUtils.drawTexture((ResourceLocation)WIDGETS, (Graphics)graphics, (int)this.addButton.getX(), (int)this.addButton.getY(), (int)200, (int)16, (int)16, (int)16);
        if (this.addButton.isInBounds((double)pMouseX, (double)pMouseY)) {
            GuiUtils.fill((Graphics)graphics, (int)this.addButton.getX(), (int)this.addButton.getY(), (int)this.addButton.getWidth(), (int)this.addButton.getHeight(), (int)0x1AFFFFFF);
        }
        GuiUtils.enableScissor((Graphics)graphics, (int)(this.guiLeft + 16), (int)(this.guiTop + 72), (int)220, (int)138);
        graphics.poseStack().m_85837_(0.0, (double)scrollOffset, 0.0);
        String[] blacklist = this.getBlacklistedNames(this.searchBox.m_94155_());
        for (int i = 0; i < blacklist.length; ++i) {
            GuiUtils.drawTexture((ResourceLocation)WIDGETS, (Graphics)graphics, (int)(this.guiLeft + 16 + 10), (int)(this.guiTop + 72 + i * 20), (int)0, (int)4, (int)200, (int)20);
        }
        GuiUtils.drawTexture((ResourceLocation)WIDGETS, (Graphics)graphics, (int)(this.guiLeft + 16 + 10), (int)(this.guiTop + 72 + blacklist.length * 20), (int)0, (int)23, (int)200, (int)3);
        GuiUtils.drawTexture((ResourceLocation)WIDGETS, (Graphics)graphics, (int)(this.guiLeft + 16 + 10), (int)(this.guiTop + 72 + blacklist.length * 20 + 3), (int)0, (int)46, (int)200, (int)2);
        for (GuiAreaDefinition def : this.blacklistEntryButton.values()) {
            GuiUtils.drawTexture((ResourceLocation)WIDGETS, (Graphics)graphics, (int)def.getX(), (int)def.getY(), (int)232, (int)0, (int)16, (int)16);
            if (!def.isInBounds((double)pMouseX, (double)((float)pMouseY - scrollOffset))) continue;
            GuiUtils.fill((Graphics)graphics, (int)def.getX(), (int)def.getY(), (int)def.getWidth(), (int)def.getHeight(), (int)0x1AFFFFFF);
        }
        for (int i = 0; i < blacklist.length; ++i) {
            MutableComponent name = TextUtils.text((String)blacklist[i]);
            int maxTextWidth = 129;
            if (this.shadowlessFont.m_92852_((FormattedText)name) > maxTextWidth) {
                name = TextUtils.text((String)this.shadowlessFont.m_92854_((FormattedText)name, maxTextWidth).getString()).m_7220_(Constants.ELLIPSIS_STRING);
            }
            GuiUtils.drawString((Graphics)graphics, (Font)this.shadowlessFont, (int)(this.guiLeft + 16 + 40), (int)(this.guiTop + 72 + i * 20 + 6), (FormattedText)name, (int)0xFFFFFF, (EAlignment)EAlignment.LEFT, (boolean)false);
        }
        GuiUtils.disableScissor((Graphics)graphics);
        GuiUtils.fillGradient((Graphics)graphics, (int)(this.guiLeft + 16), (int)(this.guiTop + 72 - 38), (int)0, (int)220, (int)10, (int)0x77000000, (int)0);
        GuiUtils.fillGradient((Graphics)graphics, (int)(this.guiLeft + 16), (int)(this.guiTop + 72 + 138 - 10), (int)0, (int)220, (int)10, (int)0, (int)0x77000000);
        GuiUtils.fillGradient((Graphics)graphics, (int)(this.guiLeft + 16 + 10), (int)(this.guiTop + 72), (int)0, (int)200, (int)10, (int)0x77000000, (int)0);
        super.renderMainLayer(graphics, pMouseX, pMouseY, pPartialTick);
        double maxHeight = this.getMaxScrollHeight();
        double aH = 139.0;
        if (aH / maxHeight < 1.0) {
            int scrollerHeight = Math.max(10, (int)(aH * (aH / maxHeight)));
            int startY = this.guiTop + 72 + (int)(138.0 * ((double)Math.abs(scrollOffset) / maxHeight));
            GuiUtils.fill((Graphics)graphics, (int)(this.guiLeft + 16 + 220 - 3), (int)startY, (int)3, (int)scrollerHeight, (int)Integer.MAX_VALUE);
        }
        GuiUtils.drawString((Graphics)graphics, (Font)this.shadowlessFont, (int)(this.guiLeft + 19), (int)(this.guiTop + 4), (FormattedText)this.f_96539_, (int)-11579569, (EAlignment)EAlignment.LEFT, (boolean)false);
        String timeString = TimeUtils.parseTime((long)((int)((this.level.m_46468_() + 6000L) % 24000L)), (TimeUtils.TimeFormat)((TimeUtils.TimeFormat)ModClientConfig.TIME_FORMAT.get()));
        GuiUtils.drawString((Graphics)graphics, (Font)this.shadowlessFont, (int)(this.guiLeft + 255 - 22 - this.shadowlessFont.m_92895_(timeString)), (int)(this.guiTop + 4), (FormattedText)TextUtils.text((String)timeString), (int)-11579569, (EAlignment)EAlignment.LEFT, (boolean)false);
    }

    public void renderFrontLayer(Graphics graphics, int mouseX, int mouseY, float partialTick) {
        if (this.suggestions != null) {
            graphics.poseStack().m_85836_();
            graphics.poseStack().m_85837_(0.0, 0.0, 500.0);
            this.suggestions.render(graphics.poseStack(), mouseX, mouseY);
            graphics.poseStack().m_85849_();
        }
        float scrollOffset = this.scroll.getValue(partialTick);
        if (mouseX > this.guiLeft + 16 && mouseX < this.guiLeft + 16 + 220 && mouseY > this.guiTop + 72 && mouseY < this.guiTop + 72 + 138) {
            for (Map.Entry<String, GuiAreaDefinition> entry : this.blacklistEntryButton.entrySet()) {
                if (GuiUtils.renderTooltipWithOffset((Screen)this, (GuiAreaDefinition)entry.getValue(), List.of(this.tooltipRemove), (int)this.f_96543_, (Graphics)graphics, (int)mouseX, (int)mouseY, (int)0, (int)((int)scrollOffset))) break;
            }
            for (Map.Entry<String, GuiAreaDefinition> entry : this.entryAreas.entrySet()) {
                if (this.shadowlessFont.m_92895_(entry.getKey()) > 129 && GuiUtils.renderTooltipAt((Screen)this, (GuiAreaDefinition)entry.getValue(), List.of(TextUtils.text((String)entry.getKey())), (int)this.f_96543_, (Graphics)graphics, (int)(entry.getValue().getLeft() + 1), (int)((int)((float)entry.getValue().getTop() - scrollOffset)), (int)mouseX, (int)mouseY, (int)0, (int)((int)scrollOffset))) break;
            }
        }
        super.renderFrontLayer(graphics, mouseX, mouseY, partialTick);
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        if (this.suggestions != null && this.suggestions.mouseClicked((int)pMouseX, (int)pMouseY, pButton)) {
            GuiUtils.playButtonSound();
            return super.m_6375_(pMouseX, pMouseY, pButton);
        }
        float scrollOffset = this.scroll.getValue();
        if (this.addButton.isInBounds(pMouseX, pMouseY) && !this.newEntryBox.m_94155_().isBlank()) {
            this.addToBlacklistInternal();
            GuiUtils.playButtonSound();
            return super.m_6375_(pMouseX, pMouseY, pButton);
        }
        if (pMouseX > (double)(this.guiLeft + 16) && pMouseX < (double)(this.guiLeft + 16 + 220) && pMouseY > (double)(this.guiTop + 72) && pMouseY < (double)(this.guiTop + 72 + 138) && this.blacklistEntryButton.values().stream().anyMatch(x -> x.isInBounds(pMouseX, pMouseY + (double)scrollOffset))) {
            for (Map.Entry<String, GuiAreaDefinition> entry : this.blacklistEntryButton.entrySet()) {
                if (!entry.getValue().isInBounds(pMouseX, pMouseY + (double)scrollOffset)) continue;
                this.removeFromBlacklist(entry.getKey(), this::initStationDeleteButtons);
                GuiUtils.playButtonSound();
                return super.m_6375_(pMouseX, pMouseY + (double)scrollOffset, pButton);
            }
        }
        return super.m_6375_(pMouseX, pMouseY, pButton);
    }

    public boolean m_7933_(int pKeyCode, int pScanCode, int pModifiers) {
        if (this.suggestions != null && this.suggestions.keyPressed(pKeyCode, pScanCode, pModifiers)) {
            return true;
        }
        return super.m_7933_(pKeyCode, pScanCode, pModifiers);
    }

    public boolean m_6050_(double pMouseX, double pMouseY, double pDelta) {
        if (this.suggestions != null && this.suggestions.mouseScrolled(pMouseX, pMouseY, Mth.m_14008_((double)pDelta, (double)-1.0, (double)1.0))) {
            return true;
        }
        float chaseTarget = this.scroll.getChaseTarget();
        float max = -138 + this.getMaxScrollHeight();
        if (max > 0.0f) {
            chaseTarget = (float)((double)chaseTarget - pDelta * 12.0);
            chaseTarget = Mth.m_14036_((float)chaseTarget, (float)0.0f, (float)max);
            this.scroll.chase((double)((int)chaseTarget), (double)0.7f, LerpedFloat.Chaser.EXP);
        } else {
            this.scroll.chase(0.0, (double)0.7f, LerpedFloat.Chaser.EXP);
        }
        return super.m_6050_(pMouseX, pMouseY, pDelta);
    }
}

