/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.ber.variants;

import com.mojang.blaze3d.vertex.PoseStack;
import de.mrjulsen.crn.block.be.AdvancedDisplayBlockEntity;
import de.mrjulsen.crn.client.ber.AdvancedDisplayRenderInstance;
import de.mrjulsen.crn.client.ber.base.BERText;
import de.mrjulsen.crn.client.ber.variants.IBERRenderSubtype;
import de.mrjulsen.crn.client.lang.ELanguage;
import de.mrjulsen.crn.config.ModClientConfig;
import de.mrjulsen.crn.data.DeparturePrediction;
import de.mrjulsen.crn.util.ModUtils;
import de.mrjulsen.mcdragonlib.client.ber.IBlockEntityRendererInstance;
import de.mrjulsen.mcdragonlib.util.DLUtils;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.TimeUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class BERPlatformInformative
implements IBERRenderSubtype<AdvancedDisplayBlockEntity, AdvancedDisplayRenderInstance, Boolean> {
    private List<DeparturePrediction.SimpleDeparturePrediction> lastPredictions = new ArrayList<DeparturePrediction.SimpleDeparturePrediction>();
    private static final int TIME_LABEL_WIDTH = 16;
    private static final int SPACING = 4;
    private static final String keyPlatform = "gui.createrailwaysnavigator.platform";
    private static final String keyLine = "gui.createrailwaysnavigator.line";
    private static final String keyDestination = "gui.createrailwaysnavigator.destination";
    private static final String keyDeparture = "gui.createrailwaysnavigator.departure";
    private static final String keyFollowingTrains = "gui.createrailwaysnavigator.following_trains";
    private boolean wasPlatformFixed;

    @Override
    public boolean isSingleLined() {
        return false;
    }

    @Override
    public void tick(Level level, BlockPos pos, BlockState state, AdvancedDisplayBlockEntity pBlockEntity, AdvancedDisplayRenderInstance parent) {
    }

    private boolean extendedDisplay(AdvancedDisplayBlockEntity blockEntity) {
        return blockEntity.getYSize() > 1;
    }

    @Override
    public void renderAdditional(IBlockEntityRendererInstance.BlockEntityRendererContext context, AdvancedDisplayBlockEntity pBlockEntity, AdvancedDisplayRenderInstance parent, float pPartialTicks, PoseStack pPoseStack, MultiBufferSource pBufferSource, int pPackedLight, int pOverlay, Boolean backSide) {
        boolean isPlatformFixed = pBlockEntity.isPlatformFixed();
        context.renderUtils().initRenderEngine();
        if (!isPlatformFixed) {
            context.renderUtils().fillColor(pBufferSource, (BlockEntity)pBlockEntity, 0xFF000000 | pBlockEntity.getColor() & 0xFFFFFF, pPoseStack, 2.5f, 6.0f, 0.0f, (float)(pBlockEntity.getXSizeScaled() * 16 - 5), 0.25f, (Direction)pBlockEntity.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_), pPackedLight);
            int count = pBlockEntity.getPlatformInfoLinesCount();
            for (int i = 0; i < count; i += 2) {
                context.renderUtils().fillColor(pBufferSource, (BlockEntity)pBlockEntity, 0x22FFFFFF, pPoseStack, 2.0f, 4.0f + (float)(i + 1) * 5.34f - 1.0f, 0.0f, (float)(pBlockEntity.getXSizeScaled() * 16 - 4), 5.34f, (Direction)pBlockEntity.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_), pPackedLight);
            }
        } else if (this.extendedDisplay(pBlockEntity)) {
            context.renderUtils().fillColor(pBufferSource, (BlockEntity)pBlockEntity, 0xFF000000 | pBlockEntity.getColor() & 0xFFFFFF, pPoseStack, 2.5f, 15.5f, 0.0f, (float)(pBlockEntity.getXSizeScaled() * 16 - 5), 0.25f, (Direction)pBlockEntity.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_), pPackedLight);
        }
    }

    @Override
    public void update(Level level, BlockPos pos, BlockState state, AdvancedDisplayBlockEntity blockEntity, AdvancedDisplayRenderInstance parent, IBlockEntityRendererInstance.EUpdateReason reason) {
        block6: {
            List<DeparturePrediction.SimpleDeparturePrediction> preds = blockEntity.getPredictions();
            boolean isPlatformFixed = blockEntity.isPlatformFixed();
            int maxLines = blockEntity.getPlatformInfoLinesCount() - (isPlatformFixed ? 1 : 0);
            boolean refreshAll = reason != IBlockEntityRendererInstance.EUpdateReason.DATA_CHANGED || !DLUtils.compareCollections(this.lastPredictions, preds, (a, b) -> a.stationInfo().platform().equals(b.stationInfo().platform()) && a.trainId().equals(b.trainId())) || this.wasPlatformFixed != isPlatformFixed;
            this.lastPredictions = preds;
            this.wasPlatformFixed = blockEntity.isPlatformFixed();
            if (!refreshAll) break block6;
            parent.labels.clear();
            if (isPlatformFixed) {
                this.addNextDeparture(level, pos, state, blockEntity, parent, reason, 0);
            } else {
                this.addHeader(level, pos, state, blockEntity, parent, reason);
            }
            if (isPlatformFixed && preds.size() > 0) {
                for (int i = 1; i < maxLines && i < preds.size(); ++i) {
                    this.addLine(level, pos, state, blockEntity, parent, reason, i, 4.0f + (float)(i + 2) * 5.4f);
                }
            } else {
                for (int i = 0; i < maxLines && i < preds.size(); ++i) {
                    this.addLine(level, pos, state, blockEntity, parent, reason, i, 4.0f + (float)(i + 1) * 5.34f);
                }
            }
        }
    }

    private void addLine(Level level, BlockPos pos, BlockState state, AdvancedDisplayBlockEntity blockEntity, AdvancedDisplayRenderInstance parent, IBlockEntityRendererInstance.EUpdateReason reason, int predictionIdx, float y) {
        float displayWidth = blockEntity.getXSizeScaled() * 16 - 4;
        MutableComponent label = blockEntity.isPlatformFixed() ? TextUtils.empty() : TextUtils.text((String)this.lastPredictions.get(predictionIdx).stationInfo().platform());
        float labelWidth = blockEntity.getPlatformWidth() < 0 ? (float)parent.getFontUtils().font.m_92852_((FormattedText)label) * 0.4f : Math.min((float)parent.getFontUtils().font.m_92852_((FormattedText)label) * 0.4f, (float)(blockEntity.getPlatformWidth() - 2));
        int platformMaxWidth = blockEntity.getPlatformWidth() < 0 ? (int)(displayWidth - 6.0f) : blockEntity.getPlatformWidth() - 2;
        BERText lastLabel = new BERText(parent.getFontUtils(), (Component)label, 0.0f).withIsCentered(false).withMaxWidth(platformMaxWidth, true).withStretchScale(0.2f, 0.4f).withStencil(0.0f, platformMaxWidth).withColor(0xFF000000 | blockEntity.getColor()).withPredefinedTextTransformation(new BERText.TextTransformation((float)(blockEntity.getXSizeScaled() * 16 - 3) - labelWidth, y, 0.01f, 1.0f, 0.4f)).build();
        parent.labels.add(lastLabel);
        parent.labels.add(new BERText(parent.getFontUtils(), () -> {
            ArrayList<MutableComponent> texts = new ArrayList<MutableComponent>();
            switch (blockEntity.getTimeDisplay()) {
                case ETA: {
                    texts.add(TextUtils.text((String)ModUtils.timeRemainingString(this.lastPredictions.get(predictionIdx).departureTicks())));
                    break;
                }
                default: {
                    int rawTime = (int)(blockEntity.getLastRefreshedTime() % 24000L + 6000L + (long)this.lastPredictions.get(predictionIdx).departureTicks());
                    texts.add(TextUtils.text((String)TimeUtils.parseTime((long)(rawTime - rawTime % (Integer)ModClientConfig.REALTIME_PRECISION_THRESHOLD.get()), (TimeUtils.TimeFormat)((TimeUtils.TimeFormat)ModClientConfig.TIME_FORMAT.get()))));
                }
            }
            return texts;
        }, 0.0f).withIsCentered(false).withMaxWidth(12.0f, true).withStretchScale(0.2f, 0.4f).withStencil(0.0f, 12.0f).withColor(0xFF000000 | blockEntity.getColor()).withRefreshRate(100).withPredefinedTextTransformation(new BERText.TextTransformation(3.0f, y, 0.01f, 1.0f, 0.4f)).build());
        float platformWidth = blockEntity.getPlatformWidth() < 0 ? lastLabel.getScaledTextWidth() + 2.0f : (float)blockEntity.getPlatformWidth();
        byte trainNameWidth = blockEntity.getTrainNameWidth();
        lastLabel = new BERText(parent.getFontUtils(), () -> {
            ArrayList<MutableComponent> texts = new ArrayList<MutableComponent>();
            texts.add(TextUtils.text((String)this.lastPredictions.get(predictionIdx).trainName()));
            return texts;
        }, 0.0f).withIsCentered(false).withMaxWidth(Math.min((float)(trainNameWidth - 1), displayWidth - 16.0f - platformWidth - 1.0f), false).withStretchScale(0.2f, 0.4f).withStencil(0.0f, Math.min((float)(trainNameWidth - 1), displayWidth - 16.0f - platformWidth - 1.0f)).withColor(0xFF000000 | blockEntity.getColor()).withPredefinedTextTransformation(new BERText.TextTransformation(16.0f, y, 0.01f, 1.0f, 0.4f)).build();
        parent.labels.add(lastLabel);
        lastLabel = new BERText(parent.getFontUtils(), () -> {
            ArrayList<MutableComponent> texts = new ArrayList<MutableComponent>();
            texts.add(TextUtils.text((String)this.lastPredictions.get(predictionIdx).scheduleTitle()));
            return texts;
        }, 0.0f).withIsCentered(false).withMaxWidth(displayWidth - 16.0f - (float)trainNameWidth - platformWidth + 1.0f - 4.0f, true).withStretchScale(0.25f, 0.4f).withStencil(0.0f, displayWidth - 16.0f - (float)trainNameWidth - platformWidth + 1.0f - 4.0f).withCanScroll(true, 1.0f).withColor(0xFF000000 | blockEntity.getColor()).withPredefinedTextTransformation(new BERText.TextTransformation(16 + trainNameWidth + 4, y, 0.01f, 1.0f, 0.4f)).build();
        parent.labels.add(lastLabel);
    }

    private void addNextDeparture(Level level, BlockPos pos, BlockState state, AdvancedDisplayBlockEntity blockEntity, AdvancedDisplayRenderInstance parent, IBlockEntityRendererInstance.EUpdateReason reason, int predictionIdx) {
        float displayWidth = blockEntity.getXSizeScaled() * 16 - 6;
        int timeLabelWidth = 13;
        MutableComponent label = TextUtils.text((String)blockEntity.getStationInfo().platform()).m_130940_(ChatFormatting.BOLD);
        float labelWidth = (float)parent.getFontUtils().font.m_92852_((FormattedText)label) * 0.6f;
        BERText lastLabel = new BERText(parent.getFontUtils(), (Component)label, 0.0f).withIsCentered(false).withMaxWidth(16.0f, true).withStretchScale(0.6f, 0.6f).withStencil(0.0f, displayWidth).withColor(0xFF000000 | blockEntity.getColor()).withPredefinedTextTransformation(new BERText.TextTransformation(displayWidth - labelWidth + 3.0f, 3.0f, 0.0f, 1.0f, 1.0f)).build();
        parent.labels.add(lastLabel);
        if (this.lastPredictions.size() <= 0) {
            return;
        }
        float platformWidth = lastLabel.getScaledTextWidth();
        parent.labels.add(new BERText(parent.getFontUtils(), () -> {
            ArrayList<MutableComponent> texts = new ArrayList<MutableComponent>();
            switch (blockEntity.getTimeDisplay()) {
                case ETA: {
                    texts.add(TextUtils.text((String)ModUtils.timeRemainingString(this.lastPredictions.get(predictionIdx).departureTicks())));
                    break;
                }
                default: {
                    int rawTime = (int)(blockEntity.m_58904_().m_46468_() % 24000L + 6000L + (long)this.lastPredictions.get(predictionIdx).departureTicks());
                    texts.add(TextUtils.text((String)TimeUtils.parseTime((long)(rawTime - rawTime % (Integer)ModClientConfig.REALTIME_PRECISION_THRESHOLD.get()), (TimeUtils.TimeFormat)((TimeUtils.TimeFormat)ModClientConfig.TIME_FORMAT.get()))));
                }
            }
            return texts;
        }, 0.0f).withIsCentered(false).withMaxWidth(timeLabelWidth, true).withStretchScale(0.2f, 0.4f).withStencil(0.0f, timeLabelWidth).withRefreshRate(100).withColor(0xFF000000 | blockEntity.getColor()).withPredefinedTextTransformation(new BERText.TextTransformation(3.0f, 3.0f, 0.0f, 1.0f, 0.4f)).build());
        parent.labels.add(new BERText(parent.getFontUtils(), (Component)TextUtils.text((String)this.lastPredictions.get(predictionIdx).trainName()), 0.0f).withIsCentered(false).withMaxWidth(timeLabelWidth, true).withStretchScale(0.15f, 0.3f).withStencil(0.0f, timeLabelWidth).withColor(0xFF000000 | blockEntity.getColor()).withPredefinedTextTransformation(new BERText.TextTransformation(3.0f, 7.0f, 0.0f, 1.0f, 0.3f)).build());
        parent.labels.add(new BERText(parent.getFontUtils(), (Component)TextUtils.text((String)this.lastPredictions.get(predictionIdx).scheduleTitle()).m_130940_(ChatFormatting.BOLD), 0.0f).withIsCentered(false).withMaxWidth(displayWidth - (float)timeLabelWidth - platformWidth - 5.0f, true).withStretchScale(0.3f, 0.6f).withStencil(0.0f, displayWidth - (float)timeLabelWidth - platformWidth - 5.0f).withCanScroll(true, 0.5f).withColor(0xFF000000 | blockEntity.getColor()).withPredefinedTextTransformation(new BERText.TextTransformation(3 + timeLabelWidth + 1, 8.0f, 0.0f, 1.0f, 0.6f)).build());
        parent.labels.add(new BERText(parent.getFontUtils(), (Component)parent.getStopoversString(blockEntity), 0.0f).withIsCentered(false).withMaxWidth(displayWidth - 16.0f - platformWidth - 2.0f, true).withStretchScale(0.2f, 0.25f).withStencil(0.0f, displayWidth - 16.0f - platformWidth - 2.0f).withCanScroll(true, 0.5f).withColor(0xFF000000 | blockEntity.getColor()).withPredefinedTextTransformation(new BERText.TextTransformation(17.0f, 5.0f, 0.0f, 1.0f, 0.25f)).build());
        if (this.extendedDisplay(blockEntity)) {
            parent.labels.add(new BERText(parent.getFontUtils(), (Component)ELanguage.translate(keyFollowingTrains), 0.0f).withIsCentered(false).withMaxWidth(displayWidth, true).withStretchScale(0.15f, 0.2f).withStencil(0.0f, displayWidth).withColor(0xFF000000 | blockEntity.getColor()).withPredefinedTextTransformation(new BERText.TextTransformation(3.0f, 17.0f, 0.0f, 1.0f, 0.2f)).build());
        }
    }

    private void addHeader(Level level, BlockPos pos, BlockState state, AdvancedDisplayBlockEntity blockEntity, AdvancedDisplayRenderInstance parent, IBlockEntityRendererInstance.EUpdateReason reason) {
        float displayWidth = blockEntity.getXSizeScaled() * 16 - 4;
        float TIME_LABEL_WIDTH = 16.0f;
        parent.labels.add(new BERText(parent.getFontUtils(), (Component)ELanguage.translate(keyDeparture).m_130940_(ChatFormatting.BOLD).m_130940_(ChatFormatting.ITALIC), 0.0f).withIsCentered(false).withMaxWidth(TIME_LABEL_WIDTH - 4.0f, true).withStretchScale(0.15f, 0.3f).withStencil(0.0f, Math.min(TIME_LABEL_WIDTH - 4.0f, displayWidth - 2.0f)).withColor(0xFF000000 | blockEntity.getColor()).withPredefinedTextTransformation(new BERText.TextTransformation(3.0f, 3.0f, 0.0f, 1.0f, 0.3f)).build());
        MutableComponent label = ELanguage.translate(keyPlatform).m_130940_(ChatFormatting.BOLD).m_130940_(ChatFormatting.ITALIC);
        float labelWidth = blockEntity.getPlatformWidth() < 0 ? (float)parent.getFontUtils().font.m_92852_((FormattedText)label) * 0.3f : Math.min((float)parent.getFontUtils().font.m_92852_((FormattedText)label) * 0.4f, (float)(blockEntity.getPlatformWidth() - 2));
        int platformMaxWidth = blockEntity.getPlatformWidth() < 0 ? (int)(displayWidth - 6.0f) : blockEntity.getPlatformWidth() - 2;
        BERText lastLabel = new BERText(parent.getFontUtils(), (Component)label, 0.0f).withIsCentered(false).withMaxWidth(platformMaxWidth, true).withStretchScale(0.15f, 0.3f).withStencil(0.0f, labelWidth).withColor(0xFF000000 | blockEntity.getColor()).withPredefinedTextTransformation(new BERText.TextTransformation((float)(blockEntity.getXSizeScaled() * 16 - 3) - labelWidth, 3.0f, 0.0f, 1.0f, 0.3f)).build();
        parent.labels.add(lastLabel);
        float platformWidth = blockEntity.getPlatformWidth() < 0 ? lastLabel.getScaledTextWidth() + 2.0f : (float)blockEntity.getPlatformWidth();
        byte trainNameWidth = blockEntity.getTrainNameWidth();
        lastLabel = new BERText(parent.getFontUtils(), (Component)ELanguage.translate(keyLine).m_130940_(ChatFormatting.BOLD).m_130940_(ChatFormatting.ITALIC), 0.0f).withIsCentered(false).withMaxWidth(Math.min((float)(trainNameWidth - 1), displayWidth - TIME_LABEL_WIDTH - platformWidth - 1.0f), true).withStretchScale(0.15f, 0.3f).withStencil(0.0f, Math.min((float)(trainNameWidth - 1), displayWidth - TIME_LABEL_WIDTH - platformWidth - 1.0f)).withColor(0xFF000000 | blockEntity.getColor()).withPredefinedTextTransformation(new BERText.TextTransformation(TIME_LABEL_WIDTH, 3.0f, 0.0f, 1.0f, 0.3f)).build();
        parent.labels.add(lastLabel);
        lastLabel = new BERText(parent.getFontUtils(), (Component)ELanguage.translate(keyDestination).m_130940_(ChatFormatting.BOLD).m_130940_(ChatFormatting.ITALIC), 0.0f).withIsCentered(false).withMaxWidth(displayWidth - TIME_LABEL_WIDTH - (float)trainNameWidth - platformWidth + 1.0f, true).withStretchScale(0.15f, 0.3f).withStencil(0.0f, displayWidth - TIME_LABEL_WIDTH - (float)trainNameWidth - platformWidth + 1.0f).withColor(0xFF000000 | blockEntity.getColor()).withPredefinedTextTransformation(new BERText.TextTransformation(TIME_LABEL_WIDTH + (float)trainNameWidth, 3.0f, 0.0f, 1.0f, 0.3f)).build();
        parent.labels.add(lastLabel);
    }
}

