/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.ber;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import de.mrjulsen.crn.block.AbstractAdvancedDisplayBlock;
import de.mrjulsen.crn.block.AbstractAdvancedSidedDisplayBlock;
import de.mrjulsen.crn.block.be.AdvancedDisplayBlockEntity;
import de.mrjulsen.crn.client.ber.base.BERText;
import de.mrjulsen.crn.client.ber.variants.BERPassengerInfoDetailed;
import de.mrjulsen.crn.client.ber.variants.BERPassengerInfoInformative;
import de.mrjulsen.crn.client.ber.variants.BERPassengerInfoSimple;
import de.mrjulsen.crn.client.ber.variants.BERPlatformDetailed;
import de.mrjulsen.crn.client.ber.variants.BERPlatformInformative;
import de.mrjulsen.crn.client.ber.variants.BERPlatformSimple;
import de.mrjulsen.crn.client.ber.variants.BERRenderSubtypeBase;
import de.mrjulsen.crn.client.ber.variants.BERTrainDestinationDetailed;
import de.mrjulsen.crn.client.ber.variants.BERTrainDestinationInformative;
import de.mrjulsen.crn.client.ber.variants.BERTrainDestinationSimple;
import de.mrjulsen.crn.client.ber.variants.IBERRenderSubtype;
import de.mrjulsen.crn.data.EDisplayInfo;
import de.mrjulsen.crn.data.EDisplayType;
import de.mrjulsen.crn.data.ESide;
import de.mrjulsen.mcdragonlib.client.ber.AbstractBlockEntityRenderInstance;
import de.mrjulsen.mcdragonlib.client.ber.IBlockEntityRendererInstance;
import de.mrjulsen.mcdragonlib.data.Pair;
import de.mrjulsen.mcdragonlib.data.Tripple;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class AdvancedDisplayRenderInstance
extends AbstractBlockEntityRenderInstance<AdvancedDisplayBlockEntity> {
    private Map<EDisplayType, Map<EDisplayInfo, Supplier<IBERRenderSubtype<AdvancedDisplayBlockEntity, AdvancedDisplayRenderInstance, Boolean>>>> renderSubtypes;
    public Collection<BERText> labels;
    public BERText carriageIndexLabel;
    public IBERRenderSubtype<AdvancedDisplayBlockEntity, AdvancedDisplayRenderInstance, Boolean> renderSubtype;
    private int lastXSize = 0;
    private EDisplayType lastType;
    private EDisplayInfo lastInfo;

    public AdvancedDisplayRenderInstance(AdvancedDisplayBlockEntity blockEntity) {
        super((BlockEntity)blockEntity);
    }

    protected void preinit(AdvancedDisplayBlockEntity blockEntity) {
        this.labels = new ArrayList<BERText>();
        this.renderSubtypes = Map.of(EDisplayType.TRAIN_DESTINATION, Map.of(EDisplayInfo.SIMPLE, () -> new BERTrainDestinationSimple(), EDisplayInfo.DETAILED, () -> new BERTrainDestinationDetailed(), EDisplayInfo.INFORMATIVE, () -> new BERTrainDestinationInformative()), EDisplayType.PASSENGER_INFORMATION, Map.of(EDisplayInfo.SIMPLE, () -> new BERPassengerInfoSimple(), EDisplayInfo.DETAILED, () -> new BERPassengerInfoDetailed(), EDisplayInfo.INFORMATIVE, () -> new BERPassengerInfoInformative()), EDisplayType.PLATFORM, Map.of(EDisplayInfo.SIMPLE, () -> new BERPlatformSimple(), EDisplayInfo.DETAILED, () -> new BERPlatformDetailed(), EDisplayInfo.INFORMATIVE, () -> new BERPlatformInformative()));
    }

    public MutableComponent getStopoversString(AdvancedDisplayBlockEntity blockEntity) {
        MutableComponent line = TextUtils.empty();
        List<String> stopovers = blockEntity.getDisplayType().getSource() == EDisplayType.EDisplayTypeDataSource.TRAIN_INFORMATION ? blockEntity.getTrainData().stopovers().stream().map(x -> x.stationTagName()).toList() : blockEntity.getNextDepartureStopovers();
        Iterator<String> i = stopovers.iterator();
        boolean isFirst = true;
        while (i.hasNext()) {
            if (!isFirst) {
                line = line.m_7220_((Component)TextUtils.text((String)" \u25cf "));
            }
            line = line.m_7220_((Component)TextUtils.text((String)i.next()));
            isFirst = false;
        }
        return line;
    }

    public void render(IBlockEntityRendererInstance.BlockEntityRendererContext context, AdvancedDisplayBlockEntity pBlockEntity, float pPartialTicks, PoseStack pPoseStack, MultiBufferSource pBufferSource, int pPackedLight, int pOverlay) {
        int light;
        if (!pBlockEntity.isController()) {
            return;
        }
        int n = light = pBlockEntity.isGlowing() ? 0xF000F0 : pPackedLight;
        if (pBlockEntity.m_58900_().m_60734_() instanceof AbstractAdvancedDisplayBlock) {
            Tripple rotation = (Tripple)pBlockEntity.renderRotation.get();
            Pair offset = (Pair)pBlockEntity.renderOffset.get();
            Pair zOffset = (Pair)pBlockEntity.renderZOffset.get();
            float scale = ((Float)pBlockEntity.renderScale.get()).floatValue();
            pPoseStack.m_85836_();
            pPoseStack.m_85837_((double)((Float)offset.getFirst()).floatValue(), (double)((Float)offset.getSecond()).floatValue(), (double)((Float)zOffset.getFirst()).floatValue());
            pPoseStack.m_85845_(Vector3f.f_122223_.m_122240_(((Float)rotation.getFirst()).floatValue()));
            pPoseStack.m_85845_(Vector3f.f_122225_.m_122240_(((Float)rotation.getSecond()).floatValue()));
            pPoseStack.m_85845_(Vector3f.f_122227_.m_122240_(((Float)rotation.getThird()).floatValue()));
            pPoseStack.m_85841_(scale, scale, 1.0f);
            this.renderSubtype.renderAdditional(context, pBlockEntity, this, pPartialTicks, pPoseStack, pBufferSource, light, pOverlay, false);
            this.labels.forEach(x -> x.render(pPoseStack, pBufferSource, light));
            pPoseStack.m_85849_();
            if (!(pBlockEntity.m_58900_().m_60734_() instanceof AbstractAdvancedSidedDisplayBlock) || pBlockEntity.m_58900_().m_61143_(AbstractAdvancedSidedDisplayBlock.SIDE) == ESide.BOTH) {
                pPoseStack.m_85836_();
                pPoseStack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
                pPoseStack.m_85837_((double)(-pBlockEntity.getXSize() * 16), 0.0, -16.0);
                pPoseStack.m_85837_((double)((Float)offset.getFirst()).floatValue(), (double)((Float)offset.getSecond()).floatValue(), (double)((Float)zOffset.getSecond()).floatValue());
                pPoseStack.m_85845_(Vector3f.f_122223_.m_122240_(((Float)rotation.getFirst()).floatValue()));
                pPoseStack.m_85845_(Vector3f.f_122225_.m_122240_(((Float)rotation.getSecond()).floatValue()));
                pPoseStack.m_85845_(Vector3f.f_122227_.m_122240_(((Float)rotation.getThird()).floatValue()));
                pPoseStack.m_85841_(scale, scale, 1.0f);
                this.renderSubtype.renderAdditional(context, pBlockEntity, this, pPartialTicks, pPoseStack, pBufferSource, light, pOverlay, true);
                this.labels.forEach(x -> x.render(pPoseStack, pBufferSource, light));
                pPoseStack.m_85849_();
            }
        }
    }

    public void tick(Level level, BlockPos pos, BlockState state, AdvancedDisplayBlockEntity blockEntity) {
        this.renderSubtype.tick(level, pos, state, blockEntity, this);
        this.labels.forEach(x -> x.tick());
        if (blockEntity.getXSizeScaled() != this.lastXSize) {
            this.update(level, pos, state, blockEntity, IBlockEntityRendererInstance.EUpdateReason.BLOCK_CHANGED);
        }
        this.lastXSize = blockEntity.getXSizeScaled();
    }

    public void update(Level level, BlockPos pos, BlockState state, AdvancedDisplayBlockEntity blockEntity, IBlockEntityRendererInstance.EUpdateReason reason) {
        this.carriageIndexLabel = null;
        EDisplayType type = blockEntity.getDisplayType();
        EDisplayInfo info = blockEntity.getInfoType();
        if (this.lastType != type || this.lastInfo != info) {
            Map<EDisplayInfo, Supplier<IBERRenderSubtype<AdvancedDisplayBlockEntity, AdvancedDisplayRenderInstance, Boolean>>> selectedType;
            if (this.renderSubtypes.containsKey((Object)type) && (selectedType = this.renderSubtypes.get((Object)type)).containsKey((Object)info)) {
                this.renderSubtype = selectedType.get((Object)info).get();
            }
            if (this.renderSubtype == null) {
                this.renderSubtype = new BERRenderSubtypeBase<AdvancedDisplayBlockEntity, AdvancedDisplayRenderInstance, Boolean>();
            }
        }
        this.lastType = type;
        this.lastInfo = info;
        this.renderSubtype.update(level, pos, state, blockEntity, this, reason);
    }
}

