/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client;

import de.mrjulsen.crn.Constants;
import de.mrjulsen.crn.CreateRailwaysNavigator;
import de.mrjulsen.crn.block.be.AdvancedDisplayBlockEntity;
import de.mrjulsen.crn.client.gui.overlay.RouteDetailsOverlayScreen;
import de.mrjulsen.crn.client.gui.screen.AdvancedDisplaySettingsScreen;
import de.mrjulsen.crn.client.gui.screen.LoadingScreen;
import de.mrjulsen.crn.client.gui.screen.NavigatorScreen;
import de.mrjulsen.crn.client.gui.screen.RouteOverlaySettingsScreen;
import de.mrjulsen.crn.client.lang.ELanguage;
import de.mrjulsen.crn.data.ClientTrainStationSnapshot;
import de.mrjulsen.crn.data.GlobalSettingsManager;
import de.mrjulsen.crn.network.packets.stc.ServerErrorPacket;
import de.mrjulsen.mcdragonlib.client.gui.DLScreen;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import dev.architectury.networking.NetworkManager;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.resources.language.ClientLanguage;
import net.minecraft.client.resources.language.LanguageInfo;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.level.Level;

public class ClientWrapper {
    private static ELanguage currentLanguage;
    private static Language currentClientLanguage;

    public static void showNavigatorGui(Level level) {
        DLScreen.setScreen((DLScreen)new LoadingScreen());
        GlobalSettingsManager.syncToClient(() -> ClientTrainStationSnapshot.syncToClient(() -> DLScreen.setScreen((DLScreen)new NavigatorScreen(level))));
    }

    public static void showRouteOverlaySettingsGui(RouteDetailsOverlayScreen overlay) {
        DLScreen.setScreen((DLScreen)new RouteOverlaySettingsScreen(overlay));
    }

    public static void handleErrorMessagePacket(ServerErrorPacket packet, Supplier<NetworkManager.PacketContext> ctx) {
        Minecraft.m_91087_().m_91300_().m_94922_((Toast)new SystemToast(SystemToast.SystemToastIds.PERIODIC_NOTIFICATION, Constants.TEXT_SERVER_ERROR, (Component)TextUtils.text((String)packet.message)));
    }

    public static void showAdvancedDisplaySettingsScreen(AdvancedDisplayBlockEntity blockEntity) {
        DLScreen.setScreen((DLScreen)new AdvancedDisplaySettingsScreen(blockEntity));
    }

    public static void updateLanguage(ELanguage lang) {
        LanguageInfo info;
        if (currentLanguage == lang) {
            return;
        }
        LanguageInfo languageInfo = info = lang == ELanguage.DEFAULT ? null : Minecraft.m_91087_().m_91102_().m_118976_(lang.getCode());
        if (info == null) {
            info = Minecraft.m_91087_().m_91102_().m_118983_();
        }
        currentLanguage = lang;
        currentClientLanguage = ClientLanguage.m_118916_((ResourceManager)Minecraft.m_91087_().m_91098_(), List.of(info));
        CreateRailwaysNavigator.LOGGER.info("Updated custom language to: " + (info == null ? null : info.getName()));
    }

    public static Language getCurrentClientLanguage() {
        return currentClientLanguage == null ? Language.m_128107_() : currentClientLanguage;
    }
}

