/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createenchantmentindustry.content.contraptions.enchanting.enchanter;

import com.simibubi.create.content.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.simibubi.create.content.kinetics.belt.transport.TransportedItemStack;
import com.simibubi.create.content.schematics.requirement.ItemRequirement;
import com.simibubi.create.foundation.advancement.CreateAdvancement;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.fluid.SmartFluidTank;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.BlockHelper;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.VecHelper;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import plus.dragons.createenchantmentindustry.EnchantmentIndustry;
import plus.dragons.createenchantmentindustry.content.contraptions.enchanting.enchanter.BlazeEnchanterBlock;
import plus.dragons.createenchantmentindustry.content.contraptions.enchanting.enchanter.Enchanting;
import plus.dragons.createenchantmentindustry.content.contraptions.enchanting.enchanter.EnchantingGuideMenu;
import plus.dragons.createenchantmentindustry.content.contraptions.enchanting.enchanter.EnchantingItemHandler;
import plus.dragons.createenchantmentindustry.content.contraptions.enchanting.enchanter.EnchantmentEntry;
import plus.dragons.createenchantmentindustry.content.contraptions.fluids.FilteringFluidTankBehaviour;
import plus.dragons.createenchantmentindustry.content.contraptions.fluids.experience.ExperienceFluid;
import plus.dragons.createenchantmentindustry.content.contraptions.fluids.experience.HyperExperienceFluid;
import plus.dragons.createenchantmentindustry.entry.CeiContainerTypes;
import plus.dragons.createenchantmentindustry.entry.CeiFluids;
import plus.dragons.createenchantmentindustry.entry.CeiItems;
import plus.dragons.createenchantmentindustry.entry.CeiTags;
import plus.dragons.createenchantmentindustry.foundation.advancement.CeiAdvancements;
import plus.dragons.createenchantmentindustry.foundation.config.CeiConfigs;

public class BlazeEnchanterBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation,
MenuProvider {
    public static final int ENCHANTING_TIME = 200;
    SmartFluidTankBehaviour internalTank;
    TransportedItemStack heldItem;
    ItemStack targetItem = new ItemStack((ItemLike)CeiItems.ENCHANTING_GUIDE.get());
    int processingTicks;
    Map<Direction, LazyOptional<EnchantingItemHandler>> itemHandlers;
    boolean sendParticles;
    LerpedFloat headAnimation;
    LerpedFloat headAngle;
    Random random = new Random();
    float flip;
    float oFlip;
    float flipT;
    float flipA;
    public boolean goggles;
    protected static int ENCHANT_PARTICLE_COUNT = 20;

    public BlazeEnchanterBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.itemHandlers = new IdentityHashMap<Direction, LazyOptional<EnchantingItemHandler>>();
        for (Direction d : Iterate.horizontalDirections) {
            EnchantingItemHandler enchantingItemHandler = new EnchantingItemHandler(this, d);
            this.itemHandlers.put(d, (LazyOptional<EnchantingItemHandler>)LazyOptional.of(() -> enchantingItemHandler));
        }
        this.headAnimation = LerpedFloat.linear();
        this.headAngle = LerpedFloat.angular();
        this.headAngle.startWithValue((double)((AngleHelper.horizontalAngle((Direction)state.m_61145_((Property)BlazeEnchanterBlock.f_54117_).orElse(Direction.SOUTH)) + 180.0f) % 360.0f));
        this.goggles = false;
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        behaviours.add((BlockEntityBehaviour)new DirectBeltInputBehaviour((SmartBlockEntity)this).allowingBeltFunnels().setInsertionHandler(this::tryInsertingFromSide));
        this.internalTank = FilteringFluidTankBehaviour.single(fluidStack -> fluidStack.getFluid().m_205067_(CeiTags.FluidTag.BLAZE_ENCHANTER_INPUT.tag), this, (Integer)CeiConfigs.SERVER.blazeEnchanterTankCapacity.get()).whenFluidUpdates(() -> {
            Fluid fluid = this.internalTank.getPrimaryHandler().getFluid().getFluid();
            if (CeiFluids.EXPERIENCE.is((Object)fluid)) {
                this.updateHeatLevel(BlazeEnchanterBlock.HeatLevel.KINDLED);
            } else if (CeiFluids.HYPER_EXPERIENCE.is((Object)fluid)) {
                this.updateHeatLevel(BlazeEnchanterBlock.HeatLevel.SEETHING);
            } else {
                this.updateHeatLevel(BlazeEnchanterBlock.HeatLevel.SMOULDERING);
            }
        });
        behaviours.add((BlockEntityBehaviour)this.internalTank);
        this.registerAwardables(behaviours, new CreateAdvancement[]{CeiAdvancements.FIRST_ORDER.asCreateAdvancement(), CeiAdvancements.ADDITIONAL_ORDER.asCreateAdvancement(), CeiAdvancements.HYPOTHETICAL_EXTENSION.asCreateAdvancement()});
    }

    public void tick() {
        boolean onClient;
        super.tick();
        boolean bl = onClient = this.f_58857_.f_46443_ && !this.isVirtual();
        if (onClient) {
            this.bookTick();
            this.blazeTick();
        }
        if (this.heldItem == null) {
            this.processingTicks = 0;
            return;
        }
        if (this.processingTicks > 0) {
            boolean wasAtBeginning;
            this.heldItem.prevBeltPosition = 0.5f;
            boolean bl2 = wasAtBeginning = this.processingTicks == 200;
            if (!onClient || this.processingTicks < 200) {
                --this.processingTicks;
            }
            if (!this.continueProcessing()) {
                this.processingTicks = 0;
                this.notifyUpdate();
                return;
            }
            if (wasAtBeginning != (this.processingTicks == 200)) {
                this.sendData();
            }
            return;
        }
        this.heldItem.prevBeltPosition = this.heldItem.beltPosition;
        this.heldItem.prevSideOffset = this.heldItem.sideOffset;
        this.heldItem.beltPosition += this.itemMovementPerTick();
        if (this.heldItem.beltPosition > 1.0f) {
            BlockPos nextPosition;
            DirectBeltInputBehaviour directBeltInputBehaviour;
            this.heldItem.beltPosition = 1.0f;
            if (onClient) {
                return;
            }
            Direction side = this.heldItem.insertedFrom;
            ItemStack tryExportingToBeltFunnel = ((DirectBeltInputBehaviour)this.getBehaviour(DirectBeltInputBehaviour.TYPE)).tryExportingToBeltFunnel(this.heldItem.stack, side.m_122424_(), false);
            if (tryExportingToBeltFunnel != null) {
                if (tryExportingToBeltFunnel.m_41613_() != this.heldItem.stack.m_41613_()) {
                    if (tryExportingToBeltFunnel.m_41619_()) {
                        this.heldItem = null;
                    } else {
                        this.heldItem.stack = tryExportingToBeltFunnel;
                    }
                    this.notifyUpdate();
                    return;
                }
                if (!tryExportingToBeltFunnel.m_41619_()) {
                    return;
                }
            }
            if ((directBeltInputBehaviour = (DirectBeltInputBehaviour)BlockEntityBehaviour.get((BlockGetter)this.f_58857_, (BlockPos)(nextPosition = this.f_58858_.m_121945_(side)), (BehaviourType)DirectBeltInputBehaviour.TYPE)) == null) {
                if (!BlockHelper.hasBlockSolidSide((BlockState)this.f_58857_.m_8055_(nextPosition), (BlockGetter)this.f_58857_, (BlockPos)nextPosition, (Direction)side.m_122424_())) {
                    ItemStack ejected = this.heldItem.stack;
                    Vec3 outPos = VecHelper.getCenterOf((Vec3i)this.f_58858_).m_82549_(Vec3.m_82528_((Vec3i)side.m_122436_()).m_82490_(0.75));
                    float movementSpeed = this.itemMovementPerTick();
                    Vec3 outMotion = Vec3.m_82528_((Vec3i)side.m_122436_()).m_82490_((double)movementSpeed).m_82520_(0.0, 0.125, 0.0);
                    outPos.m_82549_(outMotion.m_82541_());
                    ItemEntity entity = new ItemEntity(this.f_58857_, outPos.f_82479_, outPos.f_82480_ + 0.375, outPos.f_82481_, ejected);
                    entity.m_20256_(outMotion);
                    entity.m_32060_();
                    entity.f_19864_ = true;
                    this.f_58857_.m_7967_((Entity)entity);
                    this.heldItem = null;
                    this.notifyUpdate();
                }
                return;
            }
            if (!directBeltInputBehaviour.canInsertFromSide(side)) {
                return;
            }
            ItemStack returned = directBeltInputBehaviour.handleInsertion(this.heldItem.copy(), side, false);
            if (returned.m_41619_()) {
                this.heldItem = null;
                this.notifyUpdate();
                return;
            }
            if (returned.m_41613_() != this.heldItem.stack.m_41613_()) {
                this.heldItem.stack = returned;
                this.notifyUpdate();
                return;
            }
            return;
        }
        if (this.heldItem.prevBeltPosition < 0.5f && this.heldItem.beltPosition >= 0.5f) {
            if (Enchanting.getValidEnchantment(this.heldItem.stack, this.targetItem, this.hyper()) == null) {
                return;
            }
            this.heldItem.beltPosition = 0.5f;
            if (onClient) {
                return;
            }
            this.processingTicks = 200;
            this.sendData();
        }
    }

    protected void blazeTick() {
        boolean active;
        boolean bl = active = this.processingTicks > 0;
        if (!active) {
            float target = 0.0f;
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player != null && !player.m_20145_()) {
                double z;
                double x;
                if (this.isVirtual()) {
                    x = -4.0;
                    z = -10.0;
                } else {
                    x = player.m_20185_();
                    z = player.m_20189_();
                }
                double dx = x - ((double)this.m_58899_().m_123341_() + 0.5);
                double dz = z - ((double)this.m_58899_().m_123343_() + 0.5);
                target = AngleHelper.deg((double)(-Mth.m_14136_((double)dz, (double)dx))) - 90.0f;
            }
            target = this.headAngle.getValue() + AngleHelper.getShortestAngleDiff((double)this.headAngle.getValue(), (double)target);
            this.headAngle.chase((double)target, 0.25, LerpedFloat.Chaser.exp((double)5.0));
            this.headAngle.tickChaser();
        } else {
            this.headAngle.chase((double)((AngleHelper.horizontalAngle((Direction)this.m_58900_().m_61145_((Property)BlazeEnchanterBlock.f_54117_).orElse(Direction.SOUTH)) + 180.0f) % 360.0f), 0.125, LerpedFloat.Chaser.EXP);
            this.headAngle.tickChaser();
        }
        this.headAnimation.chase(1.0, 0.25, LerpedFloat.Chaser.exp((double)0.25));
        this.headAnimation.tickChaser();
        this.spawnBlazeParticles();
    }

    protected void bookTick() {
        if (this.random.nextInt(40) == 0) {
            float oFlipT = this.flipT;
            while (oFlipT == this.flipT) {
                this.flipT += (float)(this.random.nextInt(4) - this.random.nextInt(4));
            }
        }
        this.oFlip = this.flip;
        float flipDiff = (this.flipT - this.flip) * 0.4f;
        flipDiff = Mth.m_14036_((float)flipDiff, (float)-0.2f, (float)0.2f);
        this.flipA += (flipDiff - this.flipA) * 0.9f;
        this.flip += this.flipA;
    }

    protected void spawnBlazeParticles() {
        if (this.f_58857_ == null) {
            return;
        }
        BlazeEnchanterBlock.HeatLevel heatLevel = (BlazeEnchanterBlock.HeatLevel)((Object)this.m_58900_().m_61143_(BlazeEnchanterBlock.HEAT_LEVEL));
        RandomSource r = this.f_58857_.f_46441_;
        Vec3 c = VecHelper.getCenterOf((Vec3i)this.f_58858_);
        Vec3 v = c.m_82549_(VecHelper.offsetRandomly((Vec3)Vec3.f_82478_, (RandomSource)r, (float)0.125f).m_82542_(1.0, 0.0, 1.0));
        if (r.m_188503_(3) == 0) {
            this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123755_, v.f_82479_, v.f_82480_, v.f_82481_, 0.0, 0.0, 0.0);
        }
        if (r.m_188503_(2) != 0) {
            return;
        }
        boolean empty = this.f_58857_.m_8055_(this.f_58858_.m_7494_()).m_60812_((BlockGetter)this.f_58857_, this.f_58858_.m_7494_()).m_83281_();
        double yMotion = empty ? 0.0625 : r.m_188500_() * (double)0.0125f;
        Vec3 v2 = c.m_82549_(VecHelper.offsetRandomly((Vec3)Vec3.f_82478_, (RandomSource)r, (float)0.5f).m_82542_(1.0, 0.25, 1.0).m_82541_().m_82490_((empty ? 0.25 : 0.5) + r.m_188500_() * 0.125)).m_82520_(0.0, 0.5, 0.0);
        if (heatLevel.isAtLeast(BlazeEnchanterBlock.HeatLevel.SEETHING)) {
            this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123745_, v2.f_82479_, v2.f_82480_, v2.f_82481_, 0.0, yMotion, 0.0);
        } else if (heatLevel.isAtLeast(BlazeEnchanterBlock.HeatLevel.KINDLED)) {
            this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123744_, v2.f_82479_, v2.f_82480_, v2.f_82481_, 0.0, yMotion, 0.0);
        }
    }

    protected void spawnEnchantParticles() {
        if (this.isVirtual()) {
            return;
        }
        Vec3 vec = VecHelper.getCenterOf((Vec3i)this.f_58858_);
        vec = vec.m_82520_(0.0, 1.0, 0.0);
        SimpleParticleType particle = ParticleTypes.f_123809_;
        for (int i = 0; i < ENCHANT_PARTICLE_COUNT; ++i) {
            Vec3 m = VecHelper.offsetRandomly((Vec3)Vec3.f_82478_, (RandomSource)this.f_58857_.f_46441_, (float)1.0f);
            m = new Vec3(m.f_82479_, Math.abs(m.f_82480_), m.f_82481_);
            this.f_58857_.m_7107_((ParticleOptions)particle, vec.f_82479_, vec.f_82480_, vec.f_82481_, m.f_82479_, m.f_82480_, m.f_82481_);
        }
        this.f_58857_.m_7785_(vec.f_82479_, vec.f_82480_, vec.f_82481_, SoundEvents.f_11887_, SoundSource.BLOCKS, 1.0f, this.f_58857_.f_46441_.m_188501_() * 0.1f + 0.9f, true);
    }

    protected boolean continueProcessing() {
        if (this.f_58857_.f_46443_ && !this.isVirtual()) {
            if (this.processingTicks > 0 && this.processingTicks < 200 && this.f_58857_.m_46467_() % 80L == 0L) {
                ((ClientLevel)this.f_58857_).m_104677_(this.f_58858_, SoundEvents.f_11737_, SoundSource.BLOCKS, 1.0f, 1.0f, true);
            }
            return true;
        }
        if (this.processingTicks < 5) {
            return true;
        }
        boolean hyper = this.hyper();
        EnchantmentEntry entry = Enchanting.getValidEnchantment(this.heldItem.stack, this.targetItem, hyper);
        if (entry == null) {
            return false;
        }
        FluidStack exp = new FluidStack(hyper ? ((HyperExperienceFluid)((Object)CeiFluids.HYPER_EXPERIENCE.get())).m_5613_() : ((ExperienceFluid)((Object)CeiFluids.EXPERIENCE.get())).m_5613_(), (int)((double)Enchanting.getExperienceConsumption((Enchantment)entry.getFirst(), (Integer)entry.getSecond()) * (hyper ? (Double)CeiConfigs.SERVER.hyperEnchantByBlazeEnchanterCostCoefficient.get() : (Double)CeiConfigs.SERVER.enchantByBlazeEnchanterCostCoefficient.get())));
        if (this.processingTicks > 5) {
            Fluid tankFluid = this.internalTank.getPrimaryHandler().getFluid().getFluid();
            if (!CeiFluids.EXPERIENCE.is((Object)tankFluid) && !CeiFluids.HYPER_EXPERIENCE.is((Object)tankFluid) || this.internalTank.getPrimaryHandler().getFluidAmount() < exp.getAmount()) {
                this.processingTicks = 200;
            }
            return true;
        }
        if (EnchantmentHelper.m_44831_((ItemStack)this.heldItem.stack).isEmpty()) {
            this.award(CeiAdvancements.FIRST_ORDER.asCreateAdvancement());
        } else {
            this.award(CeiAdvancements.ADDITIONAL_ORDER.asCreateAdvancement());
        }
        if (hyper) {
            this.award(CeiAdvancements.HYPOTHETICAL_EXTENSION.asCreateAdvancement());
        }
        Enchanting.enchantItem(this.heldItem.stack, entry);
        this.internalTank.getPrimaryHandler().getFluid().shrink(exp.getAmount());
        this.sendParticles = true;
        this.notifyUpdate();
        return true;
    }

    private float itemMovementPerTick() {
        return 0.125f;
    }

    public void setTargetItem(ItemStack itemStack) {
        this.targetItem = itemStack;
    }

    private ItemStack tryInsertingFromSide(TransportedItemStack transportedStack, Direction side, boolean simulate) {
        ItemStack inserted = transportedStack.stack;
        ItemStack returned = ItemStack.f_41583_;
        if (!this.getHeldItemStack().m_41619_()) {
            return inserted;
        }
        if (inserted.m_41613_() > 1 && Enchanting.getValidEnchantment(inserted, this.targetItem, this.hyper()) != null) {
            returned = ItemHandlerHelper.copyStackWithSize((ItemStack)inserted, (int)(inserted.m_41613_() - 1));
            inserted = ItemHandlerHelper.copyStackWithSize((ItemStack)inserted, (int)1);
        }
        if (simulate) {
            return returned;
        }
        transportedStack = transportedStack.copy();
        transportedStack.stack = inserted.m_41777_();
        transportedStack.beltPosition = side.m_122434_().m_122478_() ? 0.5f : 0.0f;
        transportedStack.prevSideOffset = transportedStack.sideOffset;
        transportedStack.prevBeltPosition = transportedStack.beltPosition;
        this.setHeldItem(transportedStack, side);
        this.m_6596_();
        this.sendData();
        return returned;
    }

    public ItemStack getHeldItemStack() {
        return this.heldItem == null ? ItemStack.f_41583_ : this.heldItem.stack;
    }

    public void setHeldItem(TransportedItemStack heldItem, Direction insertedFrom) {
        this.heldItem = heldItem;
        this.heldItem.insertedFrom = insertedFrom;
    }

    public void invalidate() {
        super.invalidate();
        for (LazyOptional<EnchantingItemHandler> lazyOptional : this.itemHandlers.values()) {
            lazyOptional.invalidate();
        }
    }

    public ItemRequirement getRequiredItems(BlockState state) {
        return new ItemRequirement(ItemRequirement.ItemUseType.CONSUME, this.targetItem);
    }

    public void destroy() {
        super.destroy();
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ItemStack heldItemStack = this.getHeldItemStack();
            BlockPos pos = this.m_58899_();
            if (!heldItemStack.m_41619_()) {
                Containers.m_18992_((Level)this.f_58857_, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)heldItemStack);
            }
            Containers.m_18992_((Level)this.f_58857_, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)this.targetItem);
            SmartFluidTank tank = this.internalTank.getPrimaryHandler();
            FluidStack fluidStack = tank.getFluid();
            Fluid fluid = fluidStack.getFluid();
            if (fluid instanceof ExperienceFluid) {
                ExperienceFluid expFluid = (ExperienceFluid)fluid;
                expFluid.drop(serverLevel, VecHelper.getCenterOf((Vec3i)pos), fluidStack.getAmount());
            }
        }
    }

    public boolean hyper() {
        return CeiFluids.HYPER_EXPERIENCE.is((Object)this.internalTank.getPrimaryHandler().getFluid().getFluid());
    }

    public void write(CompoundTag compoundTag, boolean clientPacket) {
        super.write(compoundTag, clientPacket);
        compoundTag.m_128405_("ProcessingTicks", this.processingTicks);
        compoundTag.m_128365_("TargetItem", (Tag)this.targetItem.serializeNBT());
        compoundTag.m_128379_("Goggles", this.goggles);
        if (this.heldItem != null) {
            compoundTag.m_128365_("HeldItem", (Tag)this.heldItem.serializeNBT());
        }
        if (this.sendParticles && clientPacket) {
            compoundTag.m_128379_("SpawnParticles", true);
            this.sendParticles = false;
        }
    }

    public void writeSafe(CompoundTag tag) {
        super.writeSafe(tag);
        tag.m_128365_("TargetItem", (Tag)new ItemStack((ItemLike)CeiItems.ENCHANTING_GUIDE.get()).serializeNBT());
        tag.m_128379_("Goggles", this.goggles);
    }

    protected void read(CompoundTag compoundTag, boolean clientPacket) {
        super.read(compoundTag, clientPacket);
        this.heldItem = null;
        this.processingTicks = compoundTag.m_128451_("ProcessingTicks");
        this.targetItem = ItemStack.m_41712_((CompoundTag)compoundTag.m_128469_("TargetItem"));
        this.goggles = compoundTag.m_128471_("Goggles");
        if (compoundTag.m_128441_("HeldItem")) {
            this.heldItem = TransportedItemStack.read((CompoundTag)compoundTag.m_128469_("HeldItem"));
        }
        if (!clientPacket) {
            return;
        }
        if (compoundTag.m_128441_("SpawnParticles")) {
            this.spawnEnchantParticles();
        }
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction side) {
        if (side != null && side.m_122434_().m_122479_() && this.isItemHandlerCap(capability)) {
            return this.itemHandlers.get(side).cast();
        }
        if ((side == Direction.DOWN || side == null) && this.isFluidHandlerCap(capability)) {
            return this.internalTank.getCapability().cast();
        }
        return super.getCapability(capability, side);
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        EnchantmentEntry entry;
        EnchantmentIndustry.LANG.translate("gui.goggles.blaze_enchanter", new Object[0]).forGoggles(tooltip);
        if (this.targetItem != null && this.targetItem.m_150930_((Item)CeiItems.ENCHANTING_GUIDE.get()) && (entry = Enchanting.getTargetEnchantment(this.targetItem, this.hyper())) != null) {
            tooltip.add((Component)Component.m_237113_((String)"     ").m_7220_(((Enchantment)entry.getFirst()).m_44700_(((Integer)entry.getSecond()).intValue())));
            if (!entry.valid()) {
                tooltip.add((Component)Component.m_237113_((String)"     ").m_7220_((Component)EnchantmentIndustry.LANG.translate("gui.goggles.blaze_enchanter.invalid_target", new Object[0]).component()).m_130940_(ChatFormatting.RED));
            } else {
                int consumption = (int)((double)Enchanting.getExperienceConsumption((Enchantment)entry.getFirst(), (Integer)entry.getSecond()) * (this.hyper() ? (Double)CeiConfigs.SERVER.hyperEnchantByBlazeEnchanterCostCoefficient.get() : (Double)CeiConfigs.SERVER.enchantByBlazeEnchanterCostCoefficient.get()));
                if (consumption > (Integer)CeiConfigs.SERVER.blazeEnchanterTankCapacity.get()) {
                    tooltip.add((Component)Component.m_237113_((String)"     ").m_7220_((Component)EnchantmentIndustry.LANG.translate("gui.goggles.too_expensive", new Object[0]).component()).m_130940_(ChatFormatting.RED));
                } else {
                    tooltip.add((Component)Component.m_237113_((String)"     ").m_7220_((Component)EnchantmentIndustry.LANG.translate("gui.goggles.xp_consumption", new Object[]{consumption}).component()).m_130940_(ChatFormatting.GREEN));
                }
            }
        }
        this.containedFluidTooltip(tooltip, isPlayerSneaking, this.getCapability(ForgeCapabilities.FLUID_HANDLER));
        return true;
    }

    public void updateHeatLevel(BlazeEnchanterBlock.HeatLevel heatLevel) {
        if (this.f_58857_ != null) {
            this.f_58857_.m_46597_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_(BlazeEnchanterBlock.HEAT_LEVEL, (Comparable)((Object)heatLevel)));
        }
    }

    public Component m_5446_() {
        return this.targetItem.m_41611_();
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return new EnchantingGuideMenu((MenuType)CeiContainerTypes.ENCHANTING_GUIDE_FOR_BLAZE.get(), pContainerId, pPlayerInventory, this.targetItem, this.m_58899_());
    }
}

