/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createenchantmentindustry;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import plus.dragons.createdragonlib.advancement.AdvancementFactory;
import plus.dragons.createdragonlib.init.SafeRegistrate;
import plus.dragons.createdragonlib.lang.Lang;
import plus.dragons.createdragonlib.lang.LangFactory;
import plus.dragons.createdragonlib.tag.TagGen;
import plus.dragons.createenchantmentindustry.EnchantmentIndustryClient;
import plus.dragons.createenchantmentindustry.compat.apotheosis.ApotheosisCompat;
import plus.dragons.createenchantmentindustry.compat.quark.QuarkCompat;
import plus.dragons.createenchantmentindustry.content.contraptions.fluids.OpenEndedPipeEffects;
import plus.dragons.createenchantmentindustry.entry.CeiBlockEntities;
import plus.dragons.createenchantmentindustry.entry.CeiBlocks;
import plus.dragons.createenchantmentindustry.entry.CeiContainerTypes;
import plus.dragons.createenchantmentindustry.entry.CeiCreativeModeTab;
import plus.dragons.createenchantmentindustry.entry.CeiEntityTypes;
import plus.dragons.createenchantmentindustry.entry.CeiFluids;
import plus.dragons.createenchantmentindustry.entry.CeiItems;
import plus.dragons.createenchantmentindustry.entry.CeiPackets;
import plus.dragons.createenchantmentindustry.entry.CeiRecipeTypes;
import plus.dragons.createenchantmentindustry.entry.CeiTags;
import plus.dragons.createenchantmentindustry.foundation.advancement.CeiAdvancements;
import plus.dragons.createenchantmentindustry.foundation.config.CeiConfigs;
import plus.dragons.createenchantmentindustry.foundation.ponder.content.CeiPonderIndex;

@Mod(value="create_enchantment_industry")
public class EnchantmentIndustry {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final String NAME = "Create: Enchantment Industry";
    public static final String ID = "create_enchantment_industry";
    public static final SafeRegistrate REGISTRATE = new SafeRegistrate("create_enchantment_industry");
    public static final Lang LANG = new Lang("create_enchantment_industry");
    public static final AdvancementFactory ADVANCEMENT_FACTORY = AdvancementFactory.create((String)"Create: Enchantment Industry", (String)"create_enchantment_industry", CeiAdvancements::register);
    private static final LangFactory LANG_FACTORY = LangFactory.create((String)"Create: Enchantment Industry", (String)"create_enchantment_industry").advancements(CeiAdvancements::register).ponders(() -> {
        CeiPonderIndex.register();
        CeiPonderIndex.registerTags();
    }).tooltips().ui();
    private static CreativeModeTab CREATIVE_MODE_TAB;

    public EnchantmentIndustry() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        IEventBus forgeEventBus = MinecraftForge.EVENT_BUS;
        CeiConfigs.register(ModLoadingContext.get());
        this.registerEntries(modEventBus);
        modEventBus.register((Object)this);
        modEventBus.addListener(EventPriority.LOWEST, arg_0 -> ((AdvancementFactory)ADVANCEMENT_FACTORY).datagen(arg_0));
        modEventBus.addListener(EventPriority.LOWEST, arg_0 -> ((LangFactory)LANG_FACTORY).datagen(arg_0));
        this.registerForgeEvents(forgeEventBus);
        new TagGen.Builder(REGISTRATE).addItemTagFactory(CeiTags::genItemTag).addFluidTagFactory(CeiTags::genFluidTag).build().activate();
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> EnchantmentIndustryClient::new);
    }

    private void registerEntries(IEventBus modEventBus) {
        CeiBlocks.register();
        CeiBlockEntities.register();
        CeiContainerTypes.register();
        CeiEntityTypes.register();
        CeiFluids.register();
        CeiItems.register();
        CeiRecipeTypes.register(modEventBus);
        CeiTags.register();
        CREATIVE_MODE_TAB = new CeiCreativeModeTab();
        REGISTRATE.registerEventListeners(modEventBus);
    }

    private void registerForgeEvents(IEventBus forgeEventBus) {
        forgeEventBus.addListener(CeiFluids::handleInkEffect);
    }

    @SubscribeEvent
    public void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            CeiAdvancements.register();
            CeiPackets.registerPackets();
            CeiFluids.registerLavaReaction();
            OpenEndedPipeEffects.register();
            ApotheosisCompat.addPotionMixingRecipes();
            ApotheosisCompat.banTomeFromEnchanter();
            QuarkCompat.registerPrintEntry();
        });
    }

    public static ResourceLocation genRL(String name) {
        return new ResourceLocation(ID, name);
    }
}

