/*
 * Decompiled with CFR 0.152.
 */
package com.cyvack.create_crystal_clear.data_gen;

import com.cyvack.create_crystal_clear.CrystalClear;
import com.cyvack.create_crystal_clear.content.blocks.GlassCasing;
import com.cyvack.create_crystal_clear.content.blocks.GlassEncasedCogwheel;
import com.cyvack.create_crystal_clear.content.blocks.GlassEncasedShaft;
import com.cyvack.create_crystal_clear.index.CCSpriteShifts;
import com.cyvack.create_crystal_clear.index.GlassCTBehaviours.GlassEncasedCTBehaviour;
import com.cyvack.create_crystal_clear.index.GlassCTBehaviours.GlassEncasedCogCTBehaviour;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllTags;
import com.simibubi.create.Create;
import com.simibubi.create.content.decoration.encasing.CasingConnectivity;
import com.simibubi.create.content.decoration.encasing.EncasingRegistry;
import com.simibubi.create.content.kinetics.BlockStressDefaults;
import com.simibubi.create.content.kinetics.base.RotatedPillarKineticBlock;
import com.simibubi.create.foundation.block.connected.CTSpriteShiftEntry;
import com.simibubi.create.foundation.block.connected.ConnectedTextureBehaviour;
import com.simibubi.create.foundation.block.connected.SimpleCTBehaviour;
import com.simibubi.create.foundation.data.BlockStateGen;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.simibubi.create.foundation.data.TagGen;
import com.simibubi.create.foundation.utility.Couple;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateBlockstateProvider;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.nullness.NonNullFunction;
import com.tterrag.registrate.util.nullness.NonNullUnaryOperator;
import java.util.function.Supplier;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import org.jetbrains.annotations.NotNull;

public class BlockBuilders {
    private static final CreateRegistrate REGISTRATE = CrystalClear.registrate();

    @NotNull
    private static BlockBehaviour.Properties glassProperties(BlockBehaviour.Properties p) {
        return p.m_60922_(BlockBuilders::never).m_60924_(BlockBuilders::never).m_60960_(BlockBuilders::never).m_60971_(BlockBuilders::never);
    }

    private static boolean never(BlockState p_235436_0_, BlockGetter p_235436_1_, BlockPos p_235436_2_) {
        return false;
    }

    private static Boolean never(BlockState p_235427_0_, BlockGetter p_235427_1_, BlockPos p_235427_2_, EntityType<?> p_235427_3_) {
        return false;
    }

    public static BlockEntry<GlassCasing> glassCasing(String name, boolean clear) {
        String newName = !clear ? name + "_glass_casing" : name + "_clear_glass_casing";
        CTSpriteShiftEntry ctEntry = CCSpriteShifts.omni(newName);
        return ((BlockBuilder)((BlockBuilder)REGISTRATE.block(newName, GlassCasing::new).initialProperties(() -> Blocks.f_50058_).properties(p -> p.m_60918_(SoundType.f_56744_)).properties(BlockBehaviour.Properties::m_60955_).properties(BlockBuilders::glassProperties).addLayer(() -> RenderType::m_110463_).blockstate((c, p) -> p.simpleBlock((Block)c.get())).onRegister(CreateRegistrate.connectedTextures(() -> new SimpleCTBehaviour(ctEntry)))).tag(new TagKey[]{AllTags.AllBlockTags.CASING.tag}).item().tag(new TagKey[]{AllTags.AllItemTags.CASING.tag}).build()).register();
    }

    public static BlockEntry<GlassEncasedShaft> glassEncasedShaft(String casing, Boolean clear, NonNullFunction<BlockBehaviour.Properties, GlassEncasedShaft> factory) {
        String newName = casing + (clear == false ? "_glass_encased_shaft" : "_clear_glass_encased_shaft");
        return ((BlockBuilder)((BlockBuilder)((BlockBuilder)REGISTRATE.block(newName, factory).initialProperties(() -> Blocks.f_50058_).transform(BlockBuilders.glassEncasedShaftBuilder(casing, clear, () -> CCSpriteShifts.omni(casing + (clear == false ? "_glass_casing" : "_clear_glass_casing"))))).transform(TagGen.pickaxeOnly())).transform((NonNullFunction)EncasingRegistry.addVariantTo((Supplier)AllBlocks.SHAFT))).register();
    }

    private static <B extends GlassEncasedShaft, P> NonNullUnaryOperator<BlockBuilder<B, P>> glassEncasedShaftBuilder(String casing, boolean clear, Supplier<CTSpriteShiftEntry> ctEntry) {
        return builder -> (BlockBuilder)((BlockBuilder)((BlockBuilder)BlockBuilders.glassencasedBase(builder, () -> ((BlockEntry)AllBlocks.SHAFT).get()).addLayer(() -> RenderType::m_110463_).onRegister(CreateRegistrate.connectedTextures(() -> BlockBuilders.lambda$glassEncasedShaftBuilder$8((Supplier)ctEntry)))).onRegister(CreateRegistrate.casingConnectivity((arg_0, arg_1) -> BlockBuilders.lambda$glassEncasedShaftBuilder$10((Supplier)ctEntry, arg_0, arg_1)))).blockstate((ctx, prov) -> BlockStateGen.axisBlock((DataGenContext)ctx, (RegistrateBlockstateProvider)prov, state -> ((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(ctx.getName(), CrystalClear.asResource("block/glass_encased_shaft/block"))).texture("casing", CrystalClear.asResource("block/" + casing + (clear ? "_clear_glass" : "_glass") + "_casing"))).texture("opening", BlockBuilders.getOpening(casing)), (boolean)true)).item().model((ctx, prov) -> ((ItemModelBuilder)((ItemModelBuilder)prov.withExistingParent(ctx.getName(), CrystalClear.asResource("block/glass_encased_shaft/block"))).texture("casing", CrystalClear.asResource("block/" + casing + (clear ? "_clear_glass" : "_glass") + "_casing"))).texture("opening", BlockBuilders.getOpening(casing))).build();
    }

    public static BlockEntry<GlassEncasedCogwheel> glassEncasedCogwheel(String casingType, Boolean large, Boolean clear, NonNullFunction<BlockBehaviour.Properties, GlassEncasedCogwheel> factory) {
        Object name = clear != false ? casingType + "_clear" : casingType;
        return large == false ? ((BlockBuilder)((BlockBuilder)REGISTRATE.block((String)name + "_glass_encased_cogwheel", factory).transform(BlockBuilders.glassEncasedSmallCogwheel(casingType, clear, () -> BlockBuilders.lambda$glassEncasedCogwheel$15((String)name)))).onRegister(CreateRegistrate.connectedTextures(() -> BlockBuilders.lambda$glassEncasedCogwheel$16((String)name, casingType)))).register() : ((BlockBuilder)REGISTRATE.block((String)name + "_glass_encased_large_cogwheel", factory).transform(BlockBuilders.glassEncasedLargeCogwheel(casingType, clear, () -> BlockBuilders.lambda$glassEncasedCogwheel$17((String)name)))).register();
    }

    private static <B extends GlassEncasedCogwheel, P> NonNullUnaryOperator<BlockBuilder<B, P>> glassEncasedSmallCogwheel(String casing, Boolean clear, Supplier<CTSpriteShiftEntry> casingShift) {
        return b -> BlockBuilders.glassEncasedCogwheelBase(b, casing, clear, casingShift, () -> ((BlockEntry)AllBlocks.COGWHEEL).get(), false);
    }

    private static <B extends GlassEncasedCogwheel, P> NonNullUnaryOperator<BlockBuilder<B, P>> glassEncasedLargeCogwheel(String casing, Boolean clear, Supplier<CTSpriteShiftEntry> casingShift) {
        return b -> (BlockBuilder)BlockBuilders.glassEncasedCogwheelBase(b, casing, clear, casingShift, () -> ((BlockEntry)AllBlocks.COGWHEEL).get(), true).onRegister(CreateRegistrate.connectedTextures(() -> BlockBuilders.lambda$glassEncasedLargeCogwheel$19((Supplier)casingShift)));
    }

    private static <B extends GlassEncasedCogwheel, P> BlockBuilder<B, P> glassEncasedCogwheelBase(BlockBuilder<B, P> b, String casing, Boolean clear, Supplier<CTSpriteShiftEntry> casingShift, Supplier<ItemLike> drop, boolean large) {
        String name = clear != false ? casing + "_clear_glass" : casing + "_glass";
        String blockFolder = "encased_cogwheel";
        return (BlockBuilder)((BlockBuilder)((BlockBuilder)BlockBuilders.glassencasedBase(b, drop).transform((NonNullFunction)EncasingRegistry.addVariantTo((Supplier)(large ? AllBlocks.LARGE_COGWHEEL : AllBlocks.COGWHEEL)))).addLayer(() -> RenderType::m_110463_).initialProperties(() -> Blocks.f_50058_).onRegister(CreateRegistrate.casingConnectivity((block, cc) -> cc.make((Block)block, (CTSpriteShiftEntry)casingShift.get(), (state, f) -> state.m_60734_() instanceof GlassEncasedCogwheel && f.m_122434_() == state.m_61143_((Property)GlassEncasedCogwheel.AXIS) && (Boolean)state.m_61143_((Property)(f.m_122421_() == Direction.AxisDirection.POSITIVE ? GlassEncasedCogwheel.TOP_SHAFT : GlassEncasedCogwheel.BOTTOM_SHAFT)) == false)))).blockstate((c, p) -> BlockStateGen.axisBlock((DataGenContext)c, (RegistrateBlockstateProvider)p, blockState -> {
            String suffix = ((Boolean)blockState.m_61143_((Property)GlassEncasedCogwheel.TOP_SHAFT) != false ? "_top" : "") + ((Boolean)blockState.m_61143_((Property)GlassEncasedCogwheel.BOTTOM_SHAFT) != false ? "_bottom" : "");
            String modelName = c.getName() + suffix;
            return ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)p.models().withExistingParent(modelName, p.modLoc("block/" + blockFolder + "/block" + suffix))).texture("particle", CrystalClear.asResource("block/" + name + "_casing"))).texture("casing", CrystalClear.asResource("block/" + name + "_casing"))).texture("backing", BlockBuilders.getBacking(casing))).texture("opening", BlockBuilders.getOpening(casing))).texture("siding", BlockBuilders.getSiding(casing, large));
        }, (boolean)false)).item().model((c, p) -> ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)p.withExistingParent(c.getName(), p.modLoc("block/" + blockFolder + "/item"))).texture("casing", CrystalClear.asResource("block/" + name + "_casing"))).texture("backing", BlockBuilders.getBacking(casing))).texture("opening", BlockBuilders.getOpening(casing))).texture("siding", BlockBuilders.getSiding(casing, large))).build();
    }

    private static ResourceLocation getBacking(String casing) {
        ResourceLocation texture = casing.equals("andesite") ? new ResourceLocation("block/stripped_spruce_log_top") : (casing.equals("brass") ? new ResourceLocation("block/stripped_dark_oak_log_top") : CrystalClear.asResource("block/" + casing + "_backing"));
        return texture;
    }

    private static ResourceLocation getOpening(String casing) {
        ResourceLocation texture = casing.equals("andesite") ? Create.asResource((String)"block/gearbox") : (casing.equals("brass") ? Create.asResource((String)"block/brass_gearbox") : CrystalClear.asResource("block/" + casing + "_gearbox"));
        return texture;
    }

    private static ResourceLocation getSiding(String casing, boolean large) {
        ResourceLocation texture = CrystalClear.asResource("block/encased_cogwheels/" + (large ? "large_" : "") + casing + "_encased_cogwheel_side");
        return texture;
    }

    private static <B extends RotatedPillarKineticBlock, P> BlockBuilder<B, P> glassencasedBase(BlockBuilder<B, P> b, Supplier<ItemLike> drop) {
        return ((BlockBuilder)b.properties(BlockBehaviour.Properties::m_60955_).properties(BlockBuilders::glassProperties).transform((NonNullFunction)BlockStressDefaults.setNoImpact())).loot((p, lb) -> p.m_124147_((Block)lb, (ItemLike)drop.get()));
    }

    private static /* synthetic */ ConnectedTextureBehaviour lambda$glassEncasedLargeCogwheel$19(Supplier casingShift) {
        return new GlassEncasedCogCTBehaviour((CTSpriteShiftEntry)casingShift.get());
    }

    private static /* synthetic */ CTSpriteShiftEntry lambda$glassEncasedCogwheel$17(String name) {
        return CCSpriteShifts.omni(name + "_glass_casing");
    }

    private static /* synthetic */ ConnectedTextureBehaviour lambda$glassEncasedCogwheel$16(String name, String casingType) {
        return new GlassEncasedCogCTBehaviour(CCSpriteShifts.omni(name + "_glass_casing"), (Couple<CTSpriteShiftEntry>)Couple.create((Object)CCSpriteShifts.vertical("encased_cogwheels/" + casingType + "_encased_cogwheel_side"), (Object)CCSpriteShifts.horizontal("encased_cogwheels/" + casingType + "_encased_cogwheel_side")));
    }

    private static /* synthetic */ CTSpriteShiftEntry lambda$glassEncasedCogwheel$15(String name) {
        return CCSpriteShifts.omni(name + "_glass_casing");
    }

    private static /* synthetic */ void lambda$glassEncasedShaftBuilder$10(Supplier ctEntry, GlassEncasedShaft block, CasingConnectivity cc) {
        cc.make((Block)block, (CTSpriteShiftEntry)ctEntry.get(), (state, face) -> state.m_60734_() instanceof GlassEncasedShaft && face.m_122434_() != state.m_61143_((Property)GlassEncasedShaft.AXIS));
    }

    private static /* synthetic */ ConnectedTextureBehaviour lambda$glassEncasedShaftBuilder$8(Supplier ctEntry) {
        return new GlassEncasedCTBehaviour((CTSpriteShiftEntry)ctEntry.get());
    }
}

