/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createcentralkitchen.foundation.data.loot;

import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.logging.LogUtils;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.util.nullness.NonNullFunction;
import com.tterrag.registrate.util.nullness.NonNullUnaryOperator;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraftforge.data.loading.DatagenModLoader;
import org.slf4j.Logger;

public class BlockLootTables
implements DataProvider {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final Map<String, Map<ResourceLocation, Supplier<LootTable.Builder>>> BLOCK_LOOTS = new HashMap<String, Map<ResourceLocation, Supplier<LootTable.Builder>>>();
    private final DataGenerator generator;

    public BlockLootTables(DataGenerator generator) {
        this.generator = generator;
    }

    public void m_213708_(CachedOutput cache) {
        Path outputFolder = this.generator.m_123916_();
        BLOCK_LOOTS.forEach((modid, suppliers) -> {
            Path datapackFolder = outputFolder.resolve("datapacks/" + modid);
            HashMap map = Maps.newHashMap();
            suppliers.forEach((id, supplier) -> {
                if (map.put(id, ((LootTable.Builder)supplier.get()).m_79165_(LootContextParamSets.f_81421_).m_79167_()) != null) {
                    throw new IllegalStateException("Duplicate loot table " + id);
                }
            });
            ValidationContext validationContext = new ValidationContext(LootContextParamSets.f_81420_, id -> null, map::get);
            map.forEach((id, lootTable) -> LootTables.m_79202_((ValidationContext)validationContext, (ResourceLocation)id, (LootTable)lootTable));
            Multimap problems = validationContext.m_79352_();
            if (!problems.isEmpty()) {
                problems.forEach((key, value) -> LOGGER.warn("Found validation problem in {}: {}", key, value));
                throw new IllegalStateException("Failed to validate loot tables, see logs");
            }
            map.forEach((id, lootTable) -> {
                Path path = BlockLootTables.createPath(datapackFolder, id);
                try {
                    DataProvider.m_236072_((CachedOutput)cache, (JsonElement)LootTables.m_79200_((LootTable)lootTable), (Path)path);
                }
                catch (IOException ioexception) {
                    LOGGER.error("Couldn't save loot table {}", (Object)path, (Object)ioexception);
                }
            });
        });
    }

    private static Path createPath(Path path, ResourceLocation id) {
        return path.resolve("data/" + id.m_135827_() + "/loot_tables/" + id.m_135815_() + ".json");
    }

    public static <T extends Block, P> NonNullUnaryOperator<BlockBuilder<T, P>> add(String modId, NonNullFunction<T, LootTable.Builder> function) {
        Map map = BLOCK_LOOTS.computeIfAbsent(modId, it -> new HashMap());
        return builder -> (BlockBuilder)builder.properties(BlockLootTables::noLootGen).onRegister(block -> map.put(new ResourceLocation(builder.getOwner().getModid(), "blocks/" + builder.getName()), () -> (LootTable.Builder)function.apply(block)));
    }

    public static BlockBehaviour.Properties noLootGen(BlockBehaviour.Properties properties) {
        if (DatagenModLoader.isRunningDataGen()) {
            properties.m_222994_();
        }
        return properties;
    }

    public String m_6055_() {
        return "LootTables";
    }
}

