/*
 * Decompiled with CFR 0.152.
 */
package org.antarcticgardens.newage.content.electricity.connector;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.antarcticgardens.newage.NewAgeRenderTypes;
import org.antarcticgardens.newage.config.NewAgeConfig;
import org.antarcticgardens.newage.content.electricity.connector.ElectricalConnectorBlockEntity;
import org.antarcticgardens.newage.content.electricity.wire.ElectricWireItem;
import org.antarcticgardens.newage.content.electricity.wire.WireType;
import org.antarcticgardens.newage.tools.ConversionTool;
import org.antarcticgardens.newage.tools.RaycastUtil;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class ElectricalConnectorRenderer
implements BlockEntityRenderer<ElectricalConnectorBlockEntity> {
    public static final float SAG_FACTOR = 0.92f;
    public static final int[] TOO_LONG1 = new int[]{150, 0, 0, 255};
    public static final int[] TOO_LONG2 = new int[]{204, 0, 0, 255};

    public ElectricalConnectorRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(ElectricalConnectorBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        Item to;
        VertexConsumer consumer = buffer.m_6299_(NewAgeRenderTypes.WIRE);
        BlockPos pos = blockEntity.m_58899_();
        Vector3f from = new Vector3f(0.0f);
        for (Map.Entry<BlockPos, WireType> e : blockEntity.getConnectorPositions().entrySet()) {
            if (e.getKey().hashCode() > blockEntity.m_58899_().hashCode()) continue;
            poseStack.m_85836_();
            poseStack.m_85837_(0.5, 0.5, 0.5);
            org.joml.Matrix4f pose = ConversionTool.toJoml(poseStack.m_85850_().m_85861_());
            to = new Vector3f((float)(e.getKey().m_123341_() - pos.m_123341_()), (float)(e.getKey().m_123342_() - pos.m_123342_()), (float)(e.getKey().m_123343_() - pos.m_123343_()));
            this.renderWire(consumer, pose, from, (Vector3f)to, blockEntity, e.getValue().getColor1(), e.getValue().getColor2());
            poseStack.m_85849_();
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null && Minecraft.m_91087_().f_91066_.m_92176_().m_90612_()) {
            ElectricWireItem wire;
            BlockPos bound;
            ItemStack itemInHand = player.m_21205_();
            if (!(itemInHand.m_41720_() instanceof ElectricWireItem)) {
                itemInHand = player.m_21206_();
            }
            if ((to = itemInHand.m_41720_()) instanceof ElectricWireItem && (bound = (wire = (ElectricWireItem)to).getBoundConnector(itemInHand)) != null && bound.equals((Object)blockEntity.m_58899_())) {
                int maxDistance;
                Vec3 eyePos = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
                Vec3 endPos = eyePos.m_82549_(player.m_20252_(partialTick).m_82541_().m_82490_(2.0));
                HitResult hit = RaycastUtil.pickBlockFromPos(blockEntity.m_58904_(), eyePos, player.m_20252_(partialTick), Minecraft.m_91087_().f_91072_.m_105286_());
                if (hit instanceof BlockHitResult) {
                    BlockHitResult blockHit = (BlockHitResult)hit;
                    Vec3 vec = eyePos.m_82549_(blockHit.m_82450_().m_82546_(eyePos).m_82490_((double)0.9f));
                    if (eyePos.m_82554_(endPos) > eyePos.m_82554_(vec)) {
                        endPos = vec;
                    }
                }
                Vector3f to2 = new Vector3f((float)(endPos.f_82479_ - (double)pos.m_123341_() - 0.5), (float)(endPos.f_82480_ - (double)pos.m_123342_() - 0.5), (float)(endPos.f_82481_ - (double)pos.m_123343_() - 0.5));
                double distance = endPos.m_82531_((double)bound.m_123341_() + 0.5, (double)bound.m_123342_() + 0.5, (double)bound.m_123343_() + 0.5);
                if (distance > (double)Mth.m_144944_((int)((maxDistance = ((Integer)NewAgeConfig.getCommon().maxWireLength.get()).intValue()) * 2))) {
                    return;
                }
                int[] color1 = wire.getWireType().getColor1();
                int[] color2 = wire.getWireType().getColor2();
                if (Minecraft.m_91087_().f_91072_ != null && hit instanceof BlockHitResult) {
                    BlockHitResult blockHit = (BlockHitResult)hit;
                    BlockEntity blockEntity2 = blockEntity.m_58904_().m_7702_(blockHit.m_82425_());
                    if (blockEntity2 instanceof ElectricalConnectorBlockEntity) {
                        ElectricalConnectorBlockEntity connector = (ElectricalConnectorBlockEntity)blockEntity2;
                        if (connector.isConnected(blockEntity.m_58899_())) {
                            return;
                        }
                        to2 = new Vector3f((float)(blockHit.m_82425_().m_123341_() - pos.m_123341_()), (float)(blockHit.m_82425_().m_123342_() - pos.m_123342_()), (float)(blockHit.m_82425_().m_123343_() - pos.m_123343_()));
                        distance = connector.m_58899_().m_123331_((Vec3i)blockEntity.m_58899_());
                    }
                }
                if (distance >= (double)Mth.m_144944_((int)maxDistance)) {
                    color1 = TOO_LONG1;
                    color2 = TOO_LONG2;
                }
                poseStack.m_85836_();
                poseStack.m_85837_(0.5, 0.5, 0.5);
                org.joml.Matrix4f pose = ConversionTool.toJoml(poseStack.m_85850_().m_85861_());
                this.renderWire(consumer, pose, to2, from, blockEntity, color1, color2);
                poseStack.m_85849_();
            }
        }
    }

    private void renderWire(VertexConsumer consumer, org.joml.Matrix4f pose, Vector3f from, Vector3f to, ElectricalConnectorBlockEntity blockEntity, int[] color1, int[] color2) {
        Vector3f lastSection = from;
        Vector3f direction = new Vector3f((Vector3fc)to).sub((Vector3fc)from).normalize();
        float distance = to.distance((Vector3fc)from);
        int sections = (int)Math.ceil(distance * (float)((Integer)NewAgeConfig.getClient().wireSectionsPerMeter.get()).intValue());
        float perSection = distance / (float)sections;
        for (int i = 0; i <= sections; ++i) {
            int[] color = i % 2 == 0 ? color1 : color2;
            Vector3f sectionTo = new Vector3f((Vector3fc)direction).mul(perSection * (float)i).add(0.0f, this.catenary(i, distance, sections), 0.0f);
            this.wireSection(consumer, pose, lastSection, sectionTo.add((Vector3fc)from), color, this.calculateLighting(blockEntity, lastSection, sectionTo));
            lastSection = sectionTo;
        }
    }

    public boolean shouldRenderOffScreen(ElectricalConnectorBlockEntity blockEntity) {
        return true;
    }

    private int calculateLighting(BlockEntity entity, Vector3f pos, Vector3f pos1) {
        BlockPos blockPos = new BlockPos((Vec3i)entity.m_58899_()).m_7918_(Math.round(pos.x), Math.round(pos.y), Math.round(pos.z));
        BlockPos blockPos1 = new BlockPos((Vec3i)entity.m_58899_()).m_7918_(Math.round(pos1.x), Math.round(pos1.y), Math.round(pos1.z));
        int sky = entity.m_58904_().m_45517_(LightLayer.SKY, blockPos);
        int block = entity.m_58904_().m_45517_(LightLayer.BLOCK, blockPos);
        int sky1 = entity.m_58904_().m_45517_(LightLayer.SKY, blockPos1);
        int block1 = entity.m_58904_().m_45517_(LightLayer.BLOCK, blockPos1);
        return LightTexture.m_109885_((int)Math.max(block, block1), (int)Math.max(sky, sky1));
    }

    private float catenary(double x, double length, int sections) {
        double a = length / (double)((Integer)NewAgeConfig.getCommon().maxWireLength.get()).intValue() * (double)0.92f;
        x = x / (double)sections * 2.0 - 1.0;
        return (float)((Math.cosh(x) - Math.cosh(1.0)) * a);
    }

    private void wireSection(VertexConsumer consumer, org.joml.Matrix4f pose, Vector3f from, Vector3f to, int[] color, int light) {
        Vector3f up;
        Vector3f direction = new Vector3f((Vector3fc)to).sub((Vector3fc)from).normalize();
        if (this.isVertical(direction, up = new Vector3f(0.0f, 1.0f, 0.0f))) {
            up = new Vector3f(1.0f, 0.0f, 0.0f);
        }
        pose = new org.joml.Matrix4f((Matrix4fc)pose).translate((Vector3fc)from).rotateTowards((Vector3fc)direction, (Vector3fc)up);
        Matrix4f mojangPose = ConversionTool.toMojang(pose);
        int r = color[0];
        int g = color[1];
        int b = color[2];
        int z = color[3];
        float f = ((Double)NewAgeConfig.getClient().wireThickness.get()).floatValue() / 2.0f;
        float distance = from.distance((Vector3fc)to);
        consumer.m_85982_(mojangPose, -f, -f, 0.0f).m_6122_(r, g, b, z).m_85969_(light).m_5752_();
        consumer.m_85982_(mojangPose, -f, -f, distance).m_6122_(r, g, b, z).m_85969_(light).m_5752_();
        consumer.m_85982_(mojangPose, f, f, distance).m_6122_(r, g, b, z).m_85969_(light).m_5752_();
        consumer.m_85982_(mojangPose, f, f, 0.0f).m_6122_(r, g, b, z).m_85969_(light).m_5752_();
        consumer.m_85982_(mojangPose, f, -f, 0.0f).m_6122_(r, g, b, z).m_85969_(light).m_5752_();
        consumer.m_85982_(mojangPose, f, -f, distance).m_6122_(r, g, b, z).m_85969_(light).m_5752_();
        consumer.m_85982_(mojangPose, -f, f, distance).m_6122_(r, g, b, z).m_85969_(light).m_5752_();
        consumer.m_85982_(mojangPose, -f, f, 0.0f).m_6122_(r, g, b, z).m_85969_(light).m_5752_();
    }

    private boolean isVertical(Vector3f vec, Vector3f up) {
        return vec.equals((Object)up) || vec.equals((Object)up.mul(-1.0f));
    }
}

