/*
 * Decompiled with CFR 0.152.
 */
package terrails.xnetgases.module.logic;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import mcjty.lib.varia.JSonTools;
import mcjty.rftoolsbase.api.xnet.channels.Color;
import mcjty.rftoolsbase.api.xnet.gui.IEditorGui;
import mcjty.rftoolsbase.api.xnet.helper.BaseStringTranslators;
import mekanism.api.chemical.Chemical;
import mekanism.common.registries.MekanismBlocks;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import terrails.xnetgases.module.chemical.ChemicalEnums;
import terrails.xnetgases.module.chemical.utils.ChemicalHelper;
import terrails.xnetgases.module.logic.ChemicalLogicConnectorSettings;
import terrails.xnetgases.module.logic.ChemicalLogicEnums;

public class ChemicalSensor {
    public final String modeTag;
    public final String operatorTag;
    public final String amountTag;
    public final String colorTag;
    public final String filterTag;
    private int amount = 0;
    private ChemicalLogicEnums.SensorMode sensorMode = ChemicalLogicEnums.SensorMode.OFF;
    private Color outputColor = Color.OFF;
    private ChemicalLogicEnums.SensorOperator operator = ChemicalLogicEnums.SensorOperator.EQUAL;
    private ItemStack filter = ItemStack.f_41583_;

    public ChemicalSensor(int index) {
        String temp = String.format("sensor%s_", index);
        this.modeTag = temp + "mode";
        this.operatorTag = temp + "operator";
        this.amountTag = temp + "amount";
        this.colorTag = temp + "color";
        this.filterTag = temp + "filter";
    }

    public Color getOutputColor() {
        return this.outputColor;
    }

    public boolean isEnabled(String tag) {
        if (this.modeTag.equals(tag)) {
            return true;
        }
        if (this.operatorTag.equals(tag)) {
            return true;
        }
        if (this.amountTag.equals(tag)) {
            return true;
        }
        if (this.colorTag.equals(tag)) {
            return true;
        }
        if (this.filterTag.equals(tag)) {
            return this.sensorMode != ChemicalLogicEnums.SensorMode.OFF;
        }
        return false;
    }

    public void createGui(IEditorGui gui) {
        gui.choices(this.modeTag, "Sensor mode", (Enum)this.sensorMode, (Enum[])ChemicalLogicEnums.SensorMode.values()).choices(this.operatorTag, "Operator", (Enum)this.operator, (Enum[])ChemicalLogicEnums.SensorOperator.values()).integer(this.amountTag, "Amount to compare with", Integer.valueOf(this.amount), 46).colors(this.colorTag, "Output color", Integer.valueOf(this.outputColor.getColor()), Color.COLORS).ghostSlot(this.filterTag, this.filter).nl();
    }

    public boolean test(@Nullable BlockEntity be, ChemicalLogicConnectorSettings settings) {
        ChemicalEnums.Type type = this.sensorMode.toType();
        if (type == null || !this.filter.m_150930_(MekanismBlocks.CREATIVE_CHEMICAL_TANK.m_5456_())) {
            return false;
        }
        return switch (this.sensorMode) {
            case ChemicalLogicEnums.SensorMode.GAS, ChemicalLogicEnums.SensorMode.SLURRY, ChemicalLogicEnums.SensorMode.PIGMENT, ChemicalLogicEnums.SensorMode.INFUSE -> ChemicalHelper.handler((ICapabilityProvider)be, settings.getFacing(), type).map(handler -> ChemicalHelper.handler((ICapabilityProvider)this.filter, null, type).map(filterHandler -> {
                if (filterHandler.getTanks() <= 0) {
                    return false;
                }
                Chemical chemical = filterHandler.getChemicalInTank(0).getType();
                return this.operator.match(ChemicalHelper.amountInTank(handler, settings.getFacing(), chemical, type), this.amount);
            }).orElse(this.filter.m_41619_() && this.operator.match(ChemicalHelper.amountInTank(handler, settings.getFacing(), type), this.amount))).orElse(false);
            default -> false;
        };
    }

    public void update(Map<String, Object> data) {
        this.sensorMode = this.getObjectFromMap(data, this.modeTag, ChemicalLogicEnums.SensorMode.OFF, object -> ChemicalLogicEnums.SensorMode.valueOf(((String)object).toUpperCase()));
        this.operator = this.getObjectFromMap(data, this.operatorTag, ChemicalLogicEnums.SensorOperator.EQUAL, object -> ChemicalLogicEnums.SensorOperator.byCode(((String)object).toUpperCase()));
        this.amount = this.getObjectFromMap(data, this.amountTag, 0, Integer.class::cast);
        this.outputColor = this.getObjectFromMap(data, this.colorTag, Color.OFF, object -> Color.colorByValue((int)((Integer)object)));
        this.filter = ChemicalHelper.normalizeStack(this.getObjectFromMap(data, this.filterTag, ItemStack.f_41583_, ItemStack.class::cast), this.sensorMode.toType());
    }

    private <T> T getObjectFromMap(Map<String, Object> data, String key, T defaultValue, Function<Object, T> function) {
        Object object = data.get(key);
        if (object != null) {
            return function.apply(object);
        }
        return defaultValue;
    }

    public void readFromNBT(CompoundTag tag) {
        this.sensorMode = ChemicalLogicEnums.SensorMode.values()[tag.m_128445_(this.modeTag)];
        this.operator = ChemicalLogicEnums.SensorOperator.values()[tag.m_128445_(this.operatorTag)];
        this.amount = tag.m_128451_(this.amountTag);
        this.outputColor = Color.values()[tag.m_128445_(this.colorTag)];
        if (tag.m_128441_(this.filterTag)) {
            CompoundTag itemTag = tag.m_128469_(this.filterTag);
            this.filter = ChemicalHelper.normalizeStack(ItemStack.m_41712_((CompoundTag)itemTag), this.sensorMode.toType());
        } else {
            this.filter = ItemStack.f_41583_;
        }
    }

    public void writeToNBT(CompoundTag tag) {
        tag.m_128344_(this.modeTag, (byte)this.sensorMode.ordinal());
        tag.m_128344_(this.operatorTag, (byte)this.operator.ordinal());
        tag.m_128405_(this.amountTag, this.amount);
        tag.m_128344_(this.colorTag, (byte)this.outputColor.ordinal());
        if (!this.filter.m_41619_()) {
            CompoundTag itemTag = new CompoundTag();
            this.filter.m_41739_(itemTag);
            tag.m_128365_(this.filterTag, (Tag)itemTag);
        }
    }

    public void writeToJson(JsonObject json) {
        json.add(this.modeTag, (JsonElement)new JsonPrimitive(this.sensorMode.name()));
        json.add(this.colorTag, (JsonElement)new JsonPrimitive(this.outputColor.name()));
        json.add(this.operatorTag, (JsonElement)new JsonPrimitive(this.operator.name()));
        json.add(this.amountTag, (JsonElement)new JsonPrimitive((Number)this.amount));
        if (!this.filter.m_41619_()) {
            json.add(this.filterTag, (JsonElement)JSonTools.itemStackToJson((ItemStack)this.filter));
        }
    }

    public void readFromJson(JsonObject json) {
        this.amount = json.has(this.amountTag) ? json.get(this.amountTag).getAsInt() : 0;
        this.operator = json.has(this.operatorTag) ? ChemicalLogicEnums.SensorOperator.byName(json.get(this.operatorTag).getAsString()) : ChemicalLogicEnums.SensorOperator.EQUAL;
        this.outputColor = json.has(this.colorTag) ? BaseStringTranslators.getColor((String)json.get(this.colorTag).getAsString()) : Color.OFF;
        this.sensorMode = json.has(this.modeTag) ? ChemicalLogicEnums.SensorMode.byName(json.get(this.modeTag).getAsString()) : ChemicalLogicEnums.SensorMode.OFF;
        this.filter = json.has(this.filterTag) ? ChemicalHelper.normalizeStack(JSonTools.jsonToItemStack((JsonObject)json.get(this.filterTag).getAsJsonObject()), this.sensorMode.toType()) : ItemStack.f_41583_;
    }
}

