/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.multiblock;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.LevelTools;
import mcjty.lib.worlddata.AbstractWorldData;
import mcjty.rftoolsbase.api.xnet.channels.IChannelType;
import mcjty.rftoolsbase.api.xnet.keys.NetworkId;
import mcjty.xnet.XNet;
import mcjty.xnet.multiblock.WirelessChannelKey;
import mcjty.xnet.multiblock.WorldBlob;
import mcjty.xnet.multiblock.XNetBlobData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;

public class XNetWirelessChannels
extends AbstractWorldData<XNetWirelessChannels> {
    private static final String NAME = "XNetWirelessChannels";
    private final Map<WirelessChannelKey, WirelessChannelInfo> channelToWireless = new HashMap<WirelessChannelKey, WirelessChannelInfo>();
    private int globalChannelVersion = 1;

    public XNetWirelessChannels() {
    }

    public XNetWirelessChannels(CompoundTag tag) {
        this.channelToWireless.clear();
        ListTag tagList = tag.m_128437_("channels", 10);
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundTag tc = tagList.m_128728_(i);
            WirelessChannelInfo channelInfo = new WirelessChannelInfo();
            this.readRouters(tc.m_128437_("routers", 10), channelInfo);
            UUID owner = null;
            if (tc.m_128403_("owner")) {
                owner = tc.m_128342_("owner");
            }
            String name = tc.m_128461_("name");
            IChannelType type = XNet.xNetApi.findType(tc.m_128461_("type"));
            this.channelToWireless.put(new WirelessChannelKey(name, type, owner), channelInfo);
        }
    }

    public void transmitChannel(String channel, @Nonnull IChannelType channelType, @Nullable UUID ownerUUID, ResourceKey<Level> dimension, BlockPos wirelessRouterPos, NetworkId network) {
        WirelessChannelInfo channelInfo;
        WirelessChannelKey key = new WirelessChannelKey(channel, channelType, ownerUUID);
        if (this.channelToWireless.containsKey(key)) {
            channelInfo = this.channelToWireless.get(key);
        } else {
            channelInfo = new WirelessChannelInfo();
            this.channelToWireless.put(key, channelInfo);
        }
        GlobalPos pos = GlobalPos.m_122643_(dimension, (BlockPos)wirelessRouterPos);
        WirelessRouterInfo info = channelInfo.getRouter(pos);
        if (info == null) {
            info = new WirelessRouterInfo(pos);
            channelInfo.updateRouterInfo(pos, info);
            this.updateGlobalChannelVersion();
        }
        info.setAge(0);
        info.setNetworkId(network);
        this.save();
    }

    public void updateGlobalChannelVersion() {
        ++this.globalChannelVersion;
    }

    public int getGlobalChannelVersion() {
        return this.globalChannelVersion;
    }

    private void dump() {
        for (Map.Entry<WirelessChannelKey, WirelessChannelInfo> entry : this.channelToWireless.entrySet()) {
            System.out.println("Channel = " + entry.getKey());
            WirelessChannelInfo channelInfo = entry.getValue();
            for (Map.Entry<GlobalPos, WirelessRouterInfo> infoEntry : channelInfo.getRouters().entrySet()) {
                GlobalPos pos = infoEntry.getKey();
                WirelessRouterInfo info = infoEntry.getValue();
                System.out.println("    Pos = " + BlockPosTools.toString((BlockPos)pos.m_122646_()) + " (age " + info.age + ", net " + info.networkId.id() + ")");
            }
        }
    }

    public void tick(Level world, int amount) {
        if (this.channelToWireless.isEmpty()) {
            return;
        }
        XNetBlobData blobData = XNetBlobData.get(world);
        HashSet<WirelessChannelKey> toDeleteChannel = new HashSet<WirelessChannelKey>();
        for (Map.Entry<WirelessChannelKey, WirelessChannelInfo> entry : this.channelToWireless.entrySet()) {
            WirelessChannelInfo channelInfo = entry.getValue();
            HashSet<GlobalPos> toDelete = new HashSet<GlobalPos>();
            for (Map.Entry<GlobalPos, WirelessRouterInfo> infoEntry : channelInfo.getRouters().entrySet()) {
                WirelessRouterInfo info = infoEntry.getValue();
                int age = info.getAge();
                info.setAge(age += amount);
                if (age <= 40) continue;
                toDelete.add(infoEntry.getKey());
            }
            for (GlobalPos pos : toDelete) {
                WorldBlob worldBlob = blobData.getWorldBlob((ResourceKey<Level>)pos.m_122640_());
                NetworkId networkId = channelInfo.getRouter(pos).getNetworkId();
                worldBlob.markNetworkDirty(networkId);
                channelInfo.removeRouterInfo(pos);
                XNetWirelessChannels.get(world).updateGlobalChannelVersion();
            }
            if (!channelInfo.getRouters().isEmpty()) continue;
            toDeleteChannel.add(entry.getKey());
        }
        if (!toDeleteChannel.isEmpty()) {
            for (WirelessChannelKey key : toDeleteChannel) {
                this.channelToWireless.remove(key);
            }
        }
        this.save();
    }

    @Nonnull
    public static XNetWirelessChannels get(Level world) {
        return (XNetWirelessChannels)XNetWirelessChannels.getData((Level)world, XNetWirelessChannels::new, XNetWirelessChannels::new, (String)NAME);
    }

    public WirelessChannelInfo findChannel(String name, @Nonnull IChannelType channelType, @Nullable UUID owner) {
        WirelessChannelKey key = new WirelessChannelKey(name, channelType, owner);
        return this.findChannel(key);
    }

    public WirelessChannelInfo findChannel(WirelessChannelKey key) {
        return this.channelToWireless.get(key);
    }

    public void forEachChannel(@Nullable UUID owner, Consumer<WirelessChannelInfo> consumer) {
        this.channelToWireless.forEach((key, info) -> {
            if (owner == null && key.owner() == null || owner != null && (key.owner() == null || owner.equals(key.owner()))) {
                consumer.accept((WirelessChannelInfo)info);
            }
        });
    }

    private void readRouters(ListTag tagList, WirelessChannelInfo channelInfo) {
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundTag tc = tagList.m_128728_(i);
            ResourceKey dim = LevelTools.getId((String)tc.m_128461_("dim"));
            GlobalPos pos = GlobalPos.m_122643_((ResourceKey)dim, (BlockPos)new BlockPos(tc.m_128451_("x"), tc.m_128451_("y"), tc.m_128451_("z")));
            WirelessRouterInfo info = new WirelessRouterInfo(pos);
            info.setAge(tc.m_128451_("age"));
            info.setNetworkId(new NetworkId(tc.m_128451_("network")));
            channelInfo.updateRouterInfo(pos, info);
        }
    }

    @Nonnull
    public CompoundTag m_7176_(@Nonnull CompoundTag compound) {
        ListTag channelTagList = new ListTag();
        for (Map.Entry<WirelessChannelKey, WirelessChannelInfo> entry : this.channelToWireless.entrySet()) {
            CompoundTag channelTc = new CompoundTag();
            WirelessChannelInfo channelInfo = entry.getValue();
            WirelessChannelKey key = entry.getKey();
            channelTc.m_128359_("name", key.name());
            channelTc.m_128359_("type", key.channelType().getID());
            if (key.owner() != null) {
                channelTc.m_128362_("owner", key.owner());
            }
            channelTc.m_128365_("routers", (Tag)this.writeRouters(channelInfo));
            channelTagList.add((Object)channelTc);
        }
        compound.m_128365_("channels", (Tag)channelTagList);
        return compound;
    }

    private ListTag writeRouters(WirelessChannelInfo channelInfo) {
        ListTag tagList = new ListTag();
        for (Map.Entry<GlobalPos, WirelessRouterInfo> infoEntry : channelInfo.getRouters().entrySet()) {
            CompoundTag tc = new CompoundTag();
            GlobalPos pos = infoEntry.getKey();
            tc.m_128359_("dim", pos.m_122640_().m_135782_().toString());
            tc.m_128405_("x", pos.m_122646_().m_123341_());
            tc.m_128405_("y", pos.m_122646_().m_123342_());
            tc.m_128405_("z", pos.m_122646_().m_123343_());
            WirelessRouterInfo info = infoEntry.getValue();
            tc.m_128405_("age", info.getAge());
            tc.m_128405_("network", info.getNetworkId().id());
            tagList.add((Object)tc);
        }
        return tagList;
    }

    public static class WirelessChannelInfo {
        private final Map<GlobalPos, WirelessRouterInfo> routers = new HashMap<GlobalPos, WirelessRouterInfo>();

        public void updateRouterInfo(GlobalPos pos, WirelessRouterInfo info) {
            this.routers.put(pos, info);
        }

        public void removeRouterInfo(GlobalPos pos) {
            this.routers.remove(pos);
        }

        public WirelessRouterInfo getRouter(GlobalPos pos) {
            return this.routers.get(pos);
        }

        public Map<GlobalPos, WirelessRouterInfo> getRouters() {
            return this.routers;
        }
    }

    public static class WirelessRouterInfo {
        private int age = 0;
        private NetworkId networkId;
        private final GlobalPos coordinate;

        public WirelessRouterInfo(GlobalPos coordinate) {
            this.coordinate = coordinate;
        }

        public NetworkId getNetworkId() {
            return this.networkId;
        }

        public void setNetworkId(NetworkId networkId) {
            this.networkId = networkId;
        }

        public int getAge() {
            return this.age;
        }

        public void setAge(int age) {
            this.age = age;
        }

        public GlobalPos getCoordinate() {
            return this.coordinate;
        }
    }
}

