/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_core.common.world;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.MobSpawnSettingsBuilder;
import net.minecraftforge.common.world.ModifiableBiomeInfo;
import net.valhelsia.valhelsia_core.core.init.ValhelsiaBiomeModifiers;

public record AddNetherSpawnsBiomeModifier(HolderSet<Biome> biomes, Optional<MobCategory> category, List<MobSpawnSettings.SpawnerData> spawners, double charge, double energyBudget) implements BiomeModifier
{
    public static final Codec<AddNetherSpawnsBiomeModifier> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Biome.f_47432_.fieldOf("biomes").forGetter(modifier -> modifier.biomes), (App)MobCategory.f_21584_.optionalFieldOf("category").forGetter(modifier -> modifier.category), (App)new ExtraCodecs.EitherCodec(MobSpawnSettings.SpawnerData.f_48403_.listOf(), MobSpawnSettings.SpawnerData.f_48403_).xmap(either -> (List)either.map(Function.identity(), List::of), list -> list.size() == 1 ? Either.right((Object)((MobSpawnSettings.SpawnerData)list.get(0))) : Either.left((Object)list)).fieldOf("spawners").forGetter(modifier -> modifier.spawners), (App)Codec.DOUBLE.fieldOf("charge").forGetter(modifier -> modifier.charge), (App)Codec.DOUBLE.fieldOf("energyBudget").forGetter(modifier -> modifier.energyBudget)).apply((Applicative)instance, AddNetherSpawnsBiomeModifier::new));

    public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        if (phase == BiomeModifier.Phase.ADD && this.biomes.m_203333_(biome)) {
            MobSpawnSettingsBuilder spawns = builder.getMobSpawnSettings();
            for (MobSpawnSettings.SpawnerData spawner : this.spawners) {
                EntityType type = spawner.f_48404_;
                spawns.m_48376_(this.category.orElseGet(() -> ((EntityType)type).m_20674_()), spawner);
                spawns.m_48370_(type, this.charge, this.energyBudget);
            }
        }
    }

    public Codec<? extends BiomeModifier> codec() {
        return (Codec)ValhelsiaBiomeModifiers.ADD_NETHER_SPAWNS.get();
    }
}

