/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_core.common.network;

import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.valhelsia.valhelsia_core.common.capability.counter.CounterProvider;
import net.valhelsia.valhelsia_core.common.capability.counter.SimpleCounter;

public record UpdateCounterPacket(SimpleCounter timer) {
    public static void encode(UpdateCounterPacket packet, FriendlyByteBuf buffer) {
        CompoundTag compound = packet.timer.save(new CompoundTag());
        compound.m_128359_("name", packet.timer.getName().toString());
        buffer.m_130079_(compound);
    }

    public static UpdateCounterPacket decode(FriendlyByteBuf buffer) {
        CompoundTag compound = buffer.m_130260_();
        SimpleCounter timer = new SimpleCounter(new ResourceLocation(Objects.requireNonNull(compound).m_128461_("name")));
        timer.load(compound);
        return new UpdateCounterPacket(timer);
    }

    public static void consume(UpdateCounterPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            assert (((NetworkEvent.Context)ctx.get()).getDirection() == NetworkDirection.PLAY_TO_CLIENT);
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player != null) {
                player.getCapability(CounterProvider.CAPABILITY).ifPresent(counterCapability -> counterCapability.getCounter(packet.timer.getName()).load(packet.timer.save(new CompoundTag())));
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

