/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_core.client.cosmetics.elytra;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.world.entity.LivingEntity;
import net.valhelsia.valhelsia_core.client.cosmetics.CosmeticKey;
import net.valhelsia.valhelsia_core.client.cosmetics.CosmeticType;
import net.valhelsia.valhelsia_core.client.cosmetics.CosmeticsCategory;
import net.valhelsia.valhelsia_core.client.cosmetics.CosmeticsManager;

public interface ElytraModifier {
    public static <T extends ElytraModifier> Optional<Pair<CosmeticKey, T>> getModifier(LivingEntity entity, Function<ElytraModifier, Boolean> function) {
        CosmeticsManager cosmeticsManager = CosmeticsManager.getInstance();
        UUID uuid = entity.m_20148_();
        List<CosmeticKey> cosmetics = cosmeticsManager.getCosmetics(uuid, CosmeticsCategory.BACK);
        Optional<CosmeticKey> key = cosmeticsManager.getActiveCosmetic(uuid, CosmeticsCategory.BACK);
        if (key.isEmpty() || !cosmetics.contains(key.get())) {
            return Optional.empty();
        }
        Optional type = key.flatMap(cosmeticsManager::getType);
        if (type.isEmpty()) {
            return Optional.empty();
        }
        Optional<ElytraModifier> modifier = ((CosmeticType)type.get()).elytraModifier();
        if (modifier.isEmpty() || !function.apply(modifier.get()).booleanValue()) {
            return Optional.empty();
        }
        return Optional.of(Pair.of((Object)key.get(), (Object)modifier.get()));
    }
}

