/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.renderer;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.util.RandomSource;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TFSkyRenderer {
    private static VertexBuffer starBuffer;

    public TFSkyRenderer() {
        this.createStars();
    }

    public static boolean renderSky(ClientLevel level, int ticks, float partialTicks, PoseStack ms, Camera camera, Matrix4f projectionMatrix, boolean isFoggy, Runnable setupFog) {
        LevelRenderer levelRenderer = Minecraft.m_91087_().f_91060_;
        RenderSystem.m_69472_();
        Vec3 vec3 = level.m_171660_(camera.m_90583_(), partialTicks);
        float f = (float)vec3.m_7096_();
        float f1 = (float)vec3.m_7098_();
        float f2 = (float)vec3.m_7094_();
        FogRenderer.m_109036_();
        RenderSystem.m_69458_((boolean)false);
        RenderSystem.m_157429_((float)f, (float)f1, (float)f2, (float)1.0f);
        ShaderInstance shaderinstance = RenderSystem.m_157196_();
        levelRenderer.f_109472_.m_85921_();
        levelRenderer.f_109472_.m_166867_(ms.m_85850_().m_85861_(), RenderSystem.m_157192_(), shaderinstance);
        VertexBuffer.m_85931_();
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        ms.m_85836_();
        float f11 = 1.0f - level.m_46722_(partialTicks);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)f11);
        ms.m_85845_(Vector3f.f_122225_.m_122240_(-90.0f));
        ms.m_85845_(Vector3f.f_122223_.m_122240_(level.m_46942_(partialTicks) * 360.0f));
        float f10 = 1.0f;
        RenderSystem.m_157429_((float)f10, (float)f10, (float)f10, (float)f10);
        starBuffer.m_85921_();
        starBuffer.m_166867_(ms.m_85850_().m_85861_(), RenderSystem.m_157192_(), shaderinstance);
        VertexBuffer.m_85931_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69461_();
        ms.m_85849_();
        RenderSystem.m_157429_((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        double d0 = camera.m_90592_().m_20299_(partialTicks).m_7098_() + (double)(level.m_5736_() - 10);
        if (d0 < 0.0) {
            ms.m_85836_();
            ms.m_85837_(0.0, 12.0, 0.0);
            levelRenderer.f_109473_.m_85921_();
            levelRenderer.f_109473_.m_166867_(ms.m_85850_().m_85861_(), RenderSystem.m_157192_(), shaderinstance);
            VertexBuffer.m_85931_();
            ms.m_85849_();
        }
        if (level.m_104583_().m_108882_()) {
            RenderSystem.m_157429_((float)(f * 0.2f + 0.04f), (float)(f1 * 0.2f + 0.04f), (float)(f2 * 0.6f + 0.1f), (float)1.0f);
        } else {
            RenderSystem.m_157429_((float)f, (float)f1, (float)f2, (float)1.0f);
        }
        RenderSystem.m_69493_();
        RenderSystem.m_69458_((boolean)true);
        return true;
    }

    private void createStars() {
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        RenderSystem.m_157427_(GameRenderer::m_172808_);
        if (starBuffer != null) {
            starBuffer.close();
        }
        starBuffer = new VertexBuffer();
        BufferBuilder.RenderedBuffer renderedBuffer = this.drawStars(bufferbuilder);
        starBuffer.m_85921_();
        starBuffer.m_231221_(renderedBuffer);
        VertexBuffer.m_85931_();
    }

    private BufferBuilder.RenderedBuffer drawStars(BufferBuilder bufferBuilder) {
        RandomSource random = RandomSource.m_216335_((long)10842L);
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85814_);
        for (int i = 0; i < 3000; ++i) {
            double d0 = random.m_188501_() * 2.0f - 1.0f;
            double d1 = random.m_188501_() * 2.0f - 1.0f;
            double d2 = random.m_188501_() * 2.0f - 1.0f;
            double d3 = 0.15f + random.m_188501_() * 0.1f;
            double d4 = d0 * d0 + d1 * d1 + d2 * d2;
            if (!(d4 < 1.0) || !(d4 > 0.01)) continue;
            d4 = 1.0 / Math.sqrt(d4);
            double d5 = (d0 *= d4) * 100.0;
            double d6 = (d1 *= d4) * 100.0;
            double d7 = (d2 *= d4) * 100.0;
            double d8 = Math.atan2(d0, d2);
            double d9 = Math.sin(d8);
            double d10 = Math.cos(d8);
            double d11 = Math.atan2(Math.sqrt(d0 * d0 + d2 * d2), d1);
            double d12 = Math.sin(d11);
            double d13 = Math.cos(d11);
            double d14 = random.m_188500_() * Math.PI * 2.0;
            double d15 = Math.sin(d14);
            double d16 = Math.cos(d14);
            for (int j = 0; j < 4; ++j) {
                double d18 = (double)((j & 2) - 1) * d3;
                double d19 = (double)((j + 1 & 2) - 1) * d3;
                double d21 = d18 * d16 - d19 * d15;
                double d22 = d19 * d16 + d18 * d15;
                double d23 = d21 * d12 + 0.0 * d13;
                double d24 = 0.0 * d12 - d21 * d13;
                double d25 = d24 * d9 - d22 * d10;
                double d26 = d22 * d9 + d24 * d10;
                bufferBuilder.m_5483_(d5 + d25, d6 + d23, d7 + d26).m_5752_();
            }
        }
        return bufferBuilder.m_231175_();
    }
}

