/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block.entity;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import twilightforest.block.TomeSpawnerBlock;
import twilightforest.init.TFBlockEntities;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFEntities;

public class TomeSpawnerBlockEntity
extends BlockEntity {
    private int elapsedTime;
    private String entityType;
    private int tomesLeft;
    private int spawnTime;
    private int playerDistance;

    public TomeSpawnerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TFBlockEntities.TOME_SPAWNER.get(), pos, state);
        if (((Boolean)state.m_61143_((Property)TomeSpawnerBlock.SPAWNER)).booleanValue()) {
            this.entityType = "twilightforest:death_tome";
            this.tomesLeft = 5;
            this.spawnTime = 400;
            this.playerDistance = 8;
        }
    }

    public static void tick(Level level, BlockPos pos, BlockState state, TomeSpawnerBlockEntity te) {
        if (!level.m_5776_() && level.m_46791_() != Difficulty.PEACEFUL) {
            if (te.tomesLeft > 10) {
                te.tomesLeft = 10;
            }
            if (te.isNearPlayer(level, pos)) {
                if (te.elapsedTime < te.spawnTime) {
                    ++te.elapsedTime;
                } else {
                    te.elapsedTime = 0;
                    te.attemptSpawnTome((ServerLevel)level, pos, false);
                }
            }
            if (te.tomesLeft <= 0) {
                te.invalidateCaps();
                level.m_46597_(pos, ((Block)TFBlocks.EMPTY_CANOPY_BOOKSHELF.get()).m_49966_());
            } else {
                level.m_46597_(pos, (BlockState)state.m_61124_((Property)TomeSpawnerBlock.BOOK_STAGES, (Comparable)Integer.valueOf(te.tomesLeft)));
            }
        }
    }

    public void attemptSpawnTome(ServerLevel level, BlockPos pos, boolean fire) {
        Optional mob = EntityType.m_20632_((String)this.entityType);
        boolean spawnedOne = false;
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            if (level.m_46859_(pos.m_121945_(dir))) {
                for (int i = 0; i < 5; ++i) {
                    double x = (double)pos.m_121945_(dir).m_123341_() + (level.m_213780_().m_188500_() - level.m_213780_().m_188500_()) * 2.0;
                    double y = (double)pos.m_123342_() + (level.m_213780_().m_188500_() - level.m_213780_().m_188500_());
                    double z = (double)pos.m_121945_(dir).m_123343_() + (level.m_213780_().m_188500_() - level.m_213780_().m_188500_()) * 2.0;
                    if (!level.m_45772_(mob.orElse((EntityType)TFEntities.DEATH_TOME.get()).m_20585_(x, y, z)) || !mob.isPresent()) continue;
                    Entity entity = mob.orElse((EntityType)TFEntities.DEATH_TOME.get()).m_20615_((Level)level);
                    entity.m_20035_(new BlockPos(x, y, z), entity.m_146908_(), entity.m_146909_());
                    if (fire) {
                        entity.m_20254_(10);
                    }
                    level.m_7967_(entity);
                    --this.tomesLeft;
                    spawnedOne = true;
                    break;
                }
            }
            if (!spawnedOne) continue;
            break;
        }
    }

    private boolean isNearPlayer(Level level, BlockPos pos) {
        return level.m_45914_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, (double)this.playerDistance);
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128359_("EntityType", this.entityType);
        tag.m_128405_("MobSpawnsLeft", this.tomesLeft);
        tag.m_128405_("SpawnDelay", this.spawnTime);
        tag.m_128405_("MaxPlayerDistance", this.playerDistance);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.entityType = tag.m_128461_("EntityType");
        this.tomesLeft = tag.m_128451_("MobSpawnsLeft");
        this.spawnTime = tag.m_128451_("SpawnDelay");
        this.playerDistance = tag.m_128451_("MaxPlayerDistance");
    }
}

