/*
 * Decompiled with CFR 0.152.
 */
package twilightforest;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundMapItemDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraftforge.network.NetworkDirection;
import org.jetbrains.annotations.Nullable;
import twilightforest.init.TFLandmark;
import twilightforest.network.MazeMapPacket;
import twilightforest.network.TFPacketHandler;
import twilightforest.util.LegacyLandmarkPlacements;
import twilightforest.world.registration.TFGenerationSettings;

public class TFMazeMapData
extends MapItemSavedData {
    private static final Map<String, TFMazeMapData> CLIENT_DATA = new HashMap<String, TFMazeMapData>();
    public int yCenter;

    public TFMazeMapData(int x, int z, byte scale, boolean trackpos, boolean unlimited, boolean locked, ResourceKey<Level> dim) {
        super(x, z, scale, trackpos, unlimited, locked, dim);
    }

    public static TFMazeMapData load(CompoundTag nbt) {
        MapItemSavedData data = MapItemSavedData.m_164807_((CompoundTag)nbt);
        boolean trackingPosition = !nbt.m_128425_("trackingPosition", 1) || nbt.m_128471_("trackingPosition");
        boolean unlimitedTracking = nbt.m_128471_("unlimitedTracking");
        boolean locked = nbt.m_128471_("locked");
        TFMazeMapData tfdata = new TFMazeMapData(data.f_77885_, data.f_77886_, data.f_77890_, trackingPosition, unlimitedTracking, locked, (ResourceKey<Level>)data.f_77887_);
        tfdata.f_77891_ = data.f_77891_;
        tfdata.f_77897_.putAll(data.f_77897_);
        tfdata.f_77894_.putAll(data.f_77894_);
        tfdata.f_77898_.putAll(data.f_77898_);
        tfdata.f_181308_ = data.f_181308_;
        tfdata.yCenter = nbt.m_128451_("yCenter");
        return tfdata;
    }

    public CompoundTag m_7176_(CompoundTag nbt) {
        CompoundTag ret = super.m_7176_(nbt);
        ret.m_128405_("yCenter", this.yCenter);
        return ret;
    }

    public void calculateMapCenter(Level world, int x, int y, int z) {
        this.yCenter = y;
        if (world instanceof ServerLevel && TFGenerationSettings.usesTwilightChunkGenerator((ServerLevel)world) && LegacyLandmarkPlacements.getFeatureForRegion(x >> 4, z >> 4, (WorldGenLevel)((ServerLevel)world)) == TFLandmark.LABYRINTH) {
            BlockPos mc = LegacyLandmarkPlacements.getNearestCenterXZ(x >> 4, z >> 4);
            this.f_77885_ = mc.m_123341_();
            this.f_77886_ = mc.m_123343_();
        }
    }

    @Nullable
    public static TFMazeMapData getMazeMapData(Level world, String name) {
        if (world.f_46443_) {
            return CLIENT_DATA.get(name);
        }
        return (TFMazeMapData)((ServerLevel)world).m_7654_().m_129783_().m_8895_().m_164858_(TFMazeMapData::load, name);
    }

    public static void registerMazeMapData(Level world, TFMazeMapData data, String id) {
        if (world.f_46443_) {
            CLIENT_DATA.put(id, data);
        } else {
            ((ServerLevel)world).m_7654_().m_129783_().m_8895_().m_164855_(id, (SavedData)data);
        }
    }

    @Nullable
    public Packet<?> m_164796_(int mapId, Player player) {
        Packet packet;
        Packet packet2 = super.m_164796_(mapId, player);
        if (packet2 instanceof ClientboundMapItemDataPacket) {
            ClientboundMapItemDataPacket mapItemDataPacket = (ClientboundMapItemDataPacket)packet2;
            packet = TFPacketHandler.CHANNEL.toVanillaPacket((Object)new MazeMapPacket(mapItemDataPacket), NetworkDirection.PLAY_TO_CLIENT);
        } else {
            packet = packet2;
        }
        return packet;
    }
}

