/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.compatibility;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.items.ItemStackHandler;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.helper.PlayerPreference;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotTypeMessage;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

public final class CompatibilityCurio {
    public static final CompatibilityCurio instance = new CompatibilityCurio();
    public final ResourceLocation BUNDLE_SLOT = new ResourceLocation("curios", "item/bundle_slot");
    public final ResourceLocation MAGIC_BOOK_SLOT = new ResourceLocation("curios", "item/magic_book_slot");
    public static final Capability<ICuriosItemHandler> INVENTORY = CapabilityManager.get((CapabilityToken)new CapabilityToken<ICuriosItemHandler>(){});
    public static final Capability<ICurio> ITEM = CapabilityManager.get((CapabilityToken)new CapabilityToken<ICurio>(){});

    private CompatibilityCurio() {
    }

    public void autoEquip(ServerPlayer player, ItemStackHandler itemHandler, List<Integer> ids) {
        if (INVENTORY == null || ITEM == null) {
            return;
        }
        Map map = player.getCapability(INVENTORY).resolve().map(ICuriosItemHandler::getCurios).orElse(null);
        if (map == null) {
            return;
        }
        ListIterator<Integer> idIterator = ids.listIterator(ids.size());
        block0: while (idIterator.hasPrevious()) {
            int slotId = idIterator.previous();
            ItemStack stack = itemHandler.getStackInSlot(slotId);
            Set tags = CuriosApi.getCuriosHelper().getCurioTags(stack.m_41720_());
            ListIterator tagIterator = new ArrayList(map.keySet()).listIterator(map.keySet().size());
            while (tagIterator.hasPrevious()) {
                ICurioStacksHandler curioStacksHandler;
                String tag = (String)tagIterator.previous();
                if (tag.equals("magic_book") && !PlayerPreference.get(player).equipCurioSlotMagicBook() || !tags.contains(tag) || (curioStacksHandler = (ICurioStacksHandler)map.get(tag)) == null || !this.autoEquip(curioStacksHandler, stack)) continue;
                itemHandler.setStackInSlot(slotId, ItemStack.f_41583_);
                idIterator.remove();
                continue block0;
            }
        }
    }

    private boolean autoEquip(ICurioStacksHandler curioStacksHandler, ItemStack stack) {
        IDynamicStackHandler dynamicStacks = curioStacksHandler.getStacks();
        for (int i = curioStacksHandler.getSlots() - 1; i >= 0; --i) {
            if (!dynamicStacks.getStackInSlot(i).m_41619_() || !dynamicStacks.isItemValid(i, stack)) continue;
            dynamicStacks.setStackInSlot(i, stack.m_41777_());
            return true;
        }
        return false;
    }

    public void sendIMC() {
        if (((Boolean)ConfigTombstone.compatibility.curioBundleSupport.get()).booleanValue()) {
            InterModComms.sendTo((String)"curios", (String)"register_type", () -> new SlotTypeMessage.Builder("bundle").icon(this.BUNDLE_SLOT).size(2).build());
        }
        if (((Boolean)ConfigTombstone.compatibility.curioMagicBookSupport.get()).booleanValue()) {
            InterModComms.sendTo((String)"curios", (String)"register_type", () -> new SlotTypeMessage.Builder("magic_book").icon(this.MAGIC_BOOK_SLOT).size(1).build());
        }
    }

    public ItemStack getStackInMagicBookSlot(Player player) {
        return INVENTORY == null || ITEM == null ? ItemStack.f_41583_ : player.getCapability(INVENTORY).resolve().flatMap(i -> i.getStacksHandler("magic_book")).map(handler -> handler.getStacks().getStackInSlot(0)).orElse(ItemStack.f_41583_);
    }
}

