/*
 * Decompiled with CFR 0.152.
 */
package com.haoict.tiab.items;

import com.haoict.tiab.config.TiabConfig;
import com.haoict.tiab.items.AbstractTiabItem;
import com.haoict.tiab.utils.lang.Styles;
import com.haoict.tiab.utils.lang.Translation;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class TimeInABottleItem
extends AbstractTiabItem {
    public void m_6883_(ItemStack itemStack, Level level, Entity entity, int itemSlot, boolean isSelected) {
        super.m_6883_(itemStack, level, entity, itemSlot, isSelected);
        if (level.f_46443_) {
            return;
        }
        if (level.m_46467_() % 20L == 0L) {
            int totalAccumulatedTime;
            int storedTime = this.getStoredEnergy(itemStack);
            if (storedTime < (Integer)TiabConfig.COMMON.maxStoredTime.get()) {
                this.setStoredEnergy(itemStack, storedTime + 20);
            }
            if ((totalAccumulatedTime = this.getTotalAccumulatedTime(itemStack)) < (Integer)TiabConfig.COMMON.maxStoredTime.get()) {
                this.setTotalAccumulatedTime(itemStack, totalAccumulatedTime + 20);
            }
        }
        if (level.m_46467_() % 200L == 0L) {
            if (!(entity instanceof Player)) {
                return;
            }
            Player player = (Player)entity;
            for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
                ItemStack invStack = player.m_150109_().m_8020_(i);
                if (invStack.m_41720_() != this || invStack == itemStack) continue;
                int otherTimeData = this.getStoredEnergy(invStack);
                int myTimeData = this.getStoredEnergy(itemStack);
                if (myTimeData >= otherTimeData) continue;
                this.setStoredEnergy(itemStack, 0);
            }
        }
    }

    public void m_7373_(ItemStack itemStack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(itemStack, world, tooltip, flag);
        int storedTime = this.getStoredEnergy(itemStack);
        int storedSeconds = storedTime / 20;
        int hours = storedSeconds / 3600;
        int minutes = storedSeconds % 3600 / 60;
        int seconds = storedSeconds % 60;
        int totalAccumulatedTime = this.getTotalAccumulatedTime(itemStack);
        int totalAccumulatedTimeSeconds = totalAccumulatedTime / 20;
        int totalAccumulatedHours = totalAccumulatedTimeSeconds / 3600;
        int totalAccumulatedMinutes = totalAccumulatedTimeSeconds % 3600 / 60;
        int totalAccumulatedSeconds = totalAccumulatedTimeSeconds % 60;
        tooltip.add((Component)Translation.TOOLTIP_STORED_TIME.componentTranslation(String.format("%02d", hours), String.format("%02d", minutes), String.format("%02d", seconds)).m_6270_(Styles.GREEN));
        tooltip.add((Component)Translation.TOOLTIP_TOTAL_ACCUMULATED_TIME.componentTranslation(String.format("%02d", totalAccumulatedHours), String.format("%02d", totalAccumulatedMinutes), String.format("%02d", totalAccumulatedSeconds)).m_6270_(Styles.GRAY));
    }

    @Override
    public int getStoredEnergy(ItemStack stack) {
        return stack.m_41784_().m_128451_("storedTime");
    }

    @Override
    public void setStoredEnergy(ItemStack stack, int energy) {
        int newStoredTime = Math.min(energy, (Integer)TiabConfig.COMMON.maxStoredTime.get());
        stack.m_41784_().m_128405_("storedTime", newStoredTime);
    }

    @Override
    public void applyDamage(ItemStack stack, int damage) {
        this.setStoredEnergy(stack, this.getStoredEnergy(stack) - damage);
    }

    public int getTotalAccumulatedTime(ItemStack stack) {
        return stack.m_41784_().m_128451_("totalAccumulatedTime");
    }

    public void setTotalAccumulatedTime(ItemStack stack, int value) {
        int newValue = Math.min(value, (Integer)TiabConfig.COMMON.maxStoredTime.get());
        stack.m_41784_().m_128405_("totalAccumulatedTime", newValue);
    }
}

