/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.locomotion.entity;

import cofh.core.fluid.PotionFluid;
import cofh.core.util.filter.FilterRegistry;
import cofh.core.util.helpers.AugmentDataHelper;
import cofh.core.util.helpers.AugmentableHelper;
import cofh.core.util.helpers.FluidHelper;
import cofh.lib.fluid.FluidStorageCoFH;
import cofh.lib.inventory.ItemStorageCoFH;
import cofh.lib.util.Utils;
import cofh.thermal.core.ThermalCore;
import cofh.thermal.core.config.ThermalCoreConfig;
import cofh.thermal.lib.common.ThermalAugmentRules;
import cofh.thermal.lib.entity.AugmentableMinecart;
import cofh.thermal.locomotion.init.TLocEntities;
import cofh.thermal.locomotion.inventory.container.FluidMinecartContainer;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class FluidMinecart
extends AugmentableMinecart
implements MenuProvider {
    public static final BiPredicate<ItemStack, List<ItemStack>> AUG_VALIDATOR = ThermalAugmentRules.createAllowValidator((String[])new String[]{"Upgrade", "Fluid", "Filter"});
    public static final int BASE_CAPACITY = 32000;
    protected ItemStorageCoFH inputSlot = new ItemStorageCoFH(1, item -> FluidHelper.hasFluidHandlerCap((ItemStack)item) || item.m_41720_() == Items.f_42589_);
    protected ItemStorageCoFH outputSlot = new ItemStorageCoFH(1, FluidHelper::hasFluidHandlerCap);
    protected FluidStorageCoFH tank = new FluidStorageCoFH(32000, fluid -> this.filter.valid(fluid));
    protected LazyOptional<?> fluidCap = LazyOptional.empty();

    public FluidMinecart(EntityType<? extends FluidMinecart> type, Level worldIn) {
        super(type, worldIn);
        this.inventory.addSlot(this.inputSlot);
        this.inventory.addSlot(this.outputSlot);
        this.addAugmentSlots(ThermalCoreConfig.storageAugments);
    }

    public FluidMinecart(Level worldIn, double posX, double posY, double posZ) {
        super((EntityType)TLocEntities.FLUID_CART.get(), worldIn, posX, posY, posZ);
        this.inventory.addSlot(this.inputSlot);
        this.inventory.addSlot(this.outputSlot);
        this.addAugmentSlots(ThermalCoreConfig.storageAugments);
    }

    protected void handleFluid() {
        if (!this.inputSlot.isEmpty()) {
            ItemStack inputStack = this.inputSlot.getItemStack();
            if (inputStack.m_41720_() == Items.f_42589_) {
                FluidStack potion = PotionFluid.getPotionFluidFromItem((int)250, (ItemStack)inputStack);
                if (this.tank.fill(potion, IFluidHandler.FluidAction.SIMULATE) == 250) {
                    this.tank.fill(potion, IFluidHandler.FluidAction.EXECUTE);
                    this.inputSlot.setItemStack(new ItemStack((ItemLike)Items.f_42590_));
                }
            } else {
                inputStack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null).ifPresent(c -> {
                    int toFill = this.tank.fill(new FluidStack(c.getFluidInTank(0), 1000), IFluidHandler.FluidAction.SIMULATE);
                    if (toFill > 0) {
                        this.tank.fill(c.drain(toFill, IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE);
                        this.inputSlot.setItemStack(c.getContainer());
                    }
                });
            }
        }
        if (!this.outputSlot.isEmpty()) {
            this.outputSlot.getItemStack().getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null).ifPresent(c -> {
                this.tank.drain(c.fill(new FluidStack(this.tank.getFluidStack(), Math.min(this.tank.getAmount(), 1000)), IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE);
                this.outputSlot.setItemStack(c.getContainer());
            });
        }
    }

    public FluidStorageCoFH getTank() {
        return this.tank;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(FLUID_STACK_STORED, (Object)FluidStack.EMPTY);
        this.f_19804_.m_135372_(FLUID_STORED, (Object)0);
    }

    public FluidMinecart onPlaced(ItemStack stack) {
        if (stack.m_41783_() != null) {
            this.tank.read(stack.m_41783_());
        }
        super.onPlaced(stack);
        return this;
    }

    public void m_8119_() {
        if (Utils.isServerWorld((Level)this.f_19853_)) {
            this.handleFluid();
            this.f_19804_.m_135381_(FLUID_STACK_STORED, (Object)this.tank.getFluidStack());
            this.f_19804_.m_135381_(FLUID_STORED, (Object)this.tank.getStored());
        } else {
            this.tank.setFluidStack((FluidStack)this.f_19804_.m_135370_(FLUID_STACK_STORED));
            if (!this.tank.isEmpty()) {
                this.tank.getFluidStack().setAmount(((Integer)this.f_19804_.m_135370_(FLUID_STORED)).intValue());
            }
        }
        super.m_8119_();
    }

    protected Item m_213728_() {
        return (Item)ThermalCore.ITEMS.get("fluid_minecart");
    }

    public ItemStack createItemStackTag(ItemStack stack) {
        this.tank.write(stack.m_41784_());
        return super.createItemStackTag(stack);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.tank.read(compound);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        this.tank.write(compound);
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        if (player.m_36341_() || this.m_20160_()) {
            return InteractionResult.PASS;
        }
        if (!Utils.isClientWorld((Level)this.f_19853_)) {
            if (this.attemptFluidHandlerInteraction(player, hand)) {
                return InteractionResult.SUCCESS;
            }
            Utils.openEntityScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)this, (Entity)this);
        }
        return InteractionResult.SUCCESS;
    }

    public ItemStack m_142340_() {
        return new ItemStack((ItemLike)ThermalCore.ITEMS.get("fluid_minecart"));
    }

    public AbstractMinecart.Type m_6064_() {
        return AbstractMinecart.Type.CHEST;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int i, Inventory inventory, Player player) {
        return new FluidMinecartContainer(i, inventory, this);
    }

    protected Predicate<ItemStack> augValidator() {
        return item -> AugmentDataHelper.hasAugmentData((ItemStack)item) && AUG_VALIDATOR.test((ItemStack)item, this.getAugmentsAsList());
    }

    protected void finalizeAttributes(Map<Enchantment, Integer> enchantmentMap) {
        float holdingMod = this.getHoldingMod(enchantmentMap);
        float baseMod = AugmentableHelper.getAttributeModWithDefault((CompoundTag)this.augmentNBT, (String)"BaseMod", (float)1.0f);
        float fluidStorageMod = holdingMod * baseMod * AugmentableHelper.getAttributeModWithDefault((CompoundTag)this.augmentNBT, (String)"FluidMax", (float)1.0f);
        this.tank.applyModifiers(fluidStorageMod).setCreative(() -> this.creativeTanks);
        CompoundTag filterNBT = this.filter.write(new CompoundTag());
        this.filter = FilterRegistry.getFilter((String)AugmentableHelper.getAttributeModString((CompoundTag)this.augmentNBT, (String)"FilterType"), (CompoundTag)filterNBT, (Entity)this);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            if (!this.fluidCap.isPresent() && this.tank.getCapacity() > 0) {
                this.fluidCap = LazyOptional.of(() -> this.tank);
            }
            return this.fluidCap.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.fluidCap.invalidate();
    }
}

