/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.locomotion.entity;

import cofh.core.util.helpers.AugmentDataHelper;
import cofh.core.util.helpers.AugmentableHelper;
import cofh.lib.energy.EnergyStorageCoFH;
import cofh.lib.inventory.ItemStorageCoFH;
import cofh.lib.util.Utils;
import cofh.thermal.core.ThermalCore;
import cofh.thermal.core.config.ThermalCoreConfig;
import cofh.thermal.lib.common.ThermalAugmentRules;
import cofh.thermal.lib.entity.AugmentableMinecart;
import cofh.thermal.lib.util.ThermalEnergyHelper;
import cofh.thermal.locomotion.init.TLocEntities;
import cofh.thermal.locomotion.inventory.container.EnergyMinecartContainer;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class EnergyMinecart
extends AugmentableMinecart
implements MenuProvider {
    public static final int BASE_CAPACITY = 1000000;
    public static final int BASE_XFER = 1000;
    protected ItemStorageCoFH inputSlot = new ItemStorageCoFH(1, ThermalEnergyHelper::hasEnergyHandlerCap);
    protected ItemStorageCoFH outputSlot = new ItemStorageCoFH(1, ThermalEnergyHelper::hasEnergyHandlerCap);
    protected EnergyStorageCoFH energyStorage = new EnergyStorageCoFH(1000000, 1000);
    protected LazyOptional<?> energyCap = LazyOptional.empty();

    public EnergyMinecart(EntityType<? extends EnergyMinecart> type, Level worldIn) {
        super(type, worldIn);
        this.inventory.addSlot(this.inputSlot);
        this.inventory.addSlot(this.outputSlot);
        this.f_19804_.m_135381_(ENERGY_STORED, (Object)0);
        this.addAugmentSlots(ThermalCoreConfig.storageAugments);
    }

    public EnergyMinecart(Level worldIn, double posX, double posY, double posZ) {
        super((EntityType)TLocEntities.ENERGY_CART.get(), worldIn, posX, posY, posZ);
        this.inventory.addSlot(this.inputSlot);
        this.inventory.addSlot(this.outputSlot);
        this.f_19804_.m_135381_(ENERGY_STORED, (Object)0);
        this.addAugmentSlots(ThermalCoreConfig.storageAugments);
    }

    protected void handleEnergy() {
        int maxTransfer;
        if (!this.inputSlot.isEmpty()) {
            maxTransfer = Math.min(this.energyStorage.getMaxReceive(), this.energyStorage.getSpace());
            this.inputSlot.getItemStack().getCapability(ThermalEnergyHelper.getBaseEnergySystem(), null).ifPresent(c -> this.energyStorage.receiveEnergy(c.extractEnergy(maxTransfer, false), false));
        }
        if (!this.outputSlot.isEmpty()) {
            maxTransfer = Math.min(this.energyStorage.getMaxExtract(), this.energyStorage.getEnergyStored());
            this.outputSlot.getItemStack().getCapability(ThermalEnergyHelper.getBaseEnergySystem(), null).ifPresent(c -> this.energyStorage.extractEnergy(c.receiveEnergy(maxTransfer, false), false));
        }
    }

    public EnergyStorageCoFH getEnergyStorage() {
        return this.energyStorage;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ENERGY_STORED, (Object)0);
    }

    public EnergyMinecart onPlaced(ItemStack stack) {
        if (stack.m_41783_() != null) {
            this.energyStorage.read(stack.m_41783_());
        }
        super.onPlaced(stack);
        return this;
    }

    public void m_8119_() {
        if (Utils.isServerWorld((Level)this.f_19853_)) {
            this.handleEnergy();
            this.f_19804_.m_135381_(ENERGY_STORED, (Object)this.energyStorage.getEnergyStored());
        } else {
            this.energyStorage.setEnergyStored(((Integer)this.f_19804_.m_135370_(ENERGY_STORED)).intValue());
        }
        super.m_8119_();
    }

    protected Item m_213728_() {
        return (Item)ThermalCore.ITEMS.get("energy_minecart");
    }

    public ItemStack createItemStackTag(ItemStack stack) {
        this.energyStorage.writeWithParams(stack.m_41784_());
        return super.createItemStackTag(stack);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.energyStorage.read(compound);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        this.energyStorage.write(compound);
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        if (player.m_36341_() || this.m_20160_()) {
            return InteractionResult.PASS;
        }
        if (!Utils.isClientWorld((Level)this.f_19853_)) {
            Utils.openEntityScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)this, (Entity)this);
        }
        return InteractionResult.SUCCESS;
    }

    public ItemStack m_142340_() {
        return new ItemStack((ItemLike)ThermalCore.ITEMS.get("energy_minecart"));
    }

    public AbstractMinecart.Type m_6064_() {
        return AbstractMinecart.Type.CHEST;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int i, Inventory inventory, Player player) {
        return new EnergyMinecartContainer(i, inventory, this);
    }

    protected Predicate<ItemStack> augValidator() {
        return item -> AugmentDataHelper.hasAugmentData((ItemStack)item) && ThermalAugmentRules.ENERGY_STORAGE_VALIDATOR.test(item, this.getAugmentsAsList());
    }

    protected void finalizeAttributes(Map<Enchantment, Integer> enchantmentMap) {
        float holdingMod = this.getHoldingMod(enchantmentMap);
        float baseMod = AugmentableHelper.getAttributeModWithDefault((CompoundTag)this.augmentNBT, (String)"BaseMod", (float)1.0f);
        float energyStorageMod = holdingMod * baseMod * AugmentableHelper.getAttributeModWithDefault((CompoundTag)this.augmentNBT, (String)"RFMax", (float)1.0f);
        float energyXferMod = baseMod * AugmentableHelper.getAttributeModWithDefault((CompoundTag)this.augmentNBT, (String)"RFXfer", (float)1.0f);
        this.energyStorage.applyModifiers(energyStorageMod, energyXferMod).setCreative(() -> this.creativeEnergy);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == ThermalEnergyHelper.getBaseEnergySystem()) {
            if (!this.energyCap.isPresent() && this.energyStorage.getCapacity() > 0) {
                this.energyCap = LazyOptional.of(() -> this.energyStorage);
            }
            return this.energyCap.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.energyCap.invalidate();
    }
}

