/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.upgrades;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.Slot;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import vswe.stevescarts.blocks.tileentities.TileEntityUpgrade;
import vswe.stevescarts.client.guis.GuiUpgrade;
import vswe.stevescarts.containers.slots.SlotLiquidOutput;
import vswe.stevescarts.containers.slots.SlotLiquidUpgradeInput;
import vswe.stevescarts.helpers.ResourceHelper;
import vswe.stevescarts.helpers.storages.SCTank;
import vswe.stevescarts.upgrades.InventoryEffect;

public abstract class TankEffect
extends InventoryEffect {
    private static final int tankInterfaceX = 35;
    private static final int tankInterfaceY = 20;
    private static ResourceLocation texture;

    public abstract int getTankSize();

    @Override
    public Class<? extends Slot> getSlot(int id) {
        return SlotLiquidOutput.class;
    }

    @Override
    public Slot createSlot(TileEntityUpgrade upgrade, int id) {
        if (id == 0) {
            return new SlotLiquidUpgradeInput(upgrade, upgrade.tank, 16, id, this.getSlotX(id), this.getSlotY(id));
        }
        return super.createSlot(upgrade, id);
    }

    @Override
    public int getInventorySize() {
        return 2;
    }

    @Override
    public int getSlotX(int id) {
        return 8;
    }

    @Override
    public int getSlotY(int id) {
        return 24 * (id + 1);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawBackground(PoseStack matrixStack, TileEntityUpgrade upgrade, GuiUpgrade gui, int x, int y) {
        if (texture == null) {
            texture = ResourceHelper.getResource("/gui/tank.png");
        }
        upgrade.tank.drawFluid(matrixStack, gui, 35, 20);
        ResourceHelper.bindResource(texture);
        gui.m_93228_(matrixStack, gui.getGuiLeft() + 35, gui.getGuiTop() + 20, 0, 0, 36, 51);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawMouseOver(PoseStack matrixStack, TileEntityUpgrade upgrade, GuiUpgrade gui, int x, int y) {
        this.drawMouseOver(matrixStack, gui, upgrade.tank.getMouseOver(), x, y, new int[]{35, 35, 36, 51});
    }

    @Override
    public void init(TileEntityUpgrade upgrade) {
        upgrade.tank = new SCTank(upgrade, this.getTankSize(), 0);
        upgrade.getCompound().m_128344_("Tick", (byte)0);
    }

    @Override
    public void update(TileEntityUpgrade upgrade) {
        super.update(upgrade);
        if (upgrade.m_58904_() == null) {
            return;
        }
        upgrade.getCompound().m_128344_("Tick", (byte)(upgrade.getCompound().m_128445_("Tick") - 1));
        if (upgrade.getCompound().m_128445_("Tick") <= 0) {
            upgrade.getCompound().m_128344_("Tick", (byte)5);
            if (!upgrade.m_58904_().f_46443_ && this.slots != null && this.slots.size() >= 2) {
                upgrade.tank.containerTransfer();
            }
        }
    }

    @Override
    public void load(TileEntityUpgrade upgrade, CompoundTag compound) {
        if (compound.m_128445_("Exists") != 0) {
            upgrade.tank.setFluid(FluidStack.loadFluidStackFromNBT((CompoundTag)compound));
        } else {
            upgrade.tank.setFluid(FluidStack.EMPTY);
        }
    }

    @Override
    public void save(TileEntityUpgrade upgrade, CompoundTag compound) {
        if (upgrade.tank.getFluid().isEmpty()) {
            compound.m_128344_("Exists", (byte)0);
        } else {
            compound.m_128344_("Exists", (byte)1);
            upgrade.tank.getFluid().writeToNBT(compound);
        }
    }
}

