/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.upgrades;

import java.util.ArrayList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import vswe.stevescarts.api.IModuleItem;
import vswe.stevescarts.api.modules.data.ModuleData;
import vswe.stevescarts.api.modules.data.ModuleDataHull;
import vswe.stevescarts.blocks.tileentities.TileEntityCartAssembler;
import vswe.stevescarts.blocks.tileentities.TileEntityUpgrade;
import vswe.stevescarts.containers.ContainerCartAssembler;
import vswe.stevescarts.containers.slots.SlotAssemblerFuel;
import vswe.stevescarts.containers.slots.SlotModule;
import vswe.stevescarts.helpers.Localization;
import vswe.stevescarts.helpers.storages.TransferHandler;
import vswe.stevescarts.upgrades.BaseEffect;
import vswe.stevescarts.upgrades.Blueprint;
import vswe.stevescarts.upgrades.SimpleInventoryEffect;

public class InputChest
extends SimpleInventoryEffect {
    public InputChest(int inventoryWidth, int inventoryHeight) {
        super(inventoryWidth, inventoryHeight);
    }

    @Override
    public String getName() {
        return Localization.UPGRADES.INPUT_CHEST.translate(String.valueOf(this.getInventorySize()));
    }

    @Override
    public void init(TileEntityUpgrade upgrade) {
        upgrade.getCompound().m_128344_("TransferCooldown", (byte)0);
    }

    @Override
    public Class<? extends Slot> getSlot(int i) {
        return SlotModule.class;
    }

    @Override
    public void update(TileEntityUpgrade upgrade) {
        if (upgrade.m_58904_() == null) {
            return;
        }
        if (!upgrade.m_58904_().f_46443_ && upgrade.getMaster() != null) {
            CompoundTag comp = upgrade.getCompound();
            if (comp.m_128445_("TransferCooldown") != 0) {
                comp.m_128344_("TransferCooldown", (byte)(comp.m_128445_("TransferCooldown") - 1));
            } else {
                comp.m_128344_("TransferCooldown", (byte)20);
                for (int slotId = 0; slotId < upgrade.getUpgrade().getInventorySize(); ++slotId) {
                    IModuleItem itemCartModule;
                    ModuleData module;
                    ItemStack itemstack = upgrade.m_8020_(slotId);
                    if (itemstack.m_41619_() || (module = (itemCartModule = (IModuleItem)itemstack.m_41720_()).getModuleData()) == null || !this.isValidForBluePrint(upgrade.getMaster(), module) || this.willInvalidate(upgrade.getMaster(), module)) continue;
                    int stackSize = itemstack.m_41613_();
                    TransferHandler.TransferItem(itemstack, (Container)upgrade.getMaster(), (AbstractContainerMenu)new ContainerCartAssembler(0, null, upgrade.getMaster(), new SimpleContainerData(17)), Slot.class, SlotAssemblerFuel.class, 1);
                    if (itemstack.m_41613_() == 0) {
                        upgrade.m_6836_(slotId, ItemStack.f_41583_);
                    }
                    if (stackSize != itemstack.m_41613_()) break;
                }
            }
        }
    }

    private boolean willInvalidate(TileEntityCartAssembler assembler, ModuleData module) {
        ModuleDataHull hull = assembler.getHullModule();
        if (hull == null) {
            return false;
        }
        ArrayList<ModuleData> modules = assembler.getNonHullModules();
        modules.add(module);
        return ModuleData.checkForErrors(hull, modules) != null;
    }

    private boolean isValidForBluePrint(TileEntityCartAssembler assembler, ModuleData module) {
        for (TileEntityUpgrade tile : assembler.getUpgradeTiles()) {
            for (BaseEffect effect : tile.getUpgrade().getEffects()) {
                if (!(effect instanceof Blueprint)) continue;
                return ((Blueprint)effect).isValidForBluePrint(tile, assembler.getModules(true), module);
            }
        }
        return true;
    }
}

