/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.upgrades;

import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import vswe.stevescarts.api.modules.data.ModuleData;
import vswe.stevescarts.blocks.tileentities.TileEntityCartAssembler;
import vswe.stevescarts.blocks.tileentities.TileEntityUpgrade;
import vswe.stevescarts.containers.ContainerCartAssembler;
import vswe.stevescarts.containers.slots.SlotCart;
import vswe.stevescarts.containers.slots.SlotModule;
import vswe.stevescarts.helpers.Localization;
import vswe.stevescarts.helpers.storages.TransferHandler;
import vswe.stevescarts.init.ModItems;
import vswe.stevescarts.upgrades.BaseEffect;
import vswe.stevescarts.upgrades.InventoryEffect;

public class Disassemble
extends InventoryEffect {
    @Override
    public int getInventorySize() {
        return 31;
    }

    @Override
    public int getSlotX(int id) {
        if (id == 0) {
            return 178;
        }
        return 38 + (id - 1) % 10 * 18;
    }

    @Override
    public int getSlotY(int id) {
        int y = id == 0 ? 0 : (id - 1) / 10 + 2;
        return 8 + y * 18;
    }

    @Override
    public Class<? extends Slot> getSlot(int i) {
        if (i == 0) {
            return SlotCart.class;
        }
        return SlotModule.class;
    }

    @Override
    public void load(TileEntityUpgrade upgrade, CompoundTag compound) {
        this.setLastCart(upgrade, upgrade.m_8020_(0));
    }

    @Override
    public String getName() {
        return Localization.UPGRADES.DISASSEMBLE.translate(new String[0]);
    }

    @Override
    public void onInventoryChanged(TileEntityUpgrade upgrade) {
        ItemStack cart = upgrade.m_8020_(0);
        if (!this.updateCart(upgrade, cart)) {
            boolean needsToPuke = true;
            for (int i = 1; i < this.getInventorySize(); ++i) {
                if (!upgrade.m_8020_(i).m_41619_()) continue;
                ItemStack item = upgrade.m_8020_(0);
                upgrade.m_6836_(0, ItemStack.f_41583_);
                upgrade.m_6836_(i, item);
                needsToPuke = false;
                break;
            }
            if (needsToPuke) {
                if (!upgrade.m_58904_().f_46443_) {
                    upgrade.getMaster().puke(upgrade.m_8020_(0).m_41777_());
                }
                upgrade.m_6836_(0, ItemStack.f_41583_);
            }
        }
    }

    @Override
    public void removed(TileEntityUpgrade upgrade) {
        this.updateCart(upgrade, ItemStack.f_41583_);
    }

    private void resetMaster(TileEntityCartAssembler master, boolean full) {
        for (int i = 0; i < master.m_6643_() - master.nonModularSlots(); ++i) {
            if (master.m_8020_(i).m_41619_()) continue;
            if (TileEntityCartAssembler.getSlotStatus(master.m_8020_(i)) <= 0) {
                master.m_6836_(i, ItemStack.f_41583_);
                continue;
            }
            if (!full) continue;
            if (!master.m_58904_().f_46443_) {
                master.puke(master.m_8020_(i).m_41777_());
            }
            master.m_6836_(i, ItemStack.f_41583_);
        }
    }

    private void setLastCart(TileEntityUpgrade upgrade, ItemStack cart) {
        if (!cart.m_41619_()) {
            cart.m_41739_(upgrade.getCompound());
        }
    }

    private ItemStack getLastCart(TileEntityUpgrade upgrade) {
        return ItemStack.m_41712_((CompoundTag)upgrade.getCompound());
    }

    private boolean updateCart(TileEntityUpgrade upgrade, ItemStack cart) {
        if (upgrade.getMaster() != null) {
            if (cart.m_41619_() || cart.m_41720_() != ModItems.CARTS.get() || cart.m_41783_() == null || cart.m_41783_().m_128441_("maxTime")) {
                this.resetMaster(upgrade.getMaster(), false);
                this.setLastCart(upgrade, ItemStack.f_41583_);
                if (!cart.m_41619_()) {
                    upgrade.getMaster().puke(cart);
                    upgrade.m_6836_(0, ItemStack.f_41583_);
                }
            } else {
                ItemStack last = this.getLastCart(upgrade);
                this.setLastCart(upgrade, cart);
                int result = this.canDisassemble(upgrade);
                boolean reset = false;
                if (result > 0 && !last.m_41619_() && !ItemStack.m_41746_((ItemStack)cart, (ItemStack)last)) {
                    result = 2;
                    reset = true;
                }
                if (result != 2) {
                    return result == 1 && !upgrade.getMaster().m_8020_(0).m_41619_();
                }
                if (reset) {
                    this.resetMaster(upgrade.getMaster(), true);
                }
                boolean addedHull = false;
                NonNullList<ItemStack> modules = ModuleData.getModularItems(cart);
                for (ItemStack item : modules) {
                    TileEntityCartAssembler.getOrCreateCompound(item).m_128405_("ModifyStatus", 0);
                    TransferHandler.TransferItem(item, (Container)upgrade.getMaster(), new ContainerCartAssembler(0, null, upgrade.getMaster(), new SimpleContainerData(0)), 1);
                    if (addedHull) continue;
                    addedHull = true;
                    upgrade.getMaster().updateSlots();
                }
            }
        }
        return true;
    }

    public int canDisassemble(TileEntityUpgrade upgrade) {
        int i;
        int disassembleCount = 0;
        for (BaseEffect effect : upgrade.getMaster().getEffects()) {
            if (!(effect instanceof Disassemble)) continue;
            ++disassembleCount;
        }
        if (disassembleCount != 1) {
            return 0;
        }
        for (i = 0; i < upgrade.getMaster().m_6643_() - upgrade.getMaster().nonModularSlots(); ++i) {
            if (upgrade.getMaster().m_8020_(i).m_41619_() || TileEntityCartAssembler.getSlotStatus(upgrade.getMaster().m_8020_(i)) > 0) continue;
            return 1;
        }
        for (i = 0; i < upgrade.getMaster().m_6643_() - upgrade.getMaster().nonModularSlots(); ++i) {
            if (upgrade.getMaster().m_8020_(i).m_41619_()) continue;
            return 0;
        }
        return 2;
    }
}

