/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.network;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import vswe.stevescarts.helpers.EnchantmentData;

public class DataSerializers {
    public static final EntityDataSerializer<BoolArray> BOOL_ARRAY = EntityDataSerializer.m_238095_((buf, boolArray) -> boolArray.write((FriendlyByteBuf)buf), BoolArray::read);
    public static final EntityDataSerializer<ShortArray> SHORT_ARRAY = EntityDataSerializer.m_238095_((buf, shortArray) -> shortArray.write((FriendlyByteBuf)buf), ShortArray::read);
    public static final EntityDataSerializer<EnchantmentData> ENCHANT_DATA = EntityDataSerializer.m_238095_((buf, data) -> data.write((FriendlyByteBuf)buf), EnchantmentData::read);

    static {
        EntityDataSerializers.m_135050_(BOOL_ARRAY);
        EntityDataSerializers.m_135050_(SHORT_ARRAY);
        EntityDataSerializers.m_135050_(ENCHANT_DATA);
    }

    public static class ShortArray {
        private final short[] storage;

        public ShortArray(short[] storage) {
            this.storage = storage;
        }

        public ShortArray(int size) {
            this.storage = new short[size];
        }

        public short get(int index) {
            return this.storage[index];
        }

        public ShortArray set(int index, short value) {
            this.storage[index] = value;
            return this;
        }

        private void write(FriendlyByteBuf buf) {
            buf.m_130130_(this.storage.length);
            for (short s : this.storage) {
                buf.writeShort((int)s);
            }
        }

        private static ShortArray read(FriendlyByteBuf buf) {
            short[] shorts = new short[buf.m_130242_()];
            for (int i = 0; i < shorts.length; ++i) {
                shorts[i] = buf.readShort();
            }
            return new ShortArray(shorts);
        }

        public short[] getArray() {
            return this.storage;
        }
    }

    public static class BoolArray {
        private final byte[] storage;

        BoolArray(byte[] storage) {
            this.storage = storage;
        }

        public BoolArray(int size) {
            this.storage = new byte[(int)Math.ceil((double)size / 8.0)];
        }

        public boolean get(int index) {
            if (index < 0 || index / 8 >= this.storage.length) {
                return false;
            }
            return (this.storage[index / 8] & 1 << index % 8) != 0;
        }

        public BoolArray set(int index, boolean value) {
            if (index < 0 || index / 8 >= this.storage.length || value == this.get(index)) {
                return this;
            }
            if (value) {
                int n = index / 8;
                this.storage[n] = (byte)(this.storage[n] | 1 << index % 8);
            } else {
                int n = index / 8;
                this.storage[n] = (byte)(this.storage[n] & ~(1 << index % 8));
            }
            return this;
        }

        private void write(FriendlyByteBuf buf) {
            buf.m_130087_(this.storage);
        }

        private static BoolArray read(FriendlyByteBuf buf) {
            return new BoolArray(buf.m_130052_());
        }

        public byte[] getBytes() {
            return this.storage;
        }

        public static BoolArray fromBytes(byte[] bytes) {
            return new BoolArray(bytes);
        }
    }
}

