/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.modules.workers;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.TorchBlock;
import net.minecraft.world.level.block.WallTorchBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vswe.stevescarts.api.modules.interfaces.ISuppliesModule;
import vswe.stevescarts.client.guis.GuiMinecart;
import vswe.stevescarts.containers.slots.SlotBase;
import vswe.stevescarts.containers.slots.SlotTorch;
import vswe.stevescarts.entities.EntityMinecartModular;
import vswe.stevescarts.helpers.ResourceHelper;
import vswe.stevescarts.modules.workers.ModuleWorker;

public class ModuleTorch
extends ModuleWorker
implements ISuppliesModule {
    private int light;
    private int lightLimit = 8;
    private int[] boxRect = new int[]{12, this.guiHeight() - 10, 46, 9};
    boolean markerMoving = false;
    private EntityDataAccessor<Integer> TORCHES;
    private EntityDataAccessor<Integer> LIGHT_LEVEL;

    public ModuleTorch(EntityMinecartModular cart) {
        super(cart);
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public int guiWidth() {
        return 80;
    }

    @Override
    protected SlotBase getSlot(int slotId, int x, int y) {
        return new SlotTorch(this.getCart(), slotId, 8 + x * 18, 23 + y * 18);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawForeground(PoseStack matrixStack, GuiMinecart gui) {
        this.drawString(matrixStack, gui, this.getModuleName(), 8, 6, 0x404040);
    }

    @Override
    public byte getWorkPriority() {
        return 95;
    }

    @Override
    public boolean work() {
        BlockPos next = this.getLastblock();
        EntityMinecartModular cart = this.getCart();
        Level world = cart.f_19853_;
        int x = next.m_123341_();
        int y = next.m_123342_();
        int z = next.m_123343_();
        int cartX = cart.x();
        int cartZ = cart.z();
        if (this.light > this.lightLimit) {
            this.stopWorking();
            return false;
        }
        block0: for (int side = -1; side <= 1; side += 2) {
            int xTorch = x + (cartZ != z ? side : 0);
            int zTorch = z + (cartX != x ? side : 0);
            for (int level = 2; level >= -2; --level) {
                BlockPos pos = new BlockPos(xTorch, y + level, zTorch);
                BlockState state = Blocks.f_50081_.m_49966_();
                boolean canPlace = true;
                if (!Blocks.f_50081_.m_7898_(state, (LevelReader)world, pos)) {
                    canPlace = false;
                    for (Direction direction : Direction.Plane.HORIZONTAL) {
                        state = (BlockState)Blocks.f_50082_.m_49966_().m_61124_((Property)WallTorchBlock.f_58119_, (Comparable)direction);
                        if (!Blocks.f_50082_.m_7898_(state, (LevelReader)world, pos)) continue;
                        canPlace = true;
                        break;
                    }
                }
                if (world.m_8055_(pos).m_60795_() && canPlace) {
                    for (int i = 0; i < this.getInventorySize(); ++i) {
                        if (this.getStack(i).m_41619_() || Block.m_49814_((Item)this.getStack(i).m_41720_()) != Blocks.f_50081_) continue;
                        if (this.doPreWork()) {
                            this.startWorking(3);
                            return true;
                        }
                        world.m_7731_(pos, state, 3);
                        if (cart.hasCreativeSupplies()) continue block0;
                        ItemStack stack = this.getStack(i);
                        stack.m_41774_(1);
                        if (this.getStack(i).m_41613_() == 0) {
                            this.setStack(i, ItemStack.f_41583_);
                        }
                        this.onInventoryChanged();
                        continue block0;
                    }
                    continue block0;
                }
                if (world.m_8055_(pos).m_60734_() instanceof TorchBlock) continue block0;
            }
        }
        this.stopWorking();
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawBackground(PoseStack matrixStack, GuiMinecart gui, int x, int y) {
        ResourceHelper.bindResource("/gui/torch.png");
        int barLength = 3 * this.light;
        if (this.light == 15) {
            --barLength;
        }
        int srcX = 0;
        if (this.inRect(x, y, this.boxRect)) {
            srcX += this.boxRect[2];
        }
        this.drawImage(matrixStack, gui, this.boxRect, srcX, 0);
        this.drawImage(matrixStack, gui, 13, this.guiHeight() - 10 + 1, 0, 9, barLength, 7);
        this.drawImage(matrixStack, gui, 12 + 3 * this.lightLimit, this.guiHeight() - 10, 0, 16, 1, 9);
    }

    @Override
    public void drawMouseOver(PoseStack matrixStack, GuiMinecart gui, int x, int y) {
        this.drawStringOnMouseOver(matrixStack, gui, "Threshold: " + this.lightLimit + " Current: " + this.light, x, y, this.boxRect);
    }

    @Override
    public int guiHeight() {
        return super.guiHeight() + 10;
    }

    @Override
    public int numberOfGuiData() {
        return 2;
    }

    @Override
    protected void checkGuiData(Object[] info) {
        short data = (short)(this.light & 0xF);
        data = (short)(data | (short)((this.lightLimit & 0xF) << 4));
        this.updateGuiData(info, 0, data);
    }

    @Override
    public void receiveGuiData(int id, short data) {
        if (id == 0) {
            this.light = data & 0xF;
            this.lightLimit = (data & 0xF0) >> 4;
        }
    }

    @Override
    public int numberOfPackets() {
        return 1;
    }

    @Override
    protected void receivePacket(int id, byte[] data, Player player) {
        this.lightLimit = data[0];
        if (this.lightLimit < 0) {
            this.lightLimit = 0;
        } else if (this.lightLimit > 15) {
            this.lightLimit = 15;
        }
    }

    @Override
    public void mouseClicked(GuiMinecart gui, int x, int y, int button) {
        if (button == 0 && this.inRect(x, y, this.boxRect)) {
            this.generatePacket(x, y);
            this.markerMoving = true;
        }
    }

    @Override
    public void mouseMovedOrUp(GuiMinecart gui, int x, int y, int button) {
        if (this.markerMoving) {
            this.generatePacket(x, y);
        }
        if (button != -1) {
            this.markerMoving = false;
        }
    }

    private void generatePacket(int x, int y) {
        int xInBox = x - this.boxRect[0];
        int val = xInBox / 3;
        if (val < 0) {
            val = 0;
        } else if (val > 15) {
            val = 15;
        }
        this.sendPacket(0, (byte)val);
    }

    public void setThreshold(byte val) {
        this.lightLimit = val;
    }

    public int getThreshold() {
        return this.lightLimit;
    }

    public int getLightLevel() {
        return this.light;
    }

    @Override
    public void update() {
        super.update();
        this.light = this.getCart().f_19853_.m_5518_().m_75831_(this.getCart().m_20183_(), 15);
    }

    @Override
    public void initDw() {
        this.TORCHES = this.createDw(EntityDataSerializers.f_135028_);
        this.LIGHT_LEVEL = this.createDw(EntityDataSerializers.f_135028_);
        this.registerDw(this.TORCHES, 0);
    }

    @Override
    public int numberOfDataWatchers() {
        return 2;
    }

    @Override
    public void onInventoryChanged() {
        super.onInventoryChanged();
        this.calculateTorches();
    }

    private void calculateTorches() {
        if (this.getCart().f_19853_.f_46443_) {
            return;
        }
        int val = 0;
        for (int i = 0; i < 3; ++i) {
            val |= (!this.getStack(i).m_41619_() ? 1 : 0) << i;
        }
        this.updateDw(this.TORCHES, val);
    }

    public int getTorches() {
        if (this.isPlaceholder()) {
            return this.getSimInfo().getTorchInfo();
        }
        return this.getDw(this.TORCHES);
    }

    @Override
    protected void Save(CompoundTag tagCompound, int id) {
        tagCompound.m_128344_(this.generateNBTName("lightLimit", id), (byte)this.lightLimit);
    }

    @Override
    protected void Load(CompoundTag tagCompound, int id) {
        this.lightLimit = tagCompound.m_128445_(this.generateNBTName("lightLimit", id));
        this.calculateTorches();
    }

    @Override
    public boolean haveSupplies() {
        for (int i = 0; i < this.getInventorySize(); ++i) {
            ItemStack item = this.getStack(i);
            if (item.m_41619_() || item.m_41720_() != Items.f_42000_) continue;
            return true;
        }
        return false;
    }
}

