/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.modules.workers;

import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.capability.IFluidHandler;
import vswe.stevescarts.entities.EntityMinecartModular;
import vswe.stevescarts.helpers.BlockPosHelpers;
import vswe.stevescarts.modules.workers.ModuleWorker;
import vswe.stevescarts.modules.workers.tools.ModuleDrill;

public class ModuleLiquidDrainer
extends ModuleWorker {
    public ModuleLiquidDrainer(EntityMinecartModular cart) {
        super(cart);
    }

    @Override
    public byte getWorkPriority() {
        return 0;
    }

    @Override
    public boolean work() {
        return false;
    }

    public void handleLiquid(ModuleDrill drill, BlockPos pos) {
        ArrayList<BlockPos> checked = new ArrayList<BlockPos>();
        int result = this.drainAt(this.getCart().f_19853_, drill, checked, pos, 0);
        if (result > 0 && this.doPreWork()) {
            drill.kill();
            this.startWorking((int)(2.5f * (float)result));
        } else {
            this.stopWorking();
        }
    }

    @Override
    public boolean preventAutoShutdown() {
        return true;
    }

    private int drainAt(Level world, ModuleDrill drill, ArrayList<BlockPos> checked, BlockPos pos, int buckets) {
        int drained = 0;
        BlockState blockState = world.m_8055_(pos);
        Block b = blockState.m_60734_();
        if (!this.isLiquid(b)) {
            return 0;
        }
        FluidStack liquid = this.getFluidStack(b, pos, !this.doPreWork());
        if (liquid != null) {
            int amount;
            if (this.doPreWork()) {
                FluidStack fluidStack = liquid;
                fluidStack.grow(buckets * 1000);
            }
            if ((amount = this.getCart().fill(liquid, IFluidHandler.FluidAction.SIMULATE)) == liquid.getAmount()) {
                boolean isDrainable = true;
                if (!this.doPreWork()) {
                    this.getCart().fill(liquid, IFluidHandler.FluidAction.SIMULATE);
                    world.m_7471_(pos, false);
                }
                drained += 40;
                ++buckets;
            }
        }
        checked.add(pos);
        if (checked.size() < 100 && BlockPosHelpers.getHorizontalDistToCartSquared(pos, this.getCart()) < 200.0) {
            for (int y = 1; y >= 0; --y) {
                for (int x = -1; x <= 1; ++x) {
                    for (int z = -1; z <= 1; ++z) {
                        BlockPos next;
                        if (Math.abs(x) + Math.abs(y) + Math.abs(z) != 1 || checked.contains(next = pos.m_7918_(x, y, z))) continue;
                        drained += this.drainAt(world, drill, checked, next, buckets);
                    }
                }
            }
        }
        return drained;
    }

    private boolean isLiquid(Block b) {
        boolean isWater = b == Blocks.f_49990_ || b == Blocks.f_50126_;
        boolean isLava = b == Blocks.f_49991_;
        boolean isOther = b != null && b instanceof IFluidBlock;
        return isWater || isLava || isOther;
    }

    private FluidStack getFluidStack(Block b, BlockPos pos, boolean doDrain) {
        if (b == Blocks.f_49990_) {
            return new FluidStack((Fluid)Fluids.f_76193_, 1000);
        }
        if (b == Blocks.f_49991_) {
            return new FluidStack((Fluid)Fluids.f_76195_, 1000);
        }
        if (b instanceof IFluidBlock) {
            IFluidBlock liquid = (IFluidBlock)b;
            return liquid.drain(this.getCart().f_19853_, pos, IFluidHandler.FluidAction.EXECUTE);
        }
        return null;
    }
}

