/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.modules.workers;

import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.capability.IFluidHandler;
import vswe.stevescarts.api.modules.ModuleBase;
import vswe.stevescarts.entities.EntityMinecartModular;
import vswe.stevescarts.modules.workers.ModuleWorker;
import vswe.stevescarts.modules.workers.tools.ModuleFarmer;

public class ModuleHydrater
extends ModuleWorker {
    private int range = 1;

    public ModuleHydrater(EntityMinecartModular cart) {
        super(cart);
    }

    @Override
    public byte getWorkPriority() {
        return 82;
    }

    @Override
    public void init() {
        super.init();
        for (ModuleBase module : this.getCart().getModules()) {
            if (!(module instanceof ModuleFarmer)) continue;
            ModuleFarmer moduleFarmer = (ModuleFarmer)module;
            this.range = moduleFarmer.getExternalRange();
            break;
        }
    }

    @Override
    public boolean work() {
        Level world = this.getCart().f_19853_;
        BlockPos next = this.getNextblock();
        for (int i = -this.range; i <= this.range; ++i) {
            for (int j = -this.range; j <= this.range; ++j) {
                if (!this.hydrate(world, next.m_7918_(i, -1, j))) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hydrate(Level world, BlockPos pos) {
        int moisture;
        BlockState state = world.m_8055_(pos);
        if (state.m_60734_() == Blocks.f_50093_ && (moisture = ((Integer)state.m_61143_((Property)FarmBlock.f_53243_)).intValue()) != 7) {
            int waterCost = 7 - moisture;
            waterCost = this.getCart().drain((Fluid)Fluids.f_76193_, waterCost, IFluidHandler.FluidAction.SIMULATE);
            if (waterCost > 0) {
                if (this.doPreWork()) {
                    this.startWorking(2 + waterCost);
                    return true;
                }
                this.stopWorking();
                this.getCart().drain((Fluid)Fluids.f_76193_, waterCost, IFluidHandler.FluidAction.EXECUTE);
                world.m_7731_(pos, (BlockState)state.m_61124_((Property)FarmBlock.f_53243_, (Comparable)Integer.valueOf(moisture + waterCost)), 3);
            }
        }
        return false;
    }
}

