/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.modules.workers;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vswe.stevescarts.api.modules.ModuleBase;
import vswe.stevescarts.api.modules.interfaces.ISuppliesModule;
import vswe.stevescarts.client.guis.GuiMinecart;
import vswe.stevescarts.containers.slots.SlotBase;
import vswe.stevescarts.containers.slots.SlotFertilizer;
import vswe.stevescarts.entities.EntityMinecartModular;
import vswe.stevescarts.helpers.Localization;
import vswe.stevescarts.helpers.ResourceHelper;
import vswe.stevescarts.modules.workers.ModuleWorker;
import vswe.stevescarts.modules.workers.tools.ModuleFarmer;

public class ModuleFertilizer
extends ModuleWorker
implements ISuppliesModule {
    private int tankPosX;
    private int tankPosY = 20;
    private int range = 1;
    private EntityDataAccessor<Integer> FERTILIZER;
    private final int fertPerBonemeal = 4;
    private final int maxStacksOfBones = 1;
    private final Random random = new Random();

    public ModuleFertilizer(EntityMinecartModular cart) {
        super(cart);
        this.tankPosX = this.guiWidth() - 21;
    }

    @Override
    public byte getWorkPriority() {
        return 127;
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    protected int getInventoryWidth() {
        return 1;
    }

    @Override
    public void init() {
        super.init();
        for (ModuleBase module : this.getCart().getModules()) {
            if (!(module instanceof ModuleFarmer)) continue;
            this.range = ((ModuleFarmer)module).getExternalRange();
            break;
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawBackground(PoseStack matrixStack, GuiMinecart gui, int x, int y) {
        ResourceHelper.bindResource("/gui/fertilize.png");
        this.drawImage(matrixStack, gui, this.tankPosX, this.tankPosY, 0, 0, 18, 27);
        float percentage = this.getFertAmount() / this.getMaxFert();
        int size = (int)(percentage * 23.0f);
        this.drawImage(matrixStack, gui, this.tankPosX + 2, this.tankPosY + 2 + (23 - size), 18, 23 - size, 14, size);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawMouseOver(PoseStack matrixStack, GuiMinecart gui, int x, int y) {
        this.drawStringOnMouseOver(matrixStack, gui, Localization.MODULES.ATTACHMENTS.FERTILIZERS.translate(new String[0]) + ": " + this.getFertAmount() + " / " + this.getMaxFert(), x, y, this.tankPosX, this.tankPosY, 18, 27);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawForeground(PoseStack matrixStack, GuiMinecart gui) {
        this.drawString(matrixStack, gui, this.getModuleName(), 8, 6, 0x404040);
    }

    @Override
    public int guiWidth() {
        return super.guiWidth() + 25;
    }

    @Override
    public int guiHeight() {
        return Math.max(super.guiHeight(), 50);
    }

    @Override
    protected SlotBase getSlot(int slotId, int x, int y) {
        return new SlotFertilizer(this.getCart(), slotId, 8 + x * 18, 23 + y * 18);
    }

    @Override
    public boolean work() {
        Level world = this.getCart().f_19853_;
        BlockPos next = this.getNextblock();
        for (int i = -this.range; i <= this.range; ++i) {
            for (int j = -this.range; !(j > this.range || this.random.nextInt(25) == 0 && this.fertilize(world, next.m_7918_(i, 1, j))); ++j) {
            }
        }
        return false;
    }

    private boolean fertilize(Level world, BlockPos pos) {
        CropBlock growable;
        BlockState stateOfTopBlock = world.m_8055_(pos);
        Block blockTop = stateOfTopBlock.m_60734_();
        if (this.getFertAmount() > 0 && blockTop instanceof CropBlock && (growable = (CropBlock)blockTop).m_7370_((BlockGetter)world, pos, stateOfTopBlock, false) && growable.m_214167_(world, this.getCart().f_19796_, pos, stateOfTopBlock)) {
            growable.m_214148_((ServerLevel)world, this.getCart().f_19796_, pos, stateOfTopBlock);
            this.setFertAmount(this.getFertAmount() - 2);
            return true;
        }
        return false;
    }

    private void addFert(int amount) {
        int val = this.getFertAmount();
        this.setFertAmount(val += amount);
    }

    public int getFertAmount() {
        return this.getDw(this.FERTILIZER);
    }

    private void setFertAmount(int val) {
        if (!this.isPlaceholder()) {
            this.updateDw(this.FERTILIZER, val);
        }
    }

    @Override
    public int numberOfDataWatchers() {
        return 1;
    }

    @Override
    public void initDw() {
        this.FERTILIZER = this.createDw(EntityDataSerializers.f_135028_);
        this.registerDw(this.FERTILIZER, 0);
    }

    @Override
    public void update() {
        super.update();
        this.loadSupplies();
    }

    private void loadSupplies() {
        if (this.getCart().f_19853_.f_46443_) {
            return;
        }
        if (!this.getStack(0).m_41619_()) {
            boolean isBoneMeal;
            boolean isBone = this.getStack(0).m_41720_() == Items.f_42500_;
            boolean bl = isBoneMeal = this.getStack(0).m_41720_() == Items.f_42499_;
            if (isBone || isBoneMeal) {
                int amount = isBoneMeal ? 1 : 3;
                if (this.getFertAmount() <= 4 * (192 - amount) && this.getStack(0).m_41613_() > 0) {
                    ItemStack stack = this.getStack(0);
                    stack.m_41774_(1);
                    this.addFert(amount * 4);
                }
                if (this.getStack(0).m_41613_() == 0) {
                    this.setStack(0, ItemStack.f_41583_);
                }
            }
        }
    }

    private int getMaxFert() {
        return 768;
    }

    @Override
    protected void Save(CompoundTag tagCompound, int id) {
        tagCompound.m_128376_(this.generateNBTName("Fert", id), (short)this.getFertAmount());
    }

    @Override
    protected void Load(CompoundTag tagCompound, int id) {
        this.setFertAmount(tagCompound.m_128448_(this.generateNBTName("Fert", id)));
    }

    @Override
    public boolean haveSupplies() {
        return this.getFertAmount() > 0;
    }
}

