/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.modules.storages.tanks;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.registries.ForgeRegistries;
import vswe.stevescarts.StevesCarts;
import vswe.stevescarts.api.modules.template.ModuleStorage;
import vswe.stevescarts.client.guis.GuiMinecart;
import vswe.stevescarts.containers.slots.SlotBase;
import vswe.stevescarts.containers.slots.SlotLiquidInput;
import vswe.stevescarts.containers.slots.SlotLiquidOutput;
import vswe.stevescarts.entities.EntityMinecartModular;
import vswe.stevescarts.helpers.Localization;
import vswe.stevescarts.helpers.ResourceHelper;
import vswe.stevescarts.helpers.storages.ITankHolder;
import vswe.stevescarts.helpers.storages.SCTank;

public class ModuleTank
extends ModuleStorage
implements IFluidTank,
ITankHolder {
    protected SCTank tank;
    private int tick;
    protected int[] tankBounds = new int[]{35, 20, 36, 51};
    private EntityDataAccessor<String> FLUID_NAME;
    private EntityDataAccessor<Integer> FLUID_AMOUNT;
    private EntityDataAccessor<Boolean> LOCKED;

    public ModuleTank(EntityMinecartModular cart) {
        super(cart);
        this.tank = new SCTank(this, this.getTankSize(), 0);
    }

    protected int getTankSize() {
        return 0;
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    protected SlotBase getSlot(int slotId, int x, int y) {
        if (y == 0) {
            return new SlotLiquidInput(this.getCart(), this.tank, -1, slotId, 8 + x * 18, 24 + y * 24);
        }
        return new SlotLiquidOutput(this.getCart(), slotId, 8 + x * 18, 24 + y * 24);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawForeground(PoseStack matrixStack, GuiMinecart gui) {
        this.drawString(matrixStack, gui, this.getModuleName(), 8, 6, 0x404040);
    }

    @Override
    public int getInventoryWidth() {
        return 1;
    }

    @Override
    public int getInventoryHeight() {
        return 2;
    }

    @Override
    public int guiWidth() {
        return 100;
    }

    @Override
    public int guiHeight() {
        return 80;
    }

    public boolean hasVisualTank() {
        return true;
    }

    @Override
    public void update() {
        super.update();
        if (this.tick-- <= 0) {
            this.tick = 5;
            if (!this.getCart().f_19853_.f_46443_) {
                this.tank.containerTransfer();
            } else if (!this.isPlaceholder()) {
                if (this.getDw(this.FLUID_NAME).isEmpty()) {
                    this.tank.setFluid(FluidStack.EMPTY);
                } else {
                    try {
                        Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(this.getDw(this.FLUID_NAME).toLowerCase(Locale.ROOT)));
                        if (fluid != null && fluid != Fluids.f_76191_) {
                            this.tank.setFluid(new FluidStack(fluid, this.getDw(this.FLUID_AMOUNT).intValue()));
                        }
                    }
                    catch (Exception e) {
                        StevesCarts.LOGGER.error("Failed to load fluid from dw");
                        StevesCarts.LOGGER.error((Object)e);
                    }
                }
            }
        }
    }

    public void setFluid(FluidStack fluidStack) {
        this.tank.setFluid(fluidStack);
    }

    @Override
    @Nonnull
    public ItemStack getInputContainer(int tankid) {
        return this.getStack(0);
    }

    @Override
    public void setInputContainer(int tankid, ItemStack stack) {
        this.setStack(0, stack);
    }

    @Override
    public void addToOutputContainer(int tankid, @Nonnull ItemStack item) {
        this.addStack(1, item);
    }

    @Override
    public void onFluidUpdated(int tankid) {
        if (this.getCart().f_19853_.f_46443_) {
            return;
        }
        this.updateDw();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawBackground(PoseStack matrixStack, GuiMinecart gui, int x, int y) {
        this.tank.drawFluid(matrixStack, gui, this.tankBounds[0], this.tankBounds[1]);
        ResourceHelper.bindResource("/gui/tank.png");
        this.drawImage(matrixStack, gui, this.tankBounds, 0, 0);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawMouseOver(PoseStack matrixStack, GuiMinecart gui, int x, int y) {
        this.drawStringOnMouseOver(matrixStack, gui, this.getTankInfo(), x, y, this.tankBounds);
    }

    protected String getTankInfo() {
        Object str = this.tank.getMouseOver();
        if (this.getDw(this.LOCKED).booleanValue()) {
            str = (String)str + "\n\n" + Localization.MODULES.TANKS.LOCKED.translate(new String[0]) + "\n" + Localization.MODULES.TANKS.UNLOCK.translate(new String[0]);
        } else if (!this.tank.getFluid().isEmpty()) {
            str = (String)str + "\n\n" + Localization.MODULES.TANKS.LOCK.translate(new String[0]);
        }
        return str;
    }

    public FluidStack getFluid() {
        return this.tank.getFluid().isEmpty() ? FluidStack.EMPTY : this.tank.getFluid().copy();
    }

    public int getCapacity() {
        return this.getTankSize();
    }

    public boolean isFluidValid(FluidStack stack) {
        return this.tank.isFluidValid(stack);
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        return this.tank.fill(resource, action);
    }

    @Nonnull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        return this.tank.drain(maxDrain, action);
    }

    @Nonnull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        return this.tank.drain(resource, action);
    }

    @Override
    protected void Save(CompoundTag tagCompound, int id) {
        CompoundTag compound = new CompoundTag();
        this.tank.getFluid().writeToNBT(compound);
        tagCompound.m_128365_(this.generateNBTName("Fluid", id), (Tag)compound);
        tagCompound.m_128379_(this.generateNBTName("Locked", id), this.getDw(this.LOCKED).booleanValue());
    }

    @Override
    protected void Load(CompoundTag tagCompound, int id) {
        FluidStack fluidStack = FluidStack.loadFluidStackFromNBT((CompoundTag)tagCompound.m_128469_(this.generateNBTName("Fluid", id)));
        this.tank.setFluid(fluidStack);
        this.updateDw(this.LOCKED, tagCompound.m_128471_(this.generateNBTName("Locked", id)));
        this.updateDw();
    }

    @Override
    public int numberOfDataWatchers() {
        return 3;
    }

    protected void updateDw() {
        this.updateDw(this.FLUID_NAME, this.tank.getFluid().isEmpty() ? "" : this.getFluidName(this.tank.getFluid().getFluid()));
        this.updateDw(this.FLUID_AMOUNT, this.tank.getFluid().isEmpty() ? -1 : this.tank.getFluid().getAmount());
    }

    @Override
    public void initDw() {
        this.FLUID_NAME = this.createDw(EntityDataSerializers.f_135030_);
        this.FLUID_AMOUNT = this.createDw(EntityDataSerializers.f_135028_);
        this.LOCKED = this.createDw(EntityDataSerializers.f_135035_);
        this.registerDw(this.FLUID_NAME, this.tank.getFluid().isEmpty() ? "" : this.getFluidName(this.tank.getFluid().getFluid()));
        this.registerDw(this.FLUID_AMOUNT, this.tank.getFluid().isEmpty() ? -1 : this.tank.getFluid().getAmount());
        this.registerDw(this.LOCKED, false);
    }

    public String getFluidName(Fluid fluid) {
        return Registry.f_122822_.m_7981_((Object)fluid).toString();
    }

    public float getFluidRenderHeight() {
        if (this.tank.getFluid().isEmpty()) {
            return 0.0f;
        }
        return this.tank.getFluidAmount() / this.getTankSize();
    }

    public boolean isCompletelyFilled() {
        return !this.getFluid().isEmpty() && this.getFluidAmount() >= this.getTankSize();
    }

    public boolean isCompletelyEmpty() {
        return this.getFluid().isEmpty() || this.getFluidAmount() == 0;
    }

    public int getFluidAmount() {
        return this.getFluid().isEmpty() ? 0 : this.tank.getFluidAmount();
    }

    @Override
    protected int numberOfPackets() {
        return 1;
    }

    @Override
    protected void receivePacket(int id, byte[] data, Player player) {
        if (!this.getFluid().isEmpty() || this.getDw(this.LOCKED).booleanValue()) {
            this.setLocked(this.getDw(this.LOCKED) == false);
            if (!this.getDw(this.LOCKED).booleanValue() && !this.tank.getFluid().isEmpty() && this.tank.getFluid().getAmount() <= 0) {
                this.tank.setFluid(FluidStack.EMPTY);
                this.updateDw();
            }
        }
    }

    @Override
    public int numberOfGuiData() {
        return 1;
    }

    @Override
    protected void checkGuiData(Object[] info) {
        this.updateGuiData(info, 0, (short)(this.tank.isLocked() ? 1 : 0));
        this.updateDw();
    }

    private void setLocked(boolean val) {
        if (!this.isPlaceholder()) {
            this.updateDw(this.LOCKED, val);
        }
    }

    @Override
    public void mouseClicked(GuiMinecart gui, int x, int y, int button) {
        if (this.inRect(x, y, this.tankBounds)) {
            byte data = (byte)button;
            if (Screen.m_96638_()) {
                data = (byte)(data | 2);
            }
            this.sendPacket(0, data);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawImage(int tankid, AbstractContainerScreen<?> gui, TextureAtlasSprite sprite, int targetX, int targetY, int width, int height) {
        this.drawImage((GuiMinecart)gui, sprite, targetX, targetY, width, height);
    }
}

