/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.modules.realtimers;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import vswe.stevescarts.api.modules.ModuleBase;
import vswe.stevescarts.client.guis.GuiMinecart;
import vswe.stevescarts.containers.slots.SlotBase;
import vswe.stevescarts.containers.slots.SlotMilker;
import vswe.stevescarts.entities.EntityMinecartModular;

public class ModuleMilker
extends ModuleBase {
    int cooldown = 0;
    int milkbuffer = 0;

    public ModuleMilker(EntityMinecartModular cart) {
        super(cart);
    }

    @Override
    public void update() {
        super.update();
        if (this.cooldown <= 0) {
            if (!this.getCart().f_19853_.f_46443_ && this.getCart().hasFuel()) {
                this.generateMilk();
                this.depositeMilk();
            }
            this.cooldown = 20;
        } else {
            --this.cooldown;
        }
    }

    private void depositeMilk() {
        if (this.milkbuffer > 0) {
            FluidStack ret = (FluidStack)FluidUtil.getFluidContained((ItemStack)new ItemStack((ItemLike)Items.f_42455_)).get();
            if (ret != null) {
                ret.setAmount(this.milkbuffer);
                this.milkbuffer -= this.getCart().fill(ret, IFluidHandler.FluidAction.EXECUTE);
            }
            if (this.milkbuffer == 1000) {
                for (int i = 0; i < this.getInventorySize(); ++i) {
                    ItemStack bucket = this.getStack(i);
                    if (bucket.m_41619_() || bucket.m_41720_() != Items.f_42446_) continue;
                    ItemStack milk = new ItemStack((ItemLike)Items.f_42455_);
                    this.getCart().addItemToChest(milk);
                    if (milk.m_41613_() > 0) continue;
                    this.milkbuffer = 0;
                    ItemStack itemStack = bucket;
                    itemStack.m_41774_(1);
                    if (itemStack.m_41613_() > 0) continue;
                    this.setStack(i, ItemStack.f_41583_);
                }
            }
        }
    }

    private void generateMilk() {
        Entity rider;
        if (this.milkbuffer < 1000 && !this.getCart().m_20197_().isEmpty() && (rider = (Entity)this.getCart().m_20197_().get(0)) != null && rider instanceof Cow) {
            this.milkbuffer = Math.min(this.milkbuffer + 75, 1000);
        }
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    protected int getInventoryWidth() {
        return 2;
    }

    @Override
    protected SlotBase getSlot(int slotId, int x, int y) {
        return new SlotMilker(this.getCart(), slotId, 8 + x * 18, 23 + y * 18);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawForeground(PoseStack matrixStack, GuiMinecart gui) {
        this.drawString(matrixStack, gui, this.getModuleName(), 8, 6, 0x404040);
    }

    @Override
    protected void Save(CompoundTag tagCompound, int id) {
        tagCompound.m_128376_(this.generateNBTName("Milk", id), (short)this.milkbuffer);
    }

    @Override
    protected void Load(CompoundTag tagCompound, int id) {
        this.milkbuffer = tagCompound.m_128448_(this.generateNBTName("Milk", id));
    }
}

