/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.modules.realtimers;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.IForgeShearable;
import vswe.stevescarts.api.modules.ModuleBase;
import vswe.stevescarts.entities.EntityMinecartModular;

public class ModuleFlowerRemover
extends ModuleBase {
    private int tick;
    private float bladeangle;
    private float bladespeed = 0.0f;

    public ModuleFlowerRemover(EntityMinecartModular cart) {
        super(cart);
    }

    @Override
    public void update() {
        super.update();
        if (this.getCart().f_19853_.f_46443_) {
            this.bladeangle += this.getBladeSpeed();
            this.bladespeed = this.getCart().hasFuel() ? Math.min(1.0f, this.bladespeed + 0.005f) : Math.max(0.0f, this.bladespeed - 0.005f);
            return;
        }
        if (this.getCart().hasFuel()) {
            if (this.tick >= this.getInterval()) {
                this.tick = 0;
                this.mownTheLawn();
                this.shearEntities();
            } else {
                ++this.tick;
            }
        }
    }

    protected int getInterval() {
        return 70;
    }

    protected int getBlocksOnSide() {
        return 7;
    }

    protected int getBlocksFromLevel() {
        return 1;
    }

    private void mownTheLawn() {
        BlockPos cartPos = this.getCart().getExactPosition();
        BlockPos minPos = cartPos.m_7918_(-this.getBlocksOnSide(), -this.getBlocksFromLevel(), -this.getBlocksOnSide());
        BlockPos maxPos = cartPos.m_7918_(this.getBlocksOnSide(), this.getBlocksFromLevel(), this.getBlocksOnSide());
        ServerLevel serverLevel = (ServerLevel)this.getCart().f_19853_;
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)minPos, (BlockPos)maxPos)) {
            if (!this.isMowable(pos)) continue;
            BlockState state = this.getCart().f_19853_.m_8055_(pos);
            List drops = Block.m_49869_((BlockState)state, (ServerLevel)serverLevel, (BlockPos)pos, (BlockEntity)serverLevel.m_7702_(pos));
            this.addStuff(drops);
            this.getCart().f_19853_.m_7471_(pos, true);
        }
    }

    private void shearEntities() {
        List entities = this.getCart().f_19853_.m_45976_(LivingEntity.class, this.getCart().m_20191_().m_82377_((double)this.getBlocksOnSide(), (double)((float)this.getBlocksFromLevel() + 2.0f), (double)this.getBlocksOnSide()));
        for (LivingEntity target : entities) {
            BlockPos pos;
            IForgeShearable shearable;
            if (!(target instanceof IForgeShearable) || !(shearable = (IForgeShearable)target).isShearable(ItemStack.f_41583_, this.getCart().f_19853_, pos = target.m_20183_())) continue;
            this.addStuff(shearable.onSheared(null, ItemStack.f_41583_, this.getCart().f_19853_, pos, 0));
        }
    }

    private boolean isMowable(BlockPos pos) {
        BlockState blockState = this.getCart().f_19853_.m_8055_(pos);
        return blockState.m_204336_(BlockTags.f_13041_) || blockState.m_204336_(BlockTags.f_198158_);
    }

    private void addStuff(List<ItemStack> stuff) {
        for (ItemStack stack : stuff) {
            this.getCart().addItemToChest(stack);
            if (stack.m_41613_() == 0) continue;
            ItemEntity entityitem = new ItemEntity(this.getCart().f_19853_, (double)this.getCart().getExactPosition().m_123341_(), (double)this.getCart().getExactPosition().m_123342_(), (double)this.getCart().getExactPosition().m_123343_(), stack);
            this.getCart().f_19853_.m_7967_((Entity)entityitem);
        }
    }

    public float getBladeAngle() {
        return this.bladeangle;
    }

    public float getBladeSpeed() {
        return this.bladespeed;
    }
}

