/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.modules.realtimers;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vswe.stevescarts.api.modules.ModuleBase;
import vswe.stevescarts.client.guis.GuiMinecart;
import vswe.stevescarts.containers.slots.SlotBase;
import vswe.stevescarts.containers.slots.SlotFirework;
import vswe.stevescarts.entities.EntityMinecartModular;

public class ModuleFirework
extends ModuleBase {
    private int fireCooldown;

    public ModuleFirework(EntityMinecartModular cart) {
        super(cart);
    }

    @Override
    public void update() {
        if (this.fireCooldown > 0) {
            --this.fireCooldown;
        }
    }

    @Override
    public void activatedByRail(int x, int y, int z, boolean active) {
        if (active && this.fireCooldown == 0 && this.getCart().hasFuel()) {
            this.fire();
            this.fireCooldown = 20;
        }
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    protected SlotBase getSlot(int slotId, int x, int y) {
        return new SlotFirework(this.getCart(), slotId, 8 + x * 18, 16 + y * 18);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawForeground(PoseStack matrixStack, GuiMinecart gui) {
        this.drawString(matrixStack, gui, this.getModuleName(), 8, 6, 0x404040);
    }

    @Override
    public int guiWidth() {
        return 15 + this.getInventoryWidth() * 18;
    }

    @Override
    public int guiHeight() {
        return 20 + this.getInventoryHeight() * 18;
    }

    @Override
    protected int getInventoryWidth() {
        return 8;
    }

    @Override
    protected int getInventoryHeight() {
        return 3;
    }

    public void fire() {
        if (this.getCart().f_19853_.f_46443_) {
            return;
        }
        ItemStack firework = this.getFirework();
        if (!firework.m_41619_()) {
            this.launchFirework(firework);
        }
    }

    @Nonnull
    private ItemStack getFirework() {
        boolean hasGunpowder = false;
        boolean hasPaper = false;
        for (int i = 0; i < this.getInventorySize(); ++i) {
            ItemStack item = this.getStack(i);
            if (item.m_41619_()) continue;
            if (item.m_41720_() == Items.f_42688_) {
                ItemStack firework = item.m_41777_();
                firework.m_41764_(1);
                this.removeItemStack(item, firework.m_41613_(), i);
                return firework;
            }
            if (item.m_41720_() == Items.f_42516_) {
                hasPaper = true;
                continue;
            }
            if (item.m_41720_() != Items.f_42403_) continue;
            hasGunpowder = true;
        }
        if (hasPaper && hasGunpowder) {
            ItemStack charge;
            int chargeCount;
            ItemStack firework2 = new ItemStack((ItemLike)Items.f_42688_);
            int maxGunpowder = this.getCart().f_19796_.m_188503_(3) + 1;
            int countGunpowder = 0;
            boolean removedPaper = false;
            for (int j = 0; j < this.getInventorySize(); ++j) {
                ItemStack item2 = this.getStack(j);
                if (item2.m_41619_()) continue;
                if (item2.m_41720_() == Items.f_42516_ && !removedPaper) {
                    this.removeItemStack(item2, 1, j);
                    removedPaper = true;
                    continue;
                }
                if (item2.m_41720_() != Items.f_42403_ || countGunpowder >= maxGunpowder) continue;
                while (item2.m_41613_() > 0 && countGunpowder < maxGunpowder) {
                    ++countGunpowder;
                    this.removeItemStack(item2, 1, j);
                }
            }
            for (chargeCount = 1; chargeCount < 7 && this.getCart().f_19796_.m_188503_(3 + chargeCount / 3) == 0; ++chargeCount) {
            }
            CompoundTag itemstackNBT = new CompoundTag();
            CompoundTag fireworksNBT = new CompoundTag();
            ListTag explosionsNBT = new ListTag();
            for (int k = 0; k < chargeCount && !(charge = this.getCharge()).m_41619_(); ++k) {
                if (!charge.m_41782_() || !charge.m_41783_().m_128441_("Explosion")) continue;
                explosionsNBT.add((Object)charge.m_41783_().m_128423_("Explosion"));
            }
            fireworksNBT.m_128365_("Explosions", (Tag)explosionsNBT);
            fireworksNBT.m_128344_("Flight", (byte)countGunpowder);
            itemstackNBT.m_128365_("Fireworks", (Tag)fireworksNBT);
            firework2.m_41751_(itemstackNBT);
            return firework2;
        }
        return ItemStack.f_41583_;
    }

    @Nonnull
    private ItemStack getCharge() {
        int[] fade;
        for (int i = 0; i < this.getInventorySize(); ++i) {
            ItemStack item = this.getStack(i);
            if (item.m_41619_() || item.m_41720_() != Items.f_42689_) continue;
            ItemStack charge = item.m_41777_();
            charge.m_41764_(1);
            this.removeItemStack(item, charge.m_41613_(), i);
            return charge;
        }
        ItemStack charge2 = new ItemStack((ItemLike)Items.f_42689_);
        CompoundTag itemNBT = new CompoundTag();
        CompoundTag explosionNBT = new CompoundTag();
        byte type = 0;
        boolean removedGunpowder = false;
        boolean canHasTrail = this.getCart().f_19796_.m_188503_(16) == 0;
        boolean canHasFlicker = this.getCart().f_19796_.m_188503_(8) == 0;
        boolean canHasModifier = this.getCart().f_19796_.m_188503_(4) == 0;
        byte modifierType = (byte)(this.getCart().f_19796_.m_188503_(4) + 1);
        boolean removedModifier = false;
        boolean removedDiamond = false;
        boolean removedGlow = false;
        for (int j = 0; j < this.getInventorySize(); ++j) {
            ItemStack item2 = this.getStack(j);
            if (item2 == null) continue;
            if (item2.m_41720_() == Items.f_42403_ && !removedGunpowder) {
                this.removeItemStack(item2, 1, j);
                removedGunpowder = true;
                continue;
            }
            if (item2.m_41720_() == Items.f_42525_ && canHasFlicker && !removedGlow) {
                this.removeItemStack(item2, 1, j);
                removedGlow = true;
                explosionNBT.m_128379_("Flicker", true);
                continue;
            }
            if (item2.m_41720_() == Items.f_42415_ && canHasTrail && !removedDiamond) {
                this.removeItemStack(item2, 1, j);
                removedDiamond = true;
                explosionNBT.m_128379_("Trail", true);
                continue;
            }
            if (!canHasModifier || removedModifier || !(item2.m_41720_() == Items.f_42689_ && modifierType == 1 || item2.m_41720_() == Items.f_42587_ && modifierType == 2 || item2.m_41720_() == Items.f_42678_ && modifierType == 3) && (item2.m_41720_() != Items.f_42402_ || modifierType != 4)) continue;
            this.removeItemStack(item2, 1, j);
            removedModifier = true;
            type = modifierType;
        }
        int[] colors = this.generateColors(type != 0 ? 7 : 8);
        if (colors == null) {
            return null;
        }
        explosionNBT.m_128385_("Colors", colors);
        if (this.getCart().f_19796_.m_188503_(4) == 0 && (fade = this.generateColors(8)) != null) {
            explosionNBT.m_128385_("FadeColors", fade);
        }
        explosionNBT.m_128344_("Type", type);
        itemNBT.m_128365_("Explosion", (Tag)explosionNBT);
        charge2.m_41751_(itemNBT);
        return charge2;
    }

    private int[] generateColors(int maxColorCount) {
        int colorCount;
        int[] maxColors = new int[16];
        int[] currentColors = new int[16];
        for (int i = 0; i < this.getInventorySize(); ++i) {
            ItemStack item = this.getStack(i);
            if (!item.m_41619_() && item.m_41720_() != Items.f_42498_) continue;
        }
        for (colorCount = this.getCart().f_19796_.m_188503_(2) + 1; colorCount <= maxColorCount - 2 && this.getCart().f_19796_.m_188503_(2) == 0; colorCount += 2) {
        }
        ArrayList<Integer> colorPointers = new ArrayList<Integer>();
        for (int j = 0; j < 16; ++j) {
            if (maxColors[j] <= 0) continue;
            colorPointers.add(j);
        }
        if (colorPointers.size() == 0) {
            return null;
        }
        ArrayList<Integer> usedColors = new ArrayList<Integer>();
        while (colorCount > 0 && colorPointers.size() > 0) {
            int n2;
            int n;
            int pointerId = this.getCart().f_19796_.m_188503_(colorPointers.size());
            int colorId = (Integer)colorPointers.get(pointerId);
            int[] array2 = currentColors;
            int n3 = n = colorId;
            array2[n3] = array2[n3] + 1;
            int[] array3 = maxColors;
            int n4 = n2 = colorId;
            array3[n4] = array3[n4] - 1;
            if (array3[n4] <= 0) {
                colorPointers.remove(pointerId);
            }
            usedColors.add(colorId);
            --colorCount;
        }
        int[] colors = new int[usedColors.size()];
        for (int k = 0; k < colors.length; ++k) {
        }
        return colors;
    }

    private void removeItemStack(@Nonnull ItemStack item, int count, int id) {
        if (!this.getCart().hasCreativeSupplies()) {
            item.m_41774_(count);
            if (item.m_41613_() <= 0) {
                this.setStack(id, ItemStack.f_41583_);
            }
        }
    }

    private void launchFirework(@Nonnull ItemStack firework) {
        FireworkRocketEntity rocket = new FireworkRocketEntity(this.getCart().f_19853_, (double)this.getCart().m_20183_().m_123341_(), (double)this.getCart().m_20183_().m_123342_() + 1.0, (double)this.getCart().m_20183_().m_123343_(), firework);
        this.getCart().f_19853_.m_7967_((Entity)rocket);
    }
}

