/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.modules.realtimers;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vswe.stevescarts.api.modules.ModuleBase;
import vswe.stevescarts.client.guis.GuiMinecart;
import vswe.stevescarts.entities.EntityMinecartModular;
import vswe.stevescarts.helpers.Localization;
import vswe.stevescarts.helpers.ResourceHelper;

public class ModuleExperience
extends ModuleBase {
    private static final int MAX_EXPERIENCE_AMOUNT = 1500;
    private EntityDataAccessor<Integer> EXPERIENCE;

    public ModuleExperience(EntityMinecartModular cart) {
        super(cart);
    }

    @Override
    public void update() {
        if (this.getCart().f_19853_.f_46443_) {
            return;
        }
        List list = this.getCart().f_19853_.m_45933_((Entity)this.getCart(), this.getCart().m_20191_().m_82377_(3.0, 1.0, 3.0));
        for (Entity entity : list) {
            if (!(entity instanceof ExperienceOrb)) continue;
            this.addExperience(((ExperienceOrb)entity).m_20801_());
            if (this.getExperienceAmount() > 1500) {
                this.setExperienceAmount(1500);
                continue;
            }
            entity.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    private void addExperience(int amount) {
        int val = this.getExperienceAmount();
        this.setExperienceAmount(val += amount);
    }

    public int getExperienceAmount() {
        int val = this.getDw(this.EXPERIENCE);
        if (val < 0) {
            return val + 256;
        }
        return val;
    }

    private void setExperienceAmount(int val) {
        if (!this.isPlaceholder()) {
            this.updateDw(this.EXPERIENCE, val);
        }
    }

    @Override
    public int numberOfDataWatchers() {
        return 1;
    }

    @Override
    public void initDw() {
        this.EXPERIENCE = this.createDw(EntityDataSerializers.f_135028_);
        this.registerDw(this.EXPERIENCE, 0);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawMouseOver(PoseStack matrixStack, GuiMinecart gui, int x, int y) {
        this.drawStringOnMouseOver(matrixStack, gui, Localization.MODULES.ATTACHMENTS.EXPERIENCE_LEVEL.translate(String.valueOf(this.getExperienceAmount()), String.valueOf(1500)) + "\n" + Localization.MODULES.ATTACHMENTS.EXPERIENCE_EXTRACT.translate(new String[0]) + "\n" + Localization.MODULES.ATTACHMENTS.EXPERIENCE_EXTRACT_ALL.translate(new String[0]) + "\n" + Localization.MODULES.ATTACHMENTS.EXPERIENCE_PLAYER_LEVEL.translate(String.valueOf(this.getClientPlayer().f_36078_)), x, y, this.getContainerRect());
    }

    @Override
    public int numberOfGuiData() {
        return 1;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawForeground(PoseStack matrixStack, GuiMinecart gui) {
        this.drawString(matrixStack, gui, Localization.MODULES.ATTACHMENTS.EXPERIENCE.translate(new String[0]), 8, 6, 0x404040);
    }

    private int[] getContainerRect() {
        return new int[]{10, 15, 26, 65};
    }

    private int[] getContentRect(float part) {
        int[] cont = this.getContainerRect();
        int normalHeight = cont[3] - 4;
        int currentHeight = (int)((float)normalHeight * part);
        return new int[]{cont[0] + 2, cont[1] + 2 + normalHeight - currentHeight, cont[2] - 4, currentHeight, normalHeight};
    }

    @OnlyIn(value=Dist.CLIENT)
    private void drawContent(PoseStack matrixStack, GuiMinecart gui, int x, int y, int id) {
        int lowerLevel = id * 1500 / 3;
        int currentLevel = this.getExperienceAmount() - lowerLevel;
        float part = 3.0f * (float)currentLevel / 1500.0f;
        if (part > 1.0f) {
            part = 1.0f;
        }
        int[] content = this.getContentRect(part);
        this.drawImage(matrixStack, gui, content, 4 + content[2] * (id + 1), content[4] - content[3]);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawBackground(PoseStack matrixStack, GuiMinecart gui, int x, int y) {
        ResourceHelper.bindResource("/gui/experience.png");
        for (int i = 0; i < 3; ++i) {
            this.drawContent(matrixStack, gui, x, y, i);
        }
        this.drawImage(matrixStack, gui, this.getContainerRect(), 0, this.inRect(x, y, this.getContainerRect()) ? 65 : 0);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void mouseClicked(GuiMinecart gui, int x, int y, int button) {
        if (this.inRect(x, y, this.getContainerRect())) {
            this.sendPacket(0, (byte)(Screen.m_96638_() ? 1 : 0));
        }
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public boolean hasSlots() {
        return false;
    }

    @Override
    public int guiWidth() {
        return 70;
    }

    @Override
    public int guiHeight() {
        return 84;
    }

    @Override
    protected int numberOfPackets() {
        return 1;
    }

    @Override
    protected void receivePacket(int id, byte[] data, Player player) {
        int give = data[0] == 1 ? this.getExperienceAmount() : Math.min(this.getExperienceAmount(), 50);
        player.m_6756_(give);
        this.setExperienceAmount(this.getExperienceAmount() - give);
    }

    @Override
    protected void Load(CompoundTag tagCompound, int id) {
        this.setExperienceAmount(tagCompound.m_128448_(this.generateNBTName("Experience", id)));
    }

    @Override
    protected void Save(CompoundTag tagCompound, int id) {
        tagCompound.m_128376_(this.generateNBTName("Experience", id), (short)this.getExperienceAmount());
    }
}

