/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.modules.realtimers;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vswe.stevescarts.api.modules.ModuleBase;
import vswe.stevescarts.api.modules.interfaces.ILeverModule;
import vswe.stevescarts.api.modules.template.ModuleEngine;
import vswe.stevescarts.client.guis.GuiMinecart;
import vswe.stevescarts.entities.EntityMinecartModular;
import vswe.stevescarts.helpers.Localization;
import vswe.stevescarts.helpers.ResourceHelper;

public class ModuleAdvControl
extends ModuleBase
implements ILeverModule {
    private byte[] engineInformation;
    private int tripPacketTimer;
    private int enginePacketTimer;
    private byte keyinformation;
    private double lastPosX;
    private double lastPosY;
    private double lastPosZ;
    private boolean first = true;
    private int speedChangeCooldown;
    private boolean lastBackKey;
    private double odo;
    private double trip;
    private int[] buttonRect = new int[]{15, 20, 24, 12};
    private EntityDataAccessor<Integer> SPEED;

    public ModuleAdvControl(EntityMinecartModular cart) {
        super(cart);
    }

    @Override
    public boolean hasSlots() {
        return false;
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public int guiWidth() {
        return 90;
    }

    @Override
    public int guiHeight() {
        return 35;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderOverlay(PoseStack matrixStack, Minecraft minecraft) {
        ResourceHelper.bindResource("/gui/drive.png");
        if (this.engineInformation != null) {
            for (int i = 0; i < this.getCart().getEngines().size(); ++i) {
                this.drawImage(5, i * 15, 0, 0, 66, 15);
                int upperBarLength = this.engineInformation[i * 2] & 0x3F;
                int lowerBarLength = this.engineInformation[i * 2 + 1] & 0x3F;
                ModuleEngine engine = this.getCart().getEngines().get(i);
                float[] rgb = engine.getGuiBarColor();
                RenderSystem.m_157429_((float)rgb[0], (float)rgb[1], (float)rgb[2], (float)1.0f);
                this.drawImage(7, i * 15 + 2, 66, 0, upperBarLength, 5);
                this.drawImage(7, i * 15 + 2 + 6, 66, 6, lowerBarLength, 5);
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.drawImage(5, i * 15, 66 + engine.getPriority() * 7, 11, 7, 15);
            }
        }
        int enginesEndAt = this.getCart().getEngines().size() * 15;
        this.drawImage(5, enginesEndAt, 0, 15, 32, 32);
        if (minecraft.f_91066_.f_92085_.m_90857_()) {
            this.drawImage(15, enginesEndAt + 5, 42, 20, 12, 6);
        } else if (minecraft.f_91066_.f_92086_.m_90857_()) {
            this.drawImage(7, enginesEndAt + 13, 34, 28, 6, 12);
        } else if (minecraft.f_91066_.f_92088_.m_90857_()) {
            this.drawImage(29, enginesEndAt + 13, 56, 28, 6, 12);
        }
        int speedGraphicHeight = this.getSpeedSetting() * 2;
        this.drawImage(14, enginesEndAt + 13 + 12 - speedGraphicHeight, 41, 40 - speedGraphicHeight, 14, speedGraphicHeight);
        this.drawImage(0, 0, 0, 67, 5, 130);
        this.drawImage(1, 1 + (256 - this.getCart().y()) / 2, 5, 67, 5, 1);
        this.drawImage(5, enginesEndAt + 32, 0, 47, 32, 20);
        this.drawImage(5, enginesEndAt + 52, 0, 47, 32, 20);
        this.drawImage(5, enginesEndAt + 72, 0, 47, 32, 20);
        minecraft.f_91062_.m_92883_(matrixStack, Localization.MODULES.ATTACHMENTS.ODO.translate(new String[0]), 7.0f, (float)(enginesEndAt + 52 + 2), 0x909090);
        minecraft.f_91062_.m_92883_(matrixStack, this.distToString(this.odo), 7.0f, (float)(enginesEndAt + 52 + 11), 0x909090);
        minecraft.f_91062_.m_92883_(matrixStack, Localization.MODULES.ATTACHMENTS.TRIP.translate(new String[0]), 7.0f, (float)(enginesEndAt + 52 + 22), 0x909090);
        minecraft.f_91062_.m_92883_(matrixStack, this.distToString(this.trip), 7.0f, (float)(enginesEndAt + 52 + 31), 0x909090);
        this.drawItem(new ItemStack((ItemLike)Items.f_42524_), 5, enginesEndAt + 32 + 3);
        this.drawItem(new ItemStack((ItemLike)Items.f_42522_), 21, enginesEndAt + 32 + 3);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawItem(ItemStack icon, int targetX, int targetY) {
        ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
        itemRenderer.m_174229_((LivingEntity)this.getClientPlayer(), icon, targetX, targetY, targetX + targetX * this.guiWidth());
    }

    private String distToString(double dist) {
        int i = 0;
        while (dist >= 1000.0) {
            dist /= 1000.0;
            ++i;
        }
        int val = dist >= 100.0 ? 1 : (dist >= 10.0 ? 10 : 100);
        double d = Math.round(dist * (double)val) / (long)val;
        Object s = d == (double)((int)d) ? String.valueOf((int)d) : String.valueOf(d);
        while (((String)s).length() < (((String)s).indexOf(46) != -1 ? 4 : 3)) {
            if (((String)s).indexOf(46) != -1) {
                s = (String)s + "0";
                continue;
            }
            s = (String)s + ".0";
        }
        s = (String)s + Localization.MODULES.ATTACHMENTS.DISTANCES.translate(String.valueOf(i));
        return s;
    }

    @Override
    public ModuleBase.RAILDIRECTION getSpecialRailDirection(BlockPos pos) {
        if (this.isForwardKeyDown()) {
            return ModuleBase.RAILDIRECTION.FORWARD;
        }
        if (this.isLeftKeyDown()) {
            return ModuleBase.RAILDIRECTION.LEFT;
        }
        if (this.isRightKeyDown()) {
            return ModuleBase.RAILDIRECTION.RIGHT;
        }
        return ModuleBase.RAILDIRECTION.DEFAULT;
    }

    @Override
    protected void receivePacket(int id, byte[] data, Player player) {
        if (id == 0) {
            this.engineInformation = data;
        } else if (id == 1) {
            if (this.getCart().getCartRider() != null && this.getCart().getCartRider() instanceof Player && this.getCart().getCartRider() == player) {
                this.keyinformation = data[0];
            }
        } else if (id == 2) {
            int intOdo = 0;
            int intTrip = 0;
            for (int i = 0; i < 4; ++i) {
                int temp = data[i];
                if (temp < 0) {
                    temp += 256;
                }
                intOdo |= temp << i * 8;
                temp = data[i + 4];
                if (temp < 0) {
                    temp += 256;
                }
                intTrip |= temp << i * 8;
            }
            this.odo = intOdo;
            this.trip = intTrip;
        } else if (id == 3) {
            this.trip = 0.0;
            this.tripPacketTimer = 0;
        }
    }

    @Override
    public void update() {
        super.update();
        if (!this.getCart().f_19853_.f_46443_ && this.getCart().getCartRider() != null && this.getCart().getCartRider() instanceof Player) {
            if (this.enginePacketTimer == 0) {
                this.sendEnginePacket((Player)this.getCart().getCartRider());
                this.enginePacketTimer = 15;
            } else {
                --this.enginePacketTimer;
            }
            if (this.tripPacketTimer == 0) {
                this.sendTripPacket((Player)this.getCart().getCartRider());
                this.tripPacketTimer = 500;
            } else {
                --this.tripPacketTimer;
            }
        } else {
            this.enginePacketTimer = 0;
            this.tripPacketTimer = 0;
        }
        if (this.getCart().f_19853_.f_46443_) {
            this.encodeKeys();
        }
        if (!this.lastBackKey && this.isBackKeyDown()) {
            this.turnback();
        }
        this.lastBackKey = this.isBackKeyDown();
        if (!this.getCart().f_19853_.f_46443_) {
            if (this.speedChangeCooldown == 0) {
                if (!this.isJumpKeyDown() || !this.isControlKeyDown()) {
                    if (this.isJumpKeyDown()) {
                        this.setSpeedSetting(this.getSpeedSetting() + 1);
                        this.speedChangeCooldown = 8;
                    } else if (this.isControlKeyDown()) {
                        this.setSpeedSetting(this.getSpeedSetting() - 1);
                        this.speedChangeCooldown = 8;
                    } else {
                        this.speedChangeCooldown = 0;
                    }
                }
            } else {
                --this.speedChangeCooldown;
            }
            if (this.isForwardKeyDown() && this.isLeftKeyDown() && this.isRightKeyDown() && this.getCart().getCartRider() != null && this.getCart().getCartRider() instanceof Player) {
                this.getCart().getCartRider().m_20329_((Entity)this.getCart());
                this.keyinformation = 0;
            }
        }
        double x = (double)this.getCart().x() - this.lastPosX;
        double y = (double)this.getCart().y() - this.lastPosY;
        double z = (double)this.getCart().z() - this.lastPosZ;
        this.lastPosX = this.getCart().x();
        this.lastPosY = this.getCart().y();
        this.lastPosZ = this.getCart().z();
        double dist = Math.sqrt(x * x + y * y + z * z);
        if (!this.first) {
            this.odo += dist;
            this.trip += dist;
        } else {
            this.first = false;
        }
    }

    @Override
    public double getPushFactor() {
        switch (this.getSpeedSetting()) {
            case 1: {
                return 0.01;
            }
            case 2: {
                return 0.03;
            }
            case 3: {
                return 0.05;
            }
            case 4: {
                return 0.07;
            }
            case 5: {
                return 0.09;
            }
            case 6: {
                return 0.11;
            }
        }
        return super.getPushFactor();
    }

    private void encodeKeys() {
        if (this.getCart().getCartRider() != null && this.getCart().getCartRider() instanceof Player && this.getCart().getCartRider() == this.getClientPlayer()) {
            Minecraft minecraft = Minecraft.m_91087_();
            byte oldVal = this.keyinformation;
            this.keyinformation = 0;
            this.keyinformation = (byte)(this.keyinformation | (byte)((minecraft.f_91066_.f_92085_.m_90857_() ? 1 : 0) << 0));
            this.keyinformation = (byte)(this.keyinformation | (byte)((minecraft.f_91066_.f_92086_.m_90857_() ? 1 : 0) << 1));
            this.keyinformation = (byte)(this.keyinformation | (byte)((minecraft.f_91066_.f_92088_.m_90857_() ? 1 : 0) << 2));
            this.keyinformation = (byte)(this.keyinformation | (byte)((minecraft.f_91066_.f_92087_.m_90857_() ? 1 : 0) << 3));
            this.keyinformation = (byte)(this.keyinformation | (byte)((minecraft.f_91066_.f_92089_.m_90857_() ? 1 : 0) << 4));
            this.keyinformation = (byte)(this.keyinformation | (byte)((minecraft.f_91066_.f_92091_.m_90857_() ? 1 : 0) << 5));
            if (oldVal != this.keyinformation) {
                this.sendPacket(1, new byte[]{this.keyinformation});
            }
        }
    }

    private boolean isForwardKeyDown() {
        return (this.keyinformation & 1) != 0;
    }

    private boolean isLeftKeyDown() {
        return (this.keyinformation & 2) != 0;
    }

    private boolean isRightKeyDown() {
        return (this.keyinformation & 4) != 0;
    }

    private boolean isBackKeyDown() {
        return (this.keyinformation & 8) != 0;
    }

    private boolean isJumpKeyDown() {
        return (this.keyinformation & 0x10) != 0;
    }

    private boolean isControlKeyDown() {
        return (this.keyinformation & 0x20) != 0;
    }

    private void sendTripPacket(Player player) {
        byte[] data = new byte[8];
        int intOdo = (int)this.odo;
        int intTrip = (int)this.trip;
        for (int i = 0; i < 4; ++i) {
            data[i] = (byte)((intOdo & 255 << i * 8) >> i * 8);
            data[i + 4] = (byte)((intTrip & 255 << i * 8) >> i * 8);
        }
        this.sendPacket(2, data, player);
    }

    private void sendEnginePacket(Player player) {
        int engineCount = this.getCart().getEngines().size();
        byte[] data = new byte[engineCount * 2];
        for (int i = 0; i < this.getCart().getEngines().size(); ++i) {
            ModuleEngine engine = this.getCart().getEngines().get(i);
            int totalfuel = engine.getTotalFuel();
            int fuelInTopBar = 20000;
            int maxBarLength = 62;
            float percentage = (float)(totalfuel % fuelInTopBar) / (float)fuelInTopBar;
            int upperBarLength = (int)((float)maxBarLength * percentage);
            int lowerBarLength = totalfuel / fuelInTopBar;
            if (lowerBarLength > maxBarLength) {
                lowerBarLength = maxBarLength;
            }
            data[i * 2] = (byte)(upperBarLength & 0x3F);
            data[i * 2 + 1] = (byte)(lowerBarLength & 0x3F);
        }
        this.sendPacket(0, data, player);
    }

    @Override
    public int numberOfPackets() {
        return 4;
    }

    private void setSpeedSetting(int val) {
        if (val < 0 || val > 6) {
            return;
        }
        this.updateDw(this.SPEED, val);
    }

    private int getSpeedSetting() {
        if (this.isPlaceholder()) {
            return 1;
        }
        return this.getDw(this.SPEED);
    }

    @Override
    public int numberOfDataWatchers() {
        return 1;
    }

    @Override
    public void initDw() {
        this.SPEED = this.createDw(EntityDataSerializers.f_135028_);
        this.registerDw(this.SPEED, 0);
    }

    @Override
    public boolean stopEngines() {
        return this.getSpeedSetting() == 0;
    }

    @Override
    public int getConsumption(boolean isMoving) {
        if (!isMoving) {
            return super.getConsumption(isMoving);
        }
        switch (this.getSpeedSetting()) {
            case 4: {
                return 1;
            }
            case 5: {
                return 3;
            }
            case 6: {
                return 5;
            }
        }
        return super.getConsumption(isMoving);
    }

    @Override
    public void drawBackground(PoseStack matrixStack, GuiMinecart gui, int x, int y) {
        ResourceHelper.bindResource("/gui/advlever.png");
        if (this.inRect(x, y, this.buttonRect)) {
            this.drawImage(matrixStack, gui, this.buttonRect, 0, this.buttonRect[3]);
        } else {
            this.drawImage(matrixStack, gui, this.buttonRect, 0, 0);
        }
    }

    @Override
    public void drawMouseOver(PoseStack matrixStack, GuiMinecart gui, int x, int y) {
        this.drawStringOnMouseOver(matrixStack, gui, Localization.MODULES.ATTACHMENTS.CONTROL_RESET.translate(new String[0]), x, y, this.buttonRect);
    }

    @Override
    public void mouseClicked(GuiMinecart gui, int x, int y, int button) {
        if (button == 0 && this.inRect(x, y, this.buttonRect)) {
            this.sendPacket(3);
        }
    }

    @Override
    public void drawForeground(PoseStack matrixStack, GuiMinecart gui) {
        this.drawString(matrixStack, gui, Localization.MODULES.ATTACHMENTS.CONTROL_SYSTEM.translate(new String[0]), 8, 6, 0x404040);
    }

    @Override
    protected void Save(CompoundTag tagCompound, int id) {
        tagCompound.m_128344_(this.generateNBTName("Speed", id), (byte)this.getSpeedSetting());
        tagCompound.m_128347_(this.generateNBTName("ODO", id), this.odo);
        tagCompound.m_128347_(this.generateNBTName("TRIP", id), this.trip);
    }

    @Override
    protected void Load(CompoundTag tagCompound, int id) {
        this.setSpeedSetting(tagCompound.m_128445_(this.generateNBTName("Speed", id)));
        this.odo = tagCompound.m_128459_(this.generateNBTName("ODO", id));
        this.trip = tagCompound.m_128459_(this.generateNBTName("TRIP", id));
    }

    public float getWheelAngle() {
        if (!this.isForwardKeyDown()) {
            if (this.isLeftKeyDown()) {
                return 0.3926991f;
            }
            if (this.isRightKeyDown()) {
                return -0.3926991f;
            }
        }
        return 0.0f;
    }

    @Override
    public float getLeverState() {
        if (this.isPlaceholder()) {
            return 0.0f;
        }
        return (float)this.getSpeedSetting() / 6.0f;
    }

    @Override
    public void postUpdate() {
        if (!this.getCart().f_19853_.f_46443_ || this.getCart().getCartRider() == null || !(this.getCart().getCartRider() instanceof Player) || this.getCart().getCartRider() == this.getClientPlayer()) {
            // empty if block
        }
    }
}

