/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.modules.addons;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Set;
import javax.annotation.Nullable;
import net.creeperhost.polylib.helpers.RecipeHelper;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import vswe.stevescarts.client.guis.GuiMinecart;
import vswe.stevescarts.containers.slots.SlotBase;
import vswe.stevescarts.containers.slots.SlotCartCrafterResult;
import vswe.stevescarts.containers.slots.SlotFurnaceInput;
import vswe.stevescarts.entities.EntityMinecartModular;
import vswe.stevescarts.modules.addons.ModuleRecipe;

public class ModuleSmelter
extends ModuleRecipe {
    private int energyBuffer;
    private int cooldown = 0;

    public ModuleSmelter(EntityMinecartModular cart) {
        super(cart);
    }

    @Override
    public void update() {
        if (this.getCart().f_19853_.f_46443_) {
            return;
        }
        if (this.getCart().hasFuelForModule() && this.energyBuffer < 10) {
            ++this.energyBuffer;
        }
        if (this.cooldown <= 0) {
            if (this.energyBuffer == 10) {
                ItemStack recipe = this.getStack(0);
                ItemStack result = ItemStack.f_41583_;
                if (!recipe.m_41619_() && this.getSmeltingResult() != null) {
                    result = this.getSmeltingResult();
                }
                if (!result.m_41619_()) {
                    result = result.m_41777_();
                }
                if (!result.m_41619_() && this.getCart().getModules() != null) {
                    this.prepareLists();
                    if (this.canCraftMoreOfResult(result)) {
                        ItemStack item;
                        int i;
                        NonNullList originals = NonNullList.m_122779_();
                        for (i = 0; i < this.allTheSlots.size(); ++i) {
                            item = ((SlotBase)((Object)this.allTheSlots.get(i))).m_7993_();
                            originals.add((Object)(item.m_41619_() ? ItemStack.f_41583_ : item.m_41777_()));
                        }
                        for (i = 0; i < this.inputSlots.size(); ++i) {
                            item = ((SlotBase)((Object)this.inputSlots.get(i))).m_7993_();
                            if (item.m_41619_() || !item.m_41656_(recipe) || !ItemStack.m_41746_((ItemStack)item, (ItemStack)recipe)) continue;
                            ItemStack itemStack = item;
                            itemStack.m_41774_(1);
                            if (itemStack.m_41613_() <= 0) {
                                ((SlotBase)((Object)this.inputSlots.get(i))).m_5852_(ItemStack.f_41583_);
                            }
                            this.getCart().addItemToChest(result, this.getValidSlot(), null);
                            if (result.m_41613_() != 0) {
                                for (int j = 0; j < this.allTheSlots.size(); ++j) {
                                    ((SlotBase)((Object)this.allTheSlots.get(j))).m_5852_((ItemStack)originals.get(j));
                                }
                                break;
                            }
                            this.energyBuffer = 0;
                            break;
                        }
                    }
                }
            }
            this.cooldown = 40;
        } else {
            --this.cooldown;
        }
    }

    @Nullable
    public SmeltingRecipe getRecipeSmelting() {
        Set recipes = RecipeHelper.findRecipesByType((RecipeType)RecipeType.f_44108_, (Level)this.getCart().f_19853_);
        for (Recipe iRecipe : recipes) {
            SmeltingRecipe recipe = (SmeltingRecipe)iRecipe;
            NonNullList stacks = NonNullList.m_122780_((int)1, (Object)ItemStack.f_41583_);
            stacks.set(0, (Object)this.getStack(0));
            ItemStackHandler iItemHandlerModifiable = new ItemStackHandler(stacks);
            if (!recipe.m_5818_((Container)new RecipeWrapper((IItemHandlerModifiable)iItemHandlerModifiable), this.getCart().f_19853_)) continue;
            return recipe;
        }
        return null;
    }

    @Nullable
    public ItemStack getSmeltingResult() {
        SmeltingRecipe recipe = this.getRecipeSmelting();
        if (recipe != null) {
            return recipe.m_8043_().m_41777_();
        }
        return ItemStack.f_41583_;
    }

    @Override
    public int getConsumption(boolean isMoving) {
        if (this.energyBuffer < 10) {
            return 15;
        }
        return super.getConsumption(isMoving);
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    protected int getInventoryWidth() {
        return 1;
    }

    @Override
    protected int getInventoryHeight() {
        return 2;
    }

    @Override
    protected SlotBase getSlot(int slotId, int x, int y) {
        if (y == 0) {
            return new SlotFurnaceInput(this.getCart(), slotId, 10 + 18 * x, 15 + 18 * y);
        }
        return new SlotCartCrafterResult(this.getCart(), slotId, 10 + 18 * x, 15 + 18 * y);
    }

    @Override
    public int numberOfGuiData() {
        return super.numberOfGuiData() + 1;
    }

    @Override
    protected void checkGuiData(Object[] info) {
        super.checkGuiData(info);
        this.updateGuiData(info, super.numberOfGuiData() + 0, (short)this.energyBuffer);
    }

    @Override
    public void receiveGuiData(int id, short data) {
        super.receiveGuiData(id, data);
        if (id == super.numberOfGuiData() + 0) {
            this.energyBuffer = data;
        }
    }

    @Override
    public void onInventoryChanged() {
        super.onInventoryChanged();
        if (this.getCart().f_19853_.f_46443_) {
            if (!this.getStack(0).m_41619_() && !this.getSmeltingResult().m_41619_()) {
                this.setStack(1, this.getSmeltingResult());
            } else {
                this.setStack(1, ItemStack.f_41583_);
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawForeground(PoseStack matrixStack, GuiMinecart gui) {
        super.drawForeground(matrixStack, gui);
        this.drawString(matrixStack, gui, this.getModuleName(), 8, 6, 0x404040);
    }

    @Override
    public int guiWidth() {
        return this.canUseAdvancedFeatures() ? 100 : 45;
    }

    @Override
    protected int[] getArea() {
        return new int[]{32, 25, 16, 16};
    }

    @Override
    protected boolean canUseAdvancedFeatures() {
        return false;
    }

    @Override
    protected void Load(CompoundTag tagCompound, int id) {
        super.Load(tagCompound, id);
        this.energyBuffer = tagCompound.m_128445_(this.generateNBTName("Buffer", id));
    }

    @Override
    protected void Save(CompoundTag tagCompound, int id) {
        super.Save(tagCompound, id);
        tagCompound.m_128344_(this.generateNBTName("Buffer", id), (byte)this.energyBuffer);
    }

    @Override
    protected int getLimitStartX() {
        return 55;
    }

    @Override
    protected int getLimitStartY() {
        return 15;
    }
}

