/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.modules.addons;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import vswe.stevescarts.client.guis.GuiMinecart;
import vswe.stevescarts.containers.slots.SlotBase;
import vswe.stevescarts.containers.slots.SlotEnchantment;
import vswe.stevescarts.entities.EntityMinecartModular;
import vswe.stevescarts.helpers.EnchantmentData;
import vswe.stevescarts.helpers.Localization;
import vswe.stevescarts.helpers.ModularEnchantments;
import vswe.stevescarts.helpers.ResourceHelper;
import vswe.stevescarts.modules.addons.ModuleAddon;
import vswe.stevescarts.network.DataSerializers;

public class ModuleEnchants
extends ModuleAddon {
    private final EntityDataAccessor<EnchantmentData> ENCHANT_0 = this.createDw(DataSerializers.ENCHANT_DATA);
    private final EntityDataAccessor<EnchantmentData> ENCHANT_1 = this.createDw(DataSerializers.ENCHANT_DATA);
    private final EntityDataAccessor<EnchantmentData> ENCHANT_2 = this.createDw(DataSerializers.ENCHANT_DATA);
    private final ArrayList<ModularEnchantments.EnchantmentType> enabledTypes = new ArrayList();

    public ModuleEnchants(EntityMinecartModular cart) {
        super(cart);
    }

    @Override
    public void initDw() {
        this.registerDw(this.ENCHANT_0, new EnchantmentData(null));
        this.registerDw(this.ENCHANT_1, new EnchantmentData(null));
        this.registerDw(this.ENCHANT_2, new EnchantmentData(null));
    }

    @Override
    public int numberOfDataWatchers() {
        return 3;
    }

    public EnchantmentData getEnchant(int index) {
        return this.getDw(index == 0 ? this.ENCHANT_0 : (index == 1 ? this.ENCHANT_1 : this.ENCHANT_2));
    }

    public void setEnchant(int index, EnchantmentData data) {
        this.updateDw(index == 0 ? this.ENCHANT_0 : (index == 1 ? this.ENCHANT_1 : this.ENCHANT_2), data);
    }

    public int getFortuneLevel() {
        if (this.useSilkTouch()) {
            return 0;
        }
        return this.getEnchantLevel(Enchantments.f_44987_);
    }

    public boolean useSilkTouch() {
        return false;
    }

    public int getUnbreakingLevel() {
        return this.getEnchantLevel(Enchantments.f_44986_);
    }

    public int getEfficiencyLevel() {
        return this.getEnchantLevel(Enchantments.f_44984_);
    }

    public int getPowerLevel() {
        return this.getEnchantLevel(Enchantments.f_44988_);
    }

    public int getPunchLevel() {
        return this.getEnchantLevel(Enchantments.f_44989_);
    }

    public boolean useFlame() {
        return this.getEnchantLevel(Enchantments.f_44990_) > 0;
    }

    public boolean useInfinity() {
        return this.getEnchantLevel(Enchantments.f_44952_) > 0;
    }

    private int getEnchantLevel(Enchantment enchant) {
        for (int i = 0; i < 3; ++i) {
            EnchantmentData test = this.getEnchant(i);
            if (test.getEnchant() == null || test.getEnchant() != enchant) continue;
            return test.getLevel();
        }
        return 0;
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public void drawForeground(PoseStack matrixStack, GuiMinecart gui) {
        this.drawString(matrixStack, gui, this.getModuleName(), 8, 6, 0x404040);
    }

    @Override
    protected int getInventoryWidth() {
        return 1;
    }

    @Override
    protected int getInventoryHeight() {
        return 3;
    }

    @Override
    protected SlotBase getSlot(int slotId, int x, int y) {
        return new SlotEnchantment(this.getCart(), this.enabledTypes, slotId, 8, 14 + y * 20);
    }

    @Override
    public void update() {
        super.update();
        if (this.getCart().f_19853_.f_46443_) {
            return;
        }
        for (int i = 0; i < 3; ++i) {
            if (this.getStack(i).m_41619_() || this.getStack(i).m_41613_() <= 0) continue;
            int count = this.getStack(i).m_41613_();
            EnchantmentData data = ModularEnchantments.addBook(this.enabledTypes, this.getEnchant(i), this.getStack(i));
            if (this.getStack(i).m_41613_() == count) continue;
            boolean valid = true;
            for (int j = 0; j < 3; ++j) {
                if (i == j) continue;
                EnchantmentData data2 = this.getEnchant(j);
                if (data.getEnchant() == null || data2.getEnchant() == null || data.getEnchant() != data2.getEnchant()) continue;
                data.setEnchantment(null);
                ItemStack stack = this.getStack(i);
                stack.m_41769_(1);
                valid = false;
                break;
            }
            if (valid && this.getStack(i).m_41613_() <= 0) {
                this.setStack(i, ItemStack.f_41583_);
            }
            this.setEnchant(i, data);
        }
    }

    public void damageEnchant(ModularEnchantments.EnchantmentType type, int dmg) {
        for (int i = 0; i < 3; ++i) {
            EnchantmentData data = this.getEnchant(i);
            if (data.getEnchant() == null || ModularEnchantments.getType(data.getEnchant()) != type) continue;
            data.damageEnchant(dmg);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawBackground(PoseStack matrixStack, GuiMinecart gui, int x, int y) {
        ResourceHelper.bindResource("/gui/enchant.png");
        for (int i = 0; i < 3; ++i) {
            int[] box = this.getBoxRect(i);
            if (this.inRect(x, y, box)) {
                this.drawImage(matrixStack, gui, box, 65, 0);
            } else {
                this.drawImage(matrixStack, gui, box, 0, 0);
            }
            EnchantmentData data = this.getEnchant(i);
            if (data.getEnchant() == null) continue;
            int maxlevel = data.getEnchant().m_6586_();
            int value = data.getValue();
            for (int j = 0; j < maxlevel; ++j) {
                int[] bar = this.getBarRect(i, j, maxlevel);
                if (j != maxlevel - 1) {
                    this.drawImage(matrixStack, gui, bar[0] + bar[2], bar[1], 61 + j, 1, 1, bar[3]);
                }
                int levelmaxvalue = ModularEnchantments.getValue(data.getEnchant(), j + 1);
                if (value > 0) {
                    float mult = (float)value / (float)levelmaxvalue;
                    if (mult > 1.0f) {
                        mult = 1.0f;
                    }
                    bar[2] = (int)((float)bar[2] * mult);
                    this.drawImage(matrixStack, gui, bar, 1, 13 + 11 * j);
                }
                value -= levelmaxvalue;
            }
        }
    }

    @Override
    public void drawMouseOver(PoseStack matrixStack, GuiMinecart gui, int x, int y) {
        for (int i = 0; i < 3; ++i) {
            EnchantmentData data = this.getEnchant(i);
            String str = data.getEnchant() != null ? data.getInfoText() : Localization.MODULES.ADDONS.ENCHANT_INSTRUCTION.translate(new String[0]);
            this.drawStringOnMouseOver(matrixStack, gui, str, x, y, this.getBoxRect(i));
        }
    }

    private int[] getBoxRect(int id) {
        return new int[]{40, 17 + id * 20, 61, 12};
    }

    private int[] getBarRect(int id, int barid, int maxlevel) {
        int width = (59 - (maxlevel - 1)) / maxlevel;
        return new int[]{41 + (width + 1) * barid, 18 + id * 20, width, 10};
    }

    @Override
    public int numberOfGuiData() {
        return 9;
    }

    @Override
    protected void Save(CompoundTag nbt, int id) {
        super.Save(nbt, id);
        for (int i = 0; i < 3; ++i) {
            EnchantmentData data = this.getEnchant(i);
            if (data.getEnchant() == null) continue;
            nbt.m_128359_(this.generateNBTName("EffectId" + i, id), ForgeRegistries.ENCHANTMENTS.getKey((Object)data.getEnchant()).toString());
            nbt.m_128405_(this.generateNBTName("Value" + i, id), data.getValue());
        }
    }

    @Override
    protected void Load(CompoundTag nbt, int id) {
        super.Load(nbt, id);
        for (int i = 0; i < 3; ++i) {
            if (!nbt.m_128441_(this.generateNBTName("EffectId" + i, id))) continue;
            EnchantmentData data = new EnchantmentData((Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation(nbt.m_128461_(this.generateNBTName("EffectId" + i, id)))));
            data.setValue(nbt.m_128451_(this.generateNBTName("Value" + i, id)));
            this.setEnchant(i, data);
        }
    }

    @Override
    public int guiWidth() {
        return 110;
    }

    public void addType(ModularEnchantments.EnchantmentType type) {
        this.enabledTypes.add(type);
    }
}

