/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.modules.addons;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.world.entity.player.Player;
import vswe.stevescarts.client.guis.GuiMinecart;
import vswe.stevescarts.entities.CartDataSerializers;
import vswe.stevescarts.entities.EntityMinecartModular;
import vswe.stevescarts.helpers.Localization;
import vswe.stevescarts.helpers.ResourceHelper;
import vswe.stevescarts.modules.addons.ModuleAddon;

public class ModuleColorizer
extends ModuleAddon {
    private int markerOffsetX = 10;
    private int scrollWidth = 64;
    private int markerMoving = -1;
    private EntityDataAccessor<int[]> COLORS;

    public ModuleColorizer(EntityMinecartModular cart) {
        super(cart);
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public boolean hasSlots() {
        return false;
    }

    @Override
    public void drawForeground(PoseStack matrixStack, GuiMinecart gui) {
        this.drawString(matrixStack, gui, this.getModuleName(), 8, 6, 0x404040);
    }

    @Override
    public int guiWidth() {
        return 125;
    }

    @Override
    public int guiHeight() {
        return 75;
    }

    private int[] getMovableMarker(int i) {
        return new int[]{this.markerOffsetX + (int)((float)this.scrollWidth * ((float)this.getColorVal(i) / 255.0f)) - 2, 17 + i * 20, 4, 13};
    }

    private int[] getArea(int i) {
        return new int[]{this.markerOffsetX, 20 + i * 20, this.scrollWidth, 7};
    }

    @Override
    public void drawBackground(PoseStack matrixStack, GuiMinecart gui, int x, int y) {
        ResourceHelper.bindResource("/gui/color.png");
        for (int i = 0; i < 3; ++i) {
            this.drawMarker(matrixStack, gui, x, y, i);
        }
        float[] color = this.getColor();
        this.drawImage(matrixStack, gui, this.scrollWidth + 25, 29, 4, 7, 28, 28);
    }

    @Override
    public void drawMouseOver(PoseStack matrixStack, GuiMinecart gui, int x, int y) {
        String[] colorNames = new String[]{Localization.MODULES.ADDONS.COLOR_RED.translate(new String[0]), Localization.MODULES.ADDONS.COLOR_GREEN.translate(new String[0]), Localization.MODULES.ADDONS.COLOR_BLUE.translate(new String[0])};
        for (int i = 0; i < 3; ++i) {
            this.drawStringOnMouseOver(matrixStack, gui, colorNames[i] + ": " + this.getColorVal(i), x, y, this.getArea(i));
        }
    }

    private void drawMarker(PoseStack matrixStack, GuiMinecart gui, int x, int y, int id) {
        float[] colorArea = new float[3];
        float[] colorMarker = new float[3];
        for (int i = 0; i < 3; ++i) {
            if (i == id) {
                colorArea[i] = 0.7f;
                colorMarker[i] = 1.0f;
                continue;
            }
            colorArea[i] = 0.2f;
            colorMarker[i] = 0.0f;
        }
        this.drawImage(matrixStack, gui, this.getArea(id), 0, 0);
        this.drawImage(matrixStack, gui, this.getMovableMarker(id), 0, 7);
    }

    @Override
    public void mouseClicked(GuiMinecart gui, int x, int y, int button) {
        if (button == 0) {
            for (int i = 0; i < 3; ++i) {
                if (!this.inRect(x, y, this.getMovableMarker(i))) continue;
                this.markerMoving = i;
            }
        }
    }

    @Override
    public void mouseMovedOrUp(GuiMinecart gui, int x, int y, int button) {
        if (this.markerMoving != -1) {
            int tempColor = (int)((float)(x - this.markerOffsetX) / ((float)this.scrollWidth / 255.0f));
            if (tempColor < 0) {
                tempColor = 0;
            } else if (tempColor > 255) {
                tempColor = 255;
            }
            this.sendPacket(this.markerMoving, (byte)tempColor);
        }
        if (button != -1) {
            this.markerMoving = -1;
        }
    }

    @Override
    public int numberOfDataWatchers() {
        return 3;
    }

    @Override
    public void initDw() {
        this.COLORS = this.createDw(CartDataSerializers.VARINT);
        this.registerDw(this.COLORS, new int[]{255, 255, 255});
    }

    @Override
    public int numberOfPackets() {
        return 3;
    }

    @Override
    protected void receivePacket(int id, byte[] data, Player player) {
        if (id >= 0 && id < 3) {
            this.setColorVal(id, data[0]);
        }
    }

    public int getColorVal(int i) {
        if (this.isPlaceholder()) {
            return 255;
        }
        int tempVal = this.getDw(this.COLORS)[i];
        if (tempVal < 0) {
            tempVal += 256;
        }
        return tempVal;
    }

    public void setColorVal(int id, int val) {
        int[] colors = this.getDw(this.COLORS);
        colors[id] = val;
        this.updateDw(this.COLORS, colors);
    }

    private float getColorComponent(int i) {
        return (float)this.getColorVal(i) / 255.0f;
    }

    @Override
    public float[] getColor() {
        return new float[]{this.getColorComponent(0), this.getColorComponent(1), this.getColorComponent(2)};
    }

    @Override
    protected void Save(CompoundTag tagCompound, int id) {
        tagCompound.m_128344_(this.generateNBTName("Red", id), (byte)this.getColorVal(0));
        tagCompound.m_128344_(this.generateNBTName("Green", id), (byte)this.getColorVal(1));
        tagCompound.m_128344_(this.generateNBTName("Blue", id), (byte)this.getColorVal(2));
    }

    @Override
    protected void Load(CompoundTag tagCompound, int id) {
        this.setColorVal(0, tagCompound.m_128445_(this.generateNBTName("Red", id)));
        this.setColorVal(1, tagCompound.m_128445_(this.generateNBTName("Green", id)));
        this.setColorVal(2, tagCompound.m_128445_(this.generateNBTName("Blue", id)));
    }
}

